/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.io.api;

import com.atlassian.performance.tools.io.api.DirectoriesKt;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001\u001a\u0010\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0006\u001a\n\u0010\u0007\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\b\u001a\u00020\u0006*\u00020\u0006\u001a\u0012\u0010\t\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"copy", "Ljava/nio/file/Path;", "Ljava/io/InputStream;", "target", "directories", "", "Ljava/io/File;", "ensureDirectory", "ensureParentDirectory", "resolveSafely", "path", "", "io"})
public final class DirectoriesKt {
    @NotNull
    public static final Path ensureDirectory(@NotNull Path $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        File file = $receiver.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"toFile()");
        Path path = DirectoriesKt.ensureDirectory(file).toPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"toFile().ensureDirectory().toPath()");
        return path;
    }

    @NotNull
    public static final Path resolveSafely(@NotNull Path $receiver, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Path path2 = $receiver.resolve(StringsKt.replace$default((String)path, (String)":", (String)"-", (boolean)false, (int)4, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"resolve(\n    path.replac\u2026 = \":\", newValue = \"-\")\n)");
        return path2;
    }

    @NotNull
    public static final File ensureParentDirectory(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        File file = $receiver.getParentFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"parentFile");
        DirectoriesKt.ensureDirectory(file);
        return $receiver;
    }

    @NotNull
    public static final File ensureDirectory(@NotNull File $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        if (!$receiver.isDirectory()) {
            if ($receiver.exists()) {
                throw (Throwable)new RuntimeException($receiver + " already exists and is not a directory");
            }
            boolean creationSuccessful = $receiver.mkdirs();
            if (!creationSuccessful && !$receiver.isDirectory()) {
                throw (Throwable)new RuntimeException("Failed to ensure that " + $receiver + " is a directory");
            }
        }
        return $receiver;
    }

    @NotNull
    public static final List<File> directories(@NotNull File $receiver) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
                object = $receiver.listFiles(directories.1.INSTANCE);
                if (object == null || (object = ArraysKt.toList((Object[])object)) == null) break block2;
                Iterable $receiver$iv = (Iterable)object;
                Iterable iterable = $receiver$iv;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        File it = (File)a;
                        boolean bl = false;
                        File file = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                        it = (File)b;
                        Comparable comparable = (Comparable)((Object)file.getAbsolutePath());
                        bl = false;
                        File file2 = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                        String string = file2.getAbsolutePath();
                        return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                    }
                };
                object = CollectionsKt.sortedWith((Iterable)iterable, (Comparator)comparator);
                if (object != null) break block3;
            }
            throw (Throwable)new Exception("Cannot list directories from " + $receiver);
        }
        return object;
    }

    @NotNull
    public static final Path copy(@NotNull InputStream $receiver, @NotNull Path target) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        File file = target.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"target.toFile()");
        DirectoriesKt.ensureParentDirectory(file);
        Files.copy($receiver, target, StandardCopyOption.REPLACE_EXISTING);
        return target;
    }
}

