/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.database;

import com.atlassian.performance.tools.infrastructure.database.SshSqlClient;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\tH\u0016J\u0014\u0010\n\u001a\u00020\t*\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0014\u0010\r\u001a\u00020\t*\u00020\t2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/performance/tools/infrastructure/database/SshMysqlClient;", "Lcom/atlassian/performance/tools/infrastructure/database/SshSqlClient;", "()V", "runSql", "Lcom/atlassian/performance/tools/ssh/api/SshConnection$SshResult;", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "sql", "Ljava/io/File;", "", "escape", "character", "", "quote", "infrastructure"})
public final class SshMysqlClient
implements SshSqlClient {
    @Override
    @NotNull
    public SshConnection.SshResult runSql(@NotNull SshConnection ssh, @NotNull String sql) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        String quotedSql = this.quote(sql, '\"');
        return ssh.execute("mysql -h 127.0.0.1 -u root -e " + quotedSql);
    }

    @Override
    @NotNull
    public SshConnection.SshResult runSql(@NotNull SshConnection ssh, @NotNull File sql) {
        String remoteSqlFile;
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)sql, (String)"sql");
        String string = remoteSqlFile = sql.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"remoteSqlFile");
        ssh.upload(sql, string);
        SshConnection.SshResult result = ssh.execute("mysql -h 127.0.0.1 -u root < " + remoteSqlFile);
        ssh.execute("rm " + remoteSqlFile);
        return result;
    }

    private final String quote(@NotNull String $receiver, char quote) {
        char c = quote;
        String string = this.escape($receiver, quote);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = String.valueOf(c) + string;
        return stringBuilder.append(string2).append(quote).toString();
    }

    private final String escape(@NotNull String $receiver, char character) {
        return StringsKt.replace$default((String)$receiver, (String)String.valueOf(character), (String)("" + '\\' + character), (boolean)false, (int)4, null);
    }
}

