/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.virtualusers;

import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.MulticastVirtualUsers;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.VirtualUsers;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserLoad;
import com.atlassian.performance.tools.virtualusers.api.VirtualUserOptions;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserBehavior;
import com.atlassian.performance.tools.virtualusers.api.config.VirtualUserTarget;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\fH\u0016J \u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J*\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\f0\u001bH\u0002R\u0016\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001c"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/MulticastVirtualUsers;", "T", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/VirtualUsers;", "nodes", "", "(Ljava/util/List;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "getNodes", "()Ljava/util/List;", "applyLoad", "", "options", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserOptions;", "applySlicedLoad", "loadSlices", "Lcom/atlassian/performance/tools/virtualusers/api/VirtualUserLoad;", "gatherResults", "logEstimatedFinish", "load", "nodeCount", "", "multicast", "label", "", "operation", "Lkotlin/Function2;", "infrastructure"})
public final class MulticastVirtualUsers<T extends VirtualUsers>
implements VirtualUsers {
    private final Logger logger;
    @NotNull
    private final List<T> nodes;

    @Override
    public void gatherResults() {
        this.multicast("gatherResults", gatherResults.1.INSTANCE);
    }

    /*
     * WARNING - void declaration
     */
    private final void multicast(String label, Function2<? super T, ? super Integer, Unit> operation) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        ExecutorService executor = Executors.newFixedThreadPool(this.nodes.size(), new ThreadFactoryBuilder().setNameFormat("multicast-virtual-users-" + label + "-thread-%d").build());
        Iterable iterable = this.nodes;
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        int index$iv$iv = 0;
        for (Object item$iv$iv : $receiver$iv$iv) {
            void node;
            void index;
            int n = index$iv$iv++;
            VirtualUsers virtualUsers = (VirtualUsers)item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            ExecutorService executorService = executor;
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
            CompletableFuture completableFuture = TaskContextKt.submitWithLogContext((ExecutorService)executorService, (String)(label + " node-" + (int)(index + true)), (Function0)((Function0)new Function0<Unit>((VirtualUsers)node, (int)index, executor, label, operation){
                final /* synthetic */ VirtualUsers $node;
                final /* synthetic */ int $index;
                final /* synthetic */ ExecutorService $executor$inlined;
                final /* synthetic */ String $label$inlined;
                final /* synthetic */ Function2 $operation$inlined;
                {
                    this.$node = virtualUsers;
                    this.$index = n;
                    this.$executor$inlined = executorService;
                    this.$label$inlined = string;
                    this.$operation$inlined = function2;
                    super(0);
                }

                public final void invoke() {
                    try {
                        this.$operation$inlined.invoke((Object)this.$node, (Object)this.$index);
                    }
                    catch (Exception e) {
                        throw (Throwable)new Exception(this.$label$inlined + " failed on " + this.$node, e);
                    }
                }
            }));
            collection.add(completableFuture);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            CompletableFuture it = (CompletableFuture)element$iv;
            it.get();
        }
        executor.shutdownNow();
    }

    @Override
    public void applyLoad(@NotNull VirtualUserOptions options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        int nodeCount = this.nodes.size();
        VirtualUserLoad load = options.getBehavior().getLoad();
        int virtualUsers = load.getVirtualUsers();
        if (nodeCount > virtualUsers) {
            throw (Throwable)new Exception(virtualUsers + " virtual users are not enough to spread into " + nodeCount + " nodes");
        }
        List loadSlices = load.slice(nodeCount);
        this.logEstimatedFinish(load, options, nodeCount);
        this.applySlicedLoad(loadSlices, options);
    }

    private final void logEstimatedFinish(VirtualUserLoad load, VirtualUserOptions options, int nodeCount) {
        Duration estimatedDuration = load.getTotal().plus(options.getBehavior().getMaxOverhead());
        String durationText = "" + '~' + estimatedDuration.toMinutes() + 'm';
        String finishText = LocalDateTime.now().plus(estimatedDuration).truncatedTo(ChronoUnit.MINUTES).format(DateTimeFormatter.ISO_LOCAL_TIME);
        this.logger.info("Applying load using " + nodeCount + " nodes for " + durationText + ", should finish by " + finishText + "...");
    }

    private final void applySlicedLoad(List<VirtualUserLoad> loadSlices, VirtualUserOptions options) {
        ConcurrentHashMap.KeySetView activeNodes = ConcurrentHashMap.newKeySet();
        this.multicast("apply load", (Function2)new Function2<T, Integer, Unit>(this, activeNodes, options, loadSlices){
            final /* synthetic */ MulticastVirtualUsers this$0;
            final /* synthetic */ ConcurrentHashMap.KeySetView $activeNodes;
            final /* synthetic */ VirtualUserOptions $options;
            final /* synthetic */ List $loadSlices;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke(@NotNull T node, int index) {
                VirtualUserOptions virtualUserOptions;
                Intrinsics.checkParameterIsNotNull(node, (String)"node");
                this.$activeNodes.add(node);
                VirtualUserBehavior.Builder builder = new VirtualUserBehavior.Builder(this.$options.getBehavior()).load((VirtualUserLoad)this.$loadSlices.get(index));
                VirtualUserTarget virtualUserTarget = this.$options.getTarget();
                VirtualUserOptions virtualUserOptions2 = virtualUserOptions;
                VirtualUserOptions virtualUserOptions3 = virtualUserOptions;
                VirtualUserBehavior.Builder it = builder;
                VirtualUserBehavior.Builder builder2 = index > 0 ? it.skipSetup(true) : it;
                virtualUserOptions2(virtualUserTarget, builder2.build());
                VirtualUserOptions nodeOptions = virtualUserOptions3;
                try {
                    node.applyLoad(nodeOptions);
                }
                finally {
                    this.$activeNodes.remove(node);
                    MulticastVirtualUsers.access$getLogger$p(this.this$0).info("Remaining active virtual user nodes: " + this.$activeNodes.size());
                    MulticastVirtualUsers.access$getLogger$p(this.this$0).debug("Remaining active virtual user nodes: " + this.$activeNodes);
                }
            }
            {
                this.this$0 = multicastVirtualUsers;
                this.$activeNodes = keySetView;
                this.$options = virtualUserOptions;
                this.$loadSlices = list;
                super(2);
            }
        });
    }

    @NotNull
    public final List<T> getNodes() {
        return this.nodes;
    }

    public MulticastVirtualUsers(@NotNull List<? extends T> nodes) {
        Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
        this.nodes = nodes;
        this.logger = LogManager.getLogger(this.getClass());
    }

    public static final /* synthetic */ Logger access$getLogger$p(MulticastVirtualUsers $this) {
        return $this.logger;
    }
}

