/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.splunk;

import com.atlassian.performance.tools.infrastructure.api.docker.DockerContainer;
import com.atlassian.performance.tools.infrastructure.api.splunk.SplunkForwarder;
import com.atlassian.performance.tools.infrastructure.splunk.Log4jJsonifier;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u000e\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J \u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/splunk/UniversalSplunkForwarder;", "Lcom/atlassian/performance/tools/infrastructure/api/splunk/SplunkForwarder;", "splunkServerIp", "", "managementPort", "", "httpEventCollectorPort", "indexingReceiverPort", "(Ljava/lang/String;III)V", "getRequiredPorts", "", "jsonifyLog4j", "", "sshConnection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "log4jPropertiesPath", "run", "name", "logsPath", "infrastructure"})
public final class UniversalSplunkForwarder
implements SplunkForwarder {
    private final String splunkServerIp;
    private final int managementPort;
    private final int httpEventCollectorPort;
    private final int indexingReceiverPort;

    @Override
    public void run(@NotNull SshConnection sshConnection, @NotNull String name, @NotNull String logsPath) {
        Intrinsics.checkParameterIsNotNull((Object)sshConnection, (String)"sshConnection");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)logsPath, (String)"logsPath");
        new DockerContainer.Builder().imageName("splunk/universalforwarder:6.5.3-monitor").parameters("--hostname " + name, "-p " + this.managementPort + ':' + this.managementPort, "-p " + this.httpEventCollectorPort + ':' + this.httpEventCollectorPort, "-p " + this.indexingReceiverPort + ':' + this.indexingReceiverPort, "--env SPLUNK_FORWARD_SERVER='" + this.splunkServerIp + ':' + this.indexingReceiverPort + '\'', "--env SPLUNK_ADD='monitor /var/log/jiralogs/'", "--env SPLUNK_START_ARGS='--accept-license'", "--env SPLUNK_USER=root", "--volume " + logsPath + ":/var/log/jiralogs/", "--volume /var/lib/docker/containers:/host/containers:ro", "--volume /var/log:/docker/log:ro", "--volume /var/run/docker.sock:/var/run/docker.sock:ro").build().run(sshConnection);
    }

    @Override
    public void jsonifyLog4j(@NotNull SshConnection sshConnection, @NotNull String log4jPropertiesPath) {
        Intrinsics.checkParameterIsNotNull((Object)sshConnection, (String)"sshConnection");
        Intrinsics.checkParameterIsNotNull((Object)log4jPropertiesPath, (String)"log4jPropertiesPath");
        new Log4jJsonifier().jsonifyLog4j1(sshConnection, log4jPropertiesPath);
    }

    @Override
    @NotNull
    public List<Integer> getRequiredPorts() {
        return CollectionsKt.listOf((Object[])new Integer[]{this.managementPort, this.httpEventCollectorPort, this.indexingReceiverPort});
    }

    public UniversalSplunkForwarder(@NotNull String splunkServerIp, int managementPort, int httpEventCollectorPort, int indexingReceiverPort) {
        Intrinsics.checkParameterIsNotNull((Object)splunkServerIp, (String)"splunkServerIp");
        this.splunkServerIp = splunkServerIp;
        this.managementPort = managementPort;
        this.httpEventCollectorPort = httpEventCollectorPort;
        this.indexingReceiverPort = indexingReceiverPort;
    }

    public /* synthetic */ UniversalSplunkForwarder(String string, int n, int n2, int n3, int n4, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n4 & 2) != 0) {
            n = 8089;
        }
        if ((n4 & 4) != 0) {
            n2 = 8088;
        }
        if ((n4 & 8) != 0) {
            n3 = 9997;
        }
        this(string, n, n2, n3);
    }
}

