/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.splunk;

import com.atlassian.performance.tools.infrastructure.api.splunk.SplunkForwarder;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0096\u0001J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0016J!\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0096\u0001J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/splunk/Log4j2SplunkForwarder;", "Lcom/atlassian/performance/tools/infrastructure/api/splunk/SplunkForwarder;", "log4j2ConfigFileName", "", "splunkForwarder", "(Ljava/lang/String;Lcom/atlassian/performance/tools/infrastructure/api/splunk/SplunkForwarder;)V", "getRequiredPorts", "", "", "jsonifyLog4j", "", "sshConnection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "log4jPropertiesPath", "run", "name", "logsPath", "tryToJsonify", "", "ssh", "log4jPath", "infrastructure"})
public final class Log4j2SplunkForwarder
implements SplunkForwarder {
    private final String log4j2ConfigFileName;
    private final SplunkForwarder splunkForwarder;

    @Override
    public void jsonifyLog4j(@NotNull SshConnection sshConnection, @NotNull String log4jPropertiesPath) {
        Intrinsics.checkParameterIsNotNull((Object)sshConnection, (String)"sshConnection");
        Intrinsics.checkParameterIsNotNull((Object)log4jPropertiesPath, (String)"log4jPropertiesPath");
        String log4j2PropertiesPath = ((Object)Paths.get(log4jPropertiesPath, new String[0]).resolveSibling(this.log4j2ConfigFileName)).toString();
        Throwable log4j1Fail = this.tryToJsonify(sshConnection, log4jPropertiesPath);
        Throwable log4j2Fail = this.tryToJsonify(sshConnection, log4j2PropertiesPath);
        if (log4j1Fail != null && log4j2Fail != null) {
            log4j1Fail.addSuppressed(log4j2Fail);
            throw log4j1Fail;
        }
    }

    private final Throwable tryToJsonify(SshConnection ssh, String log4jPath) {
        Exception exception;
        try {
            this.splunkForwarder.jsonifyLog4j(ssh, log4jPath);
            exception = null;
        }
        catch (Exception e) {
            exception = e;
        }
        return exception;
    }

    public Log4j2SplunkForwarder(@NotNull String log4j2ConfigFileName, @NotNull SplunkForwarder splunkForwarder) {
        Intrinsics.checkParameterIsNotNull((Object)log4j2ConfigFileName, (String)"log4j2ConfigFileName");
        Intrinsics.checkParameterIsNotNull((Object)splunkForwarder, (String)"splunkForwarder");
        this.log4j2ConfigFileName = log4j2ConfigFileName;
        this.splunkForwarder = splunkForwarder;
    }

    @Override
    @NotNull
    public List<Integer> getRequiredPorts() {
        return this.splunkForwarder.getRequiredPorts();
    }

    @Override
    public void run(@NotNull SshConnection sshConnection, @NotNull String name, @NotNull String logsPath) {
        Intrinsics.checkParameterIsNotNull((Object)sshConnection, (String)"sshConnection");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)logsPath, (String)"logsPath");
        this.splunkForwarder.run(sshConnection, name, logsPath);
    }
}

