/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.profiler;

import com.atlassian.performance.tools.infrastructure.api.process.RemoteMonitoringProcess;
import com.atlassian.performance.tools.infrastructure.api.profiler.Profiler;
import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import com.atlassian.performance.tools.jvmtasks.api.IdempotentAction;
import com.atlassian.performance.tools.jvmtasks.api.StaticBackoff;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0012\u0013B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B+\b\u0002\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/profiler/AsyncProfiler;", "Lcom/atlassian/performance/tools/infrastructure/api/profiler/Profiler;", "()V", "startParams", "", "", "stopParams", "outputFile", "(Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "release", "install", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "start", "Lcom/atlassian/performance/tools/infrastructure/api/process/RemoteMonitoringProcess;", "pid", "", "Builder", "ProfilerProcess", "infrastructure"})
public final class AsyncProfiler
implements Profiler {
    private final String release = "async-profiler-2.10-linux-x64";
    private final List<String> startParams;
    private final List<String> stopParams;
    private final String outputFile;

    @Override
    public void install(@NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        String tarGz = this.release + ".tar.gz";
        ssh.execute("wget -q https://github.com/async-profiler/async-profiler/releases/download/v2.10/" + tarGz);
        ssh.execute("tar --extract --gzip --file " + tarGz);
        ssh.execute("sudo sh -c 'echo 1 > /proc/sys/kernel/perf_event_paranoid'");
        ssh.execute("sudo sh -c 'echo 0 > /proc/sys/kernel/kptr_restrict'");
    }

    @Override
    @NotNull
    public RemoteMonitoringProcess start(@NotNull SshConnection ssh, int pid) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        String script = "./" + this.release + "/bin/asprof";
        String params = CollectionsKt.joinToString$default((Iterable)this.startParams, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
        IdempotentAction idempotentAction = new IdempotentAction("start async-profiler", (Function0)new Function0<SshConnection.SshResult>(ssh, script, params, pid){
            final /* synthetic */ SshConnection $ssh;
            final /* synthetic */ String $script;
            final /* synthetic */ String $params;
            final /* synthetic */ int $pid;

            @NotNull
            public final SshConnection.SshResult invoke() {
                return this.$ssh.execute(this.$script + " start " + this.$params + ' ' + this.$pid);
            }
            {
                this.$ssh = sshConnection;
                this.$script = string;
                this.$params = string2;
                this.$pid = n;
                super(0);
            }
        });
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofSeconds(5)");
        idempotentAction.retry(2, (Backoff)new StaticBackoff(duration));
        return new ProfilerProcess(script, pid, this.stopParams, this.outputFile);
    }

    private AsyncProfiler(List<String> startParams, List<String> stopParams, String outputFile) {
        this.startParams = startParams;
        this.stopParams = stopParams;
        this.outputFile = outputFile;
        this.release = "async-profiler-2.10-linux-x64";
    }

    @Deprecated(message="Use AsyncProfiler.Builder instead")
    public AsyncProfiler() {
        this(CollectionsKt.emptyList(), CollectionsKt.emptyList(), "flamegraph.html");
    }

    public /* synthetic */ AsyncProfiler(@NotNull List startParams, @NotNull List stopParams, @NotNull String outputFile, DefaultConstructorMarker $constructor_marker) {
        this(startParams, stopParams, outputFile);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00030\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/profiler/AsyncProfiler$ProfilerProcess;", "Lcom/atlassian/performance/tools/infrastructure/api/process/RemoteMonitoringProcess;", "script", "", "pid", "", "stopParams", "", "outputFile", "(Ljava/lang/String;ILjava/util/List;Ljava/lang/String;)V", "getResultPath", "stop", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "infrastructure"})
    private static final class ProfilerProcess
    implements RemoteMonitoringProcess {
        private final String script;
        private final int pid;
        private final List<String> stopParams;
        private final String outputFile;

        @Override
        public void stop(@NotNull SshConnection ssh) {
            Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
            String params = CollectionsKt.joinToString$default((Iterable)this.stopParams, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null);
            String string = this.script + " stop " + this.pid + ' ' + params;
            Duration duration = Duration.ofSeconds(50L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofSeconds(50)");
            ssh.execute(string, duration);
        }

        @Override
        @NotNull
        public String getResultPath() {
            return this.outputFile;
        }

        public ProfilerProcess(@NotNull String script, int pid, @NotNull List<String> stopParams, @NotNull String outputFile) {
            Intrinsics.checkParameterIsNotNull((Object)script, (String)"script");
            Intrinsics.checkParameterIsNotNull(stopParams, (String)"stopParams");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            this.script = script;
            this.pid = pid;
            this.stopParams = stopParams;
            this.outputFile = outputFile;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\r\u001a\u00020\u000eJ!\u0010\u000f\u001a\u00020\u00002\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0010\"\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u001f\u0010\b\u001a\u00020\u00002\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0010\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0011J\u001f\u0010\n\u001a\u00020\u00002\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0010\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0011J\u0006\u0010\u000b\u001a\u00020\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/profiler/AsyncProfiler$Builder;", "", "()V", "interval", "Ljava/time/Duration;", "outputFile", "", "outputFormat", "startParams", "", "stopParams", "wallClockMode", "", "build", "Lcom/atlassian/performance/tools/infrastructure/api/profiler/Profiler;", "extraParams", "", "([Ljava/lang/String;)Lcom/atlassian/performance/tools/infrastructure/api/profiler/AsyncProfiler$Builder;", "flamegraph", "jfr", "output", "infrastructure"})
    public static final class Builder {
        private String outputFormat = "flamegraph";
        private String outputFile = "flamegraph.html";
        private final List<String> startParams;
        private final List<String> stopParams;
        private boolean wallClockMode;
        private Duration interval;

        @NotNull
        public final Builder outputFile(@NotNull String outputFile) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            Builder $receiver = builder = this;
            $receiver.outputFile = outputFile;
            return builder;
        }

        @NotNull
        public final Builder output(@NotNull String outputFormat, @NotNull String outputFile) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)outputFormat, (String)"outputFormat");
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            Builder $receiver = builder = this;
            $receiver.outputFormat = outputFormat;
            $receiver.outputFile = outputFile;
            return builder;
        }

        @NotNull
        public final Builder jfr(@NotNull String outputFile) {
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            return this.output("jfr", outputFile);
        }

        @NotNull
        public final Builder flamegraph(@NotNull String outputFile) {
            Intrinsics.checkParameterIsNotNull((Object)outputFile, (String)"outputFile");
            return this.output("flamegraph", outputFile);
        }

        @NotNull
        public final Builder wallClockMode() {
            Builder builder;
            Builder $receiver = builder = this;
            $receiver.wallClockMode = true;
            return builder;
        }

        @NotNull
        public final Builder interval(@NotNull Duration interval) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)interval, (String)"interval");
            Builder $receiver = builder = this;
            if (interval.compareTo(Duration.ofSeconds(1L)) >= 0) {
                throw (Throwable)new Exception("The interval " + interval + " seems to big. Usually it's counted in milliseconds or nanoseconds. Try an interval under a second.");
            }
            $receiver.interval = interval;
            return builder;
        }

        @Deprecated(message="use startParams instead", replaceWith=@ReplaceWith(imports={}, expression="startParams(extraParams)"))
        @NotNull
        public final Builder extraParams(String ... extraParams) {
            Intrinsics.checkParameterIsNotNull((Object)extraParams, (String)"extraParams");
            return this.startParams(Arrays.copyOf(extraParams, extraParams.length));
        }

        @NotNull
        public final Builder startParams(String ... startParams) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)startParams, (String)"startParams");
            Builder $receiver = builder = this;
            CollectionsKt.addAll((Collection)$receiver.startParams, (Object[])startParams);
            return builder;
        }

        @NotNull
        public final Builder stopParams(String ... stopParams) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)stopParams, (String)"stopParams");
            Builder $receiver = builder = this;
            CollectionsKt.addAll((Collection)$receiver.stopParams, (Object[])stopParams);
            return builder;
        }

        @NotNull
        public final Profiler build() {
            List startParamsCopy = CollectionsKt.filterNotNull((Iterable)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)this.startParams, (Object)(this.wallClockMode ? "-e wall" : null)), (Object)("-i " + this.interval.getNano())), (Object)("-o " + this.outputFormat)), (Object)("-f " + this.outputFile)));
            List stopParamsCopy = CollectionsKt.plus((Collection)this.stopParams, (Object)("-o " + this.outputFormat + " -f " + this.outputFile));
            return new AsyncProfiler(startParamsCopy, stopParamsCopy, this.outputFile, null);
        }

        public Builder() {
            List list;
            Builder builder = this;
            builder.startParams = list = (List)new ArrayList();
            builder = this;
            builder.stopParams = list = (List)new ArrayList();
            Duration duration = Duration.ofMillis(10L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofMillis(10)");
            this.interval = duration;
        }
    }
}

