/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.os;

import com.atlassian.performance.tools.infrastructure.api.dataset.FileArchiver;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.ssh.api.SshHost;
import java.io.Closeable;
import java.io.File;
import java.nio.file.Path;
import java.time.Duration;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\bJ\u0006\u0010\u0019\u001a\u00020\u0003J\b\u0010\u001a\u001a\u00020\bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/os/RemotePath;", "", "json", "Ljavax/json/JsonObject;", "(Ljavax/json/JsonObject;)V", "host", "Lcom/atlassian/performance/tools/ssh/api/SshHost;", "path", "", "(Lcom/atlassian/performance/tools/ssh/api/SshHost;Ljava/lang/String;)V", "getHost", "()Lcom/atlassian/performance/tools/ssh/api/SshHost;", "getPath", "()Ljava/lang/String;", "archive", "timeout", "Ljava/time/Duration;", "download", "Ljava/io/File;", "localDestination", "Ljava/nio/file/Path;", "move", "remoteDestination", "resolve", "other", "toJson", "toString", "infrastructure"})
public final class RemotePath {
    @NotNull
    private final SshHost host;
    @NotNull
    private final String path;

    @NotNull
    public final JsonObject toJson() {
        JsonObject jsonObject = Json.createObjectBuilder().add("host", (JsonValue)this.host.toJson()).add("path", this.path).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"Json.createObjectBuilder\u2026\", path)\n        .build()");
        return jsonObject;
    }

    @NotNull
    public final RemotePath resolve(@NotNull String other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new RemotePath(this.host, this.path + '/' + other);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RemotePath move(@NotNull String remoteDestination, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)remoteDestination, (String)"remoteDestination");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        if (Intrinsics.areEqual((Object)this.path, (Object)remoteDestination) ^ true) {
            Closeable closeable = (Closeable)new Ssh(this.host, 4).newConnection();
            Throwable throwable = null;
            try {
                SshConnection ssh = (SshConnection)closeable;
                SshConnection.SshResult sshResult = ssh.execute("sudo mv " + this.path + ' ' + remoteDestination, timeout);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        return new RemotePath(this.host, remoteDestination);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final RemotePath archive(@NotNull Duration timeout) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        Closeable closeable = (Closeable)new Ssh(this.host, 4).newConnection();
        Throwable throwable = null;
        try {
            SshConnection ssh = (SshConnection)closeable;
            string = FileArchiver.zip$default(new FileArchiver(), ssh, this.path, timeout, 0, 0, 24, null);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        String remoteZip = string;
        return new RemotePath(this.host, remoteZip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final File download(@NotNull Path localDestination) {
        Intrinsics.checkParameterIsNotNull((Object)localDestination, (String)"localDestination");
        Closeable closeable = (Closeable)new Ssh(this.host, 4).newConnection();
        Throwable throwable = null;
        try {
            SshConnection ssh = (SshConnection)closeable;
            ssh.download(this.path, localDestination);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        File file = localDestination.toFile();
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"localDestination.toFile()");
        return file;
    }

    @NotNull
    public String toString() {
        return "RemotePath(host=" + this.host + ", path='" + this.path + "')";
    }

    @NotNull
    public final SshHost getHost() {
        return this.host;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public RemotePath(@NotNull SshHost host, @NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)host, (String)"host");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.host = host;
        this.path = path;
    }

    public RemotePath(@NotNull JsonObject json) {
        Intrinsics.checkParameterIsNotNull((Object)json, (String)"json");
        JsonObject jsonObject = json.getJsonObject("host");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"json.getJsonObject(\"host\")");
        SshHost sshHost = new SshHost(jsonObject);
        String string = json.getString("path");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"json.getString(\"path\")");
        this(sshHost, string);
    }
}

