/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.jvm;

import com.atlassian.performance.tools.infrastructure.api.jvm.JdkFonts;
import com.atlassian.performance.tools.infrastructure.api.jvm.Jstat;
import com.atlassian.performance.tools.infrastructure.api.jvm.VersionedJavaDevelopmentKit;
import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import com.atlassian.performance.tools.jvmtasks.api.ExponentialBackoff;
import com.atlassian.performance.tools.jvmtasks.api.IdempotentAction;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0017B\u001f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u0003H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/jvm/VersionedOracleJdk;", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/VersionedJavaDevelopmentKit;", "majorVersion", "", "minorVersion", "patchVersion", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "downloadUrl", "javaHome", "jstatMonitoring", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/Jstat;", "getJstatMonitoring", "()Lcom/atlassian/performance/tools/infrastructure/api/jvm/Jstat;", "version", "command", "options", "getMajorVersion", "", "install", "", "connection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "use", "Builder", "infrastructure"})
public final class VersionedOracleJdk
implements VersionedJavaDevelopmentKit {
    private final String version;
    private final String downloadUrl;
    private final String javaHome;
    @NotNull
    private final Jstat jstatMonitoring;
    private final String majorVersion;
    private final String minorVersion;
    private final String patchVersion;

    @Override
    public int getMajorVersion() {
        String string = this.majorVersion;
        return Integer.parseInt(string);
    }

    @Override
    public void install(@NotNull SshConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        IdempotentAction idempotentAction = new IdempotentAction("download JDK " + this.version, (Function0)new Function0<SshConnection.SshResult>(this, connection){
            final /* synthetic */ VersionedOracleJdk this$0;
            final /* synthetic */ SshConnection $connection;

            @NotNull
            public final SshConnection.SshResult invoke() {
                String string = "curl " + VersionedOracleJdk.access$getDownloadUrl$p(this.this$0) + " > jdk-" + VersionedOracleJdk.access$getVersion$p(this.this$0) + ".tar.gz";
                Duration duration = Duration.ofSeconds(120L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofSeconds(120)");
                return this.$connection.execute(string, duration);
            }
            {
                this.this$0 = versionedOracleJdk;
                this.$connection = sshConnection;
                super(0);
            }
        });
        Duration duration = Duration.ofSeconds(10L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofSeconds(10)");
        idempotentAction.retry(3, (Backoff)new ExponentialBackoff(duration, 0.0, 2, null));
        connection.execute("tar --extract --gunzip --file jdk-" + this.version + ".tar.gz");
        connection.execute("echo '" + this.use() + "' >> ~/.profile");
        new JdkFonts().install(connection);
    }

    @Override
    @NotNull
    public String use() {
        return "export PATH=" + this.javaHome + "/bin:$PATH; export JAVA_HOME=" + this.javaHome;
    }

    @Override
    @NotNull
    public String command(@NotNull String options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        return this.javaHome + "/bin/java " + options;
    }

    @Override
    @NotNull
    public Jstat getJstatMonitoring() {
        return this.jstatMonitoring;
    }

    private VersionedOracleJdk(String majorVersion, String minorVersion, String patchVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
        this.version = this.majorVersion + '.' + this.minorVersion + '.' + this.patchVersion;
        this.downloadUrl = "https://download.oracle.com/java/" + this.majorVersion + "/archive/jdk-" + this.version + "_linux-x64_bin.tar.gz";
        this.javaHome = "~/jdk-" + this.version;
        this.jstatMonitoring = new Jstat(this.javaHome + "/bin/");
    }

    public /* synthetic */ VersionedOracleJdk(@NotNull String majorVersion, @NotNull String minorVersion, @NotNull String patchVersion, DefaultConstructorMarker $constructor_marker) {
        this(majorVersion, minorVersion, patchVersion);
    }

    @NotNull
    public static final /* synthetic */ String access$getDownloadUrl$p(VersionedOracleJdk $this) {
        return $this.downloadUrl;
    }

    @NotNull
    public static final /* synthetic */ String access$getVersion$p(VersionedOracleJdk $this) {
        return $this.version;
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/jvm/VersionedOracleJdk$Builder;", "", "()V", "majorVersion", "", "minorVersion", "patchVersion", "build", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/VersionedOracleJdk;", "version", "infrastructure"})
    public static final class Builder {
        private String majorVersion = "17";
        private String minorVersion = "0";
        private String patchVersion = "11";

        @NotNull
        public final Builder version(@NotNull String majorVersion, @NotNull String minorVersion, @NotNull String patchVersion) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)majorVersion, (String)"majorVersion");
            Intrinsics.checkParameterIsNotNull((Object)minorVersion, (String)"minorVersion");
            Intrinsics.checkParameterIsNotNull((Object)patchVersion, (String)"patchVersion");
            Builder $receiver = builder = this;
            $receiver.majorVersion = majorVersion;
            $receiver.minorVersion = minorVersion;
            $receiver.patchVersion = patchVersion;
            return builder;
        }

        @NotNull
        public final VersionedOracleJdk build() {
            return new VersionedOracleJdk(this.majorVersion, this.minorVersion, this.patchVersion, null);
        }
    }
}

