/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.jvm;

import com.atlassian.performance.tools.infrastructure.PreinstalledJDK;
import com.atlassian.performance.tools.infrastructure.api.jvm.JavaDevelopmentKit;
import com.atlassian.performance.tools.infrastructure.api.jvm.Jstat;
import com.atlassian.performance.tools.infrastructure.api.jvm.VersionedJavaDevelopmentKit;
import com.atlassian.performance.tools.infrastructure.api.os.Ubuntu;
import com.atlassian.performance.tools.infrastructure.jvm.UbuntuJavaHome;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/jvm/OpenJDK11;", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/VersionedJavaDevelopmentKit;", "()V", "jstatMonitoring", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/Jstat;", "getJstatMonitoring", "()Lcom/atlassian/performance/tools/infrastructure/api/jvm/Jstat;", "command", "", "options", "getMajorVersion", "", "install", "", "connection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "toPreinstalledJdk", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/JavaDevelopmentKit;", "use", "infrastructure"})
public final class OpenJDK11
implements VersionedJavaDevelopmentKit {
    @NotNull
    private final Jstat jstatMonitoring = new Jstat("");

    @Override
    @NotNull
    public Jstat getJstatMonitoring() {
        return this.jstatMonitoring;
    }

    @Override
    public int getMajorVersion() {
        return 11;
    }

    @Override
    public void install(@NotNull SshConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Ubuntu ubuntu = new Ubuntu();
        List list = CollectionsKt.listOf((Object)"openjdk-11-jdk");
        Duration duration = Duration.ofMinutes(5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(5)");
        ubuntu.install(connection, list, duration);
        new UbuntuJavaHome().install(connection);
    }

    @Override
    @NotNull
    public String use() {
        return new UbuntuJavaHome().use();
    }

    @Override
    @NotNull
    public String command(@NotNull String options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        return "java " + options;
    }

    @NotNull
    public final JavaDevelopmentKit toPreinstalledJdk() {
        return new PreinstalledJDK("java", this.getJstatMonitoring());
    }
}

