/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.jvm;

import com.atlassian.performance.tools.infrastructure.api.jvm.JdkFonts;
import com.atlassian.performance.tools.infrastructure.api.jvm.Jstat;
import com.atlassian.performance.tools.infrastructure.api.jvm.VersionedJavaDevelopmentKit;
import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import com.atlassian.performance.tools.jvmtasks.api.ExponentialBackoff;
import com.atlassian.performance.tools.jvmtasks.api.IdempotentAction;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.net.URI;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0018\u001a\u00020\u0004H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/jvm/AdoptOpenJDK11;", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/VersionedJavaDevelopmentKit;", "()V", "jdkArchive", "", "jdkBin", "jdkUrl", "Ljava/net/URI;", "jdkVersion", "jreBin", "jstatMonitoring", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/Jstat;", "getJstatMonitoring", "()Lcom/atlassian/performance/tools/infrastructure/api/jvm/Jstat;", "path", "command", "options", "download", "", "connection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "getMajorVersion", "", "install", "use", "infrastructure"})
public final class AdoptOpenJDK11
implements VersionedJavaDevelopmentKit {
    private final String jdkVersion = "-11.0.1+13";
    private final String jdkArchive = "OpenJDK11U-jdk_x64_linux_hotspot_11.0.1_13.tar.gz";
    private final URI jdkUrl = new URI("https://github.com/AdoptOpenJDK/openjdk11-binaries/releases/download/jdk" + this.jdkVersion + '/' + this.jdkArchive);
    private final String path = "~/jdk" + this.jdkVersion;
    private final String jreBin = this.path + "/jre/bin/";
    private final String jdkBin = this.path + "/bin/";
    @NotNull
    private final Jstat jstatMonitoring = new Jstat(this.jdkBin);

    @Override
    @NotNull
    public Jstat getJstatMonitoring() {
        return this.jstatMonitoring;
    }

    @Override
    public int getMajorVersion() {
        return 11;
    }

    @Override
    public void install(@NotNull SshConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        this.download(connection);
        connection.execute("tar -xzf " + this.jdkArchive);
        connection.execute("echo '" + this.use() + "' >> ~/.profile");
        new JdkFonts().install(connection);
    }

    @Override
    @NotNull
    public String use() {
        return "export PATH=$PATH:" + this.jreBin + ':' + this.jdkBin + " && export JAVA_HOME=" + this.path;
    }

    @Override
    @NotNull
    public String command(@NotNull String options) {
        Intrinsics.checkParameterIsNotNull((Object)options, (String)"options");
        return this.jdkBin + "java " + options;
    }

    private final void download(SshConnection connection) {
        IdempotentAction idempotentAction = new IdempotentAction("Download AdoptOpenJDK", (Function0)new Function0<SshConnection.SshResult>(this, connection){
            final /* synthetic */ AdoptOpenJDK11 this$0;
            final /* synthetic */ SshConnection $connection;

            @NotNull
            public final SshConnection.SshResult invoke() {
                String string = "curl -s -L -O -k " + AdoptOpenJDK11.access$getJdkUrl$p(this.this$0);
                Duration duration = Duration.ofMinutes(3L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(3)");
                return this.$connection.execute(string, duration);
            }
            {
                this.this$0 = adoptOpenJDK11;
                this.$connection = sshConnection;
                super(0);
            }
        });
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(5)");
        idempotentAction.retry(3, (Backoff)new ExponentialBackoff(duration, 0.0, 2, null));
    }

    @NotNull
    public static final /* synthetic */ URI access$getJdkUrl$p(AdoptOpenJDK11 $this) {
        return $this.jdkUrl;
    }
}

