/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.jira;

import com.atlassian.performance.tools.infrastructure.api.Sed;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraGcLog;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraJvmArgs;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraNodeConfig;
import com.atlassian.performance.tools.infrastructure.api.jvm.JvmArg;
import com.atlassian.performance.tools.infrastructure.api.jvm.VersionedJavaDevelopmentKit;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J&\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00172\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J \u0010\u0018\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00192\u0006\u0010\u0011\u001a\u00020\u0003H\u0002J&\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0003R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/jira/SetenvSh;", "", "jiraInstallation", "", "(Ljava/lang/String;)V", "location", "getLocation", "()Ljava/lang/String;", "sed", "Lcom/atlassian/performance/tools/infrastructure/api/Sed;", "appendArgument", "", "connection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "arg", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/JvmArg;", "assertVariableExists", "original", "variable", "Lcom/atlassian/performance/tools/infrastructure/api/jira/SetenvSh$Variables;", "replaceArgument", "setArguments", "jvmArgs", "", "setMemory", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraJvmArgs;", "setup", "config", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraNodeConfig;", "gcLog", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraGcLog;", "jiraIp", "Variables", "infrastructure"})
public final class SetenvSh {
    @NotNull
    private final String location;
    private final Sed sed;

    @NotNull
    public final String getLocation() {
        return this.location;
    }

    public final void setup(@NotNull SshConnection connection, @NotNull JiraNodeConfig config, @NotNull JiraGcLog gcLog, @NotNull String jiraIp) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)gcLog, (String)"gcLog");
        Intrinsics.checkParameterIsNotNull((Object)jiraIp, (String)"jiraIp");
        int jdkVersion = config.getJdk() instanceof VersionedJavaDevelopmentKit ? ((VersionedJavaDevelopmentKit)config.getJdk()).getMajorVersion() : 8;
        JiraJvmArgs args = config.getJvmArgs();
        String original = connection.execute("cat " + this.location).getOutput();
        this.setMemory(connection, args, original);
        List jvmArgs = args.arguments(config.getDebug(), config.getRemoteJmx(), jiraIp, jdkVersion);
        if (jdkVersion == 8) {
            jvmArgs = CollectionsKt.plus((Collection)jvmArgs, (Object)gcLog.jvmArg());
        }
        this.setArguments(connection, jvmArgs, original);
    }

    private final void assertVariableExists(String original, Variables variable) {
        if (!StringsKt.contains$default((CharSequence)original, (CharSequence)("" + (Object)((Object)variable) + '='), (boolean)false, (int)2, null)) {
            throw (Throwable)new Exception(this.location + " has no '" + (Object)((Object)variable) + "' variable definition");
        }
    }

    private final void setMemory(SshConnection connection, JiraJvmArgs jvmArgs, String original) {
        this.assertVariableExists(original, Variables.JVM_MINIMUM_MEMORY);
        this.sed.replace(connection, "" + '^' + (Object)((Object)Variables.JVM_MINIMUM_MEMORY) + "=.*$", (Object)((Object)Variables.JVM_MINIMUM_MEMORY) + "=\"" + jvmArgs.getXms() + '\"', this.location);
        this.assertVariableExists(original, Variables.JVM_MAXIMUM_MEMORY);
        this.sed.replace(connection, "" + '^' + (Object)((Object)Variables.JVM_MAXIMUM_MEMORY) + "=.*$", (Object)((Object)Variables.JVM_MAXIMUM_MEMORY) + "=\"" + jvmArgs.getXmx() + '\"', this.location);
    }

    /*
     * WARNING - void declaration
     */
    private final void setArguments(SshConnection connection, List<JvmArg> jvmArgs, String original) {
        JvmArg it;
        void $receiver$iv$iv;
        void $receiver$iv$iv2;
        Iterable $receiver$iv;
        this.assertVariableExists(original, Variables.JVM_SUPPORT_RECOMMENDED_ARGS);
        Iterable iterable = $receiver$iv = (Iterable)jvmArgs;
        Iterable<Object> destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv2) {
            JvmArg it2 = (JvmArg)element$iv$iv;
            if (!StringsKt.contains$default((CharSequence)original, (CharSequence)it2.getKey(), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List existingJvmArgs = (List)destination$iv$iv;
        Iterable $receiver$iv2 = jvmArgs;
        destination$iv$iv = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            JvmArg it3 = (JvmArg)element$iv$iv;
            if (!(!StringsKt.contains$default((CharSequence)original, (CharSequence)it3.getKey(), (boolean)false, (int)2, null))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List newJvmArgs = (List)destination$iv$iv2;
        $receiver$iv2 = existingJvmArgs;
        for (Object element$iv : $receiver$iv2) {
            it = (JvmArg)element$iv;
            this.replaceArgument(connection, it);
        }
        $receiver$iv2 = newJvmArgs;
        for (Object element$iv : $receiver$iv2) {
            it = (JvmArg)element$iv;
            this.appendArgument(connection, it);
        }
    }

    private final void replaceArgument(SshConnection connection, JvmArg arg) {
        this.sed.replace(connection, arg.getKey() + "[^ ]+", arg.getKey() + arg.getValue(), this.location);
    }

    private final void appendArgument(SshConnection connection, JvmArg arg) {
        this.sed.replace(connection, "^(" + (Object)((Object)Variables.JVM_SUPPORT_RECOMMENDED_ARGS) + ".*)\"$", "\\1 " + arg.getKey() + arg.getValue() + '\"', this.location);
    }

    public SetenvSh(@NotNull String jiraInstallation) {
        Intrinsics.checkParameterIsNotNull((Object)jiraInstallation, (String)"jiraInstallation");
        this.location = jiraInstallation + "/bin/setenv.sh";
        this.sed = new Sed();
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/jira/SetenvSh$Variables;", "", "(Ljava/lang/String;I)V", "JVM_MINIMUM_MEMORY", "JVM_MAXIMUM_MEMORY", "JVM_SUPPORT_RECOMMENDED_ARGS", "infrastructure"})
    private static final class Variables
    extends Enum<Variables> {
        public static final /* enum */ Variables JVM_MINIMUM_MEMORY;
        public static final /* enum */ Variables JVM_MAXIMUM_MEMORY;
        public static final /* enum */ Variables JVM_SUPPORT_RECOMMENDED_ARGS;
        private static final /* synthetic */ Variables[] $VALUES;

        static {
            Variables[] variablesArray = new Variables[3];
            Variables[] variablesArray2 = variablesArray;
            variablesArray[0] = JVM_MINIMUM_MEMORY = new Variables();
            variablesArray[1] = JVM_MAXIMUM_MEMORY = new Variables();
            variablesArray[2] = JVM_SUPPORT_RECOMMENDED_ARGS = new Variables();
            $VALUES = variablesArray;
        }

        public static Variables[] values() {
            return (Variables[])$VALUES.clone();
        }

        public static Variables valueOf(String string) {
            return Enum.valueOf(Variables.class, string);
        }
    }
}

