/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.distribution;

import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/distribution/TarGzDistribution;", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "tarGzPath", "", "(Ljava/lang/String;)V", "install", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "destination", "infrastructure"})
public final class TarGzDistribution
implements ProductDistribution {
    private final String tarGzPath;

    @Override
    @NotNull
    public String install(@NotNull SshConnection ssh, @NotNull String destination) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        String string = "tar --extract --gzip --file " + this.tarGzPath + " --directory " + destination;
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(1)");
        Level level = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.TRACE");
        Level level2 = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.TRACE");
        ssh.execute(string, duration, level, level2);
        String string2 = "tar --list --file " + this.tarGzPath + " | head --lines=1";
        Duration duration2 = Duration.ofMinutes(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMinutes(1)");
        String unpackedDirectory = (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)ssh.execute(string2, duration2).getOutput(), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null));
        return destination + '/' + unpackedDirectory;
    }

    public TarGzDistribution(@NotNull String tarGzPath) {
        Intrinsics.checkParameterIsNotNull((Object)tarGzPath, (String)"tarGzPath");
        this.tarGzPath = tarGzPath;
    }
}

