/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure.api.database;

import com.atlassian.performance.tools.infrastructure.api.database.Database;
import com.atlassian.performance.tools.infrastructure.api.dataset.DatasetPackage;
import com.atlassian.performance.tools.infrastructure.database.Mysql;
import com.atlassian.performance.tools.infrastructure.database.SshSqlClient;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/infrastructure/api/database/MySqlDatabase;", "Lcom/atlassian/performance/tools/infrastructure/api/database/Database;", "source", "Lcom/atlassian/performance/tools/infrastructure/api/dataset/DatasetPackage;", "(Lcom/atlassian/performance/tools/infrastructure/api/dataset/DatasetPackage;)V", "maxConnections", "", "(Lcom/atlassian/performance/tools/infrastructure/api/dataset/DatasetPackage;I)V", "setup", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "start", "", "jira", "Ljava/net/URI;", "infrastructure"})
public final class MySqlDatabase
implements Database {
    private final DatasetPackage source;
    private final int maxConnections;

    @Override
    @NotNull
    public String setup(@NotNull SshConnection ssh) {
        String mysqlDataLocation;
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        String string = mysqlDataLocation = this.source.download(ssh);
        Mysql mysql = Mysql.INSTANCE;
        String[] stringArray = new String[]{};
        mysql.container(string, stringArray, new String[]{"--skip-grant-tables", "--max_connections=" + this.maxConnections}).run(ssh);
        return mysqlDataLocation;
    }

    @Override
    public void start(@NotNull URI jira, @NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)jira, (String)"jira");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        SshSqlClient client = Mysql.INSTANCE.installClient(ssh);
        Mysql.INSTANCE.awaitDatabase(ssh);
        client.runSql(ssh, "UPDATE jiradb.propertystring SET propertyvalue = '" + jira + "' WHERE id IN (select id from jiradb.propertyentry where property_key like '%baseurl%');");
    }

    public MySqlDatabase(@NotNull DatasetPackage source, int maxConnections) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this.source = source;
        this.maxConnections = maxConnections;
    }

    public MySqlDatabase(@NotNull DatasetPackage source) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        this(source, 151);
    }
}

