/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure;

import com.atlassian.performance.tools.infrastructure.api.os.Ubuntu;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/infrastructure/HttpResource;", "", "uri", "Ljava/net/URI;", "(Ljava/net/URI;)V", "download", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "destination", "", "timeout", "Ljava/time/Duration;", "infrastructure"})
public final class HttpResource {
    private final URI uri;

    public final void download(@NotNull SshConnection ssh, @NotNull String destination) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Duration duration = Duration.ofMinutes(4L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(4)");
        this.download(ssh, destination, duration);
    }

    public final void download(@NotNull SshConnection ssh, @NotNull String destination, @NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
        Ubuntu ubuntu = new Ubuntu();
        List list = CollectionsKt.listOf((Object)"lftp");
        Duration duration = Duration.ofMinutes(2L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(2)");
        ubuntu.install(ssh, list, duration);
        ssh.execute("lftp -c 'set dns:order \"inet inet6\"; set net:timeout 15; set net:max-retries 50; pget -n 32 -c \"" + this.uri + "\" -o " + destination + '\'', timeout);
    }

    public HttpResource(@NotNull URI uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.uri = uri;
    }
}

