/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure;

import com.atlassian.performance.tools.infrastructure.HttpResource;
import com.atlassian.performance.tools.infrastructure.ParallelExecutor;
import com.atlassian.performance.tools.infrastructure.api.os.Ubuntu;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/performance/tools/infrastructure/ChromiumInstaller;", "", "uri", "Ljava/net/URI;", "(Ljava/net/URI;)V", "install", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "install$infrastructure", "installChromium", "installDependencies", "infrastructure"})
public final class ChromiumInstaller {
    private final URI uri;

    public final void install$infrastructure(@NotNull SshConnection ssh) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        new ParallelExecutor().execute$infrastructure((Function0)new Function0<Unit>(this, ssh){
            final /* synthetic */ ChromiumInstaller this$0;
            final /* synthetic */ SshConnection $ssh;

            public final void invoke() {
                ChromiumInstaller.access$installDependencies(this.this$0, this.$ssh);
            }
            {
                this.this$0 = chromiumInstaller;
                this.$ssh = sshConnection;
                super(0);
            }
        }, (Function0)new Function0<Unit>(this, ssh){
            final /* synthetic */ ChromiumInstaller this$0;
            final /* synthetic */ SshConnection $ssh;

            public final void invoke() {
                ChromiumInstaller.access$installChromium(this.this$0, this.$ssh);
            }
            {
                this.this$0 = chromiumInstaller;
                this.$ssh = sshConnection;
                super(0);
            }
        });
    }

    private final void installChromium(SshConnection ssh) {
        new HttpResource(this.uri).download(ssh, "chromium.zip");
        Ubuntu.install$default(new Ubuntu(), ssh, CollectionsKt.listOf((Object)"unzip"), null, 4, null);
        ssh.execute("unzip chromium.zip");
        ssh.execute("sudo ln -s `pwd`/chrome-linux/chrome /usr/bin/chrome");
    }

    private final void installDependencies(SshConnection ssh) {
        Ubuntu ubuntu = new Ubuntu();
        List list = CollectionsKt.listOf((Object[])new String[]{"libx11-xcb1", "libxcomposite1", "libxdamage1", "libxi6", "libxtst6", "libnss3", "libcups2", "libxss1", "libxrandr2", "libasound2", "libpango1.0", "libatk1.0-0", "libatk-bridge2.0", "libgtk-3-0"});
        Duration duration = Duration.ofMinutes(10L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(10)");
        ubuntu.install(ssh, list, duration);
    }

    public ChromiumInstaller(@NotNull URI uri) {
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        this.uri = uri;
    }

    public static final /* synthetic */ void access$installDependencies(ChromiumInstaller $this, @NotNull SshConnection ssh) {
        $this.installDependencies(ssh);
    }

    public static final /* synthetic */ void access$installChromium(ChromiumInstaller $this, @NotNull SshConnection ssh) {
        $this.installChromium(ssh);
    }
}

