/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.infrastructure;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.nio.charset.Charset;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.spi.JsonProvider;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.HttpClients;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0006\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\t2\u0006\u0010\u000b\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u0006H\u0002J\u0016\u0010\u000e\u001a\u0004\u0018\u00010\u0006*\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/infrastructure/ChromeForTesting;", "", "()V", "getLatestDownloadUri", "Ljava/net/URI;", "buildVersion", "", "getLatestStableDownloadUri", "parse", "Ljavax/json/JsonObject;", "kotlin.jvm.PlatformType", "json", "queryJson", "uri", "getDownloadUri", "platform", "infrastructure"})
public final class ChromeForTesting {
    public static final ChromeForTesting INSTANCE;

    @NotNull
    public final URI getLatestDownloadUri(@NotNull String buildVersion) {
        Intrinsics.checkParameterIsNotNull((Object)buildVersion, (String)"buildVersion");
        JsonObject json = this.queryJson("https://googlechromelabs.github.io/chrome-for-testing/latest-patch-versions-per-build-with-downloads.json");
        JsonObject jsonObject = json.getJsonObject("builds").getJsonObject(buildVersion);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"json.getJsonObject(\"buil\u2026tJsonObject(buildVersion)");
        String string = this.getDownloadUri(jsonObject, "linux64");
        if (string == null) {
            throw (Throwable)new Exception("Failed to find ChromeDriver download version for " + buildVersion + ". Got response: " + json);
        }
        String uri = string;
        URI uRI = URI.create(uri);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(uri)");
        return uRI;
    }

    @NotNull
    public final URI getLatestStableDownloadUri() {
        JsonObject json = this.queryJson("https://googlechromelabs.github.io/chrome-for-testing/last-known-good-versions-with-downloads.json");
        JsonObject jsonObject = json.getJsonObject("channels").getJsonObject("Stable");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"json.getJsonObject(\"chan\u2026 .getJsonObject(\"Stable\")");
        String string = this.getDownloadUri(jsonObject, "linux64");
        if (string == null) {
            throw (Throwable)new Exception("Failed to find stable ChromeDriver download version. Got response: " + json);
        }
        String uri = string;
        URI uRI = URI.create(uri);
        Intrinsics.checkExpressionValueIsNotNull((Object)uRI, (String)"URI.create(uri)");
        return uRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final JsonObject queryJson(String uri) {
        CloseableHttpResponse response;
        CloseableHttpResponse closeableHttpResponse = response = HttpClients.createDefault().execute((HttpUriRequest)new HttpGet(uri));
        Intrinsics.checkExpressionValueIsNotNull((Object)closeableHttpResponse, (String)"response");
        HttpEntity httpEntity = closeableHttpResponse.getEntity();
        Intrinsics.checkExpressionValueIsNotNull((Object)httpEntity, (String)"response.entity");
        InputStream inputStream = httpEntity.getContent();
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"response.entity.content");
        Object object = inputStream;
        Object object2 = Charsets.UTF_8;
        Closeable closeable = object;
        closeable = new InputStreamReader((InputStream)closeable, (Charset)object2);
        int n = 8192;
        object = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        object2 = null;
        try {
            Object it = (BufferedReader)object;
            it = TextStreamsKt.readText((Reader)((Reader)it));
        }
        catch (Throwable it) {
            object2 = it;
            throw it;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        Object it = object = it;
        JsonObject jsonObject = INSTANCE.parse((String)it);
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"parse(it)");
        Intrinsics.checkExpressionValueIsNotNull((Object)jsonObject, (String)"response.entity.content.\u2026ext() }.let { parse(it) }");
        return jsonObject;
    }

    private final JsonObject parse(String json) {
        return JsonProvider.provider().createReaderFactory(null).createReader((Reader)new StringReader(json)).readObject();
    }

    private final String getDownloadUri(@NotNull JsonObject $receiver, String platform) {
        JsonValue jsonValue;
        Object v1;
        block1: {
            Iterable iterable;
            JsonArray jsonArray = $receiver.getJsonObject("downloads").getJsonArray("chromedriver");
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonArray, (String)"getJsonObject(\"downloads\u2026JsonArray(\"chromedriver\")");
            Iterable iterable2 = iterable = (Iterable)jsonArray;
            for (Object t : iterable2) {
                JsonValue it = (JsonValue)t;
                if (!Intrinsics.areEqual((Object)it.asJsonObject().getString("platform"), (Object)platform)) continue;
                v1 = t;
                break block1;
            }
            v1 = null;
        }
        return (jsonValue = (JsonValue)v1) != null && (jsonValue = jsonValue.asJsonObject()) != null ? jsonValue.getString("url") : null;
    }

    private ChromeForTesting() {
    }

    static {
        ChromeForTesting chromeForTesting;
        INSTANCE = chromeForTesting = new ChromeForTesting();
    }
}

