/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.concurrency.api;

import java.io.InterruptedIOException;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=2, d1={"\u0000\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0003\n\u0000\u001a+\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u0001*\b\u0012\u0004\u0012\u0002H\u00010\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u001a\n\u0010\b\u001a\u00020\t*\u00020\n\u00a8\u0006\u000b"}, d2={"finishBy", "T", "Ljava/util/concurrent/Future;", "deadline", "Ljava/time/Instant;", "logger", "Lorg/apache/logging/log4j/Logger;", "(Ljava/util/concurrent/Future;Ljava/time/Instant;Lorg/apache/logging/log4j/Logger;)Ljava/lang/Object;", "representsInterrupt", "", "", "concurrency"})
public final class GracefulTerminationKt {
    public static final <T> T finishBy(@NotNull Future<T> $receiver, @NotNull Instant deadline, @NotNull Logger logger) {
        Intrinsics.checkParameterIsNotNull($receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)deadline, (String)"deadline");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Duration patience = (Duration)ComparisonsKt.maxOf((Comparable)Duration.between(Instant.now(), deadline), (Comparable)Duration.ZERO);
        logger.debug($receiver + " got " + patience + " to finish");
        T result = $receiver.get(patience.toMillis(), TimeUnit.MILLISECONDS);
        logger.debug($receiver + " finished on time");
        return result;
    }

    public static final boolean representsInterrupt(@NotNull Throwable $receiver) {
        boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        if ($receiver instanceof InterruptedException || $receiver instanceof InterruptedIOException) {
            bl = true;
        } else {
            Throwable throwable = $receiver.getCause();
            bl = throwable != null ? GracefulTerminationKt.representsInterrupt(throwable) : false;
        }
        return bl;
    }
}

