/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api.housekeeping;

import com.amazonaws.services.ec2.model.DescribeKeyPairsResult;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsResult;
import com.amazonaws.services.ec2.model.KeyPairInfo;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.atlassian.performance.tools.aws.Cloudformation;
import com.atlassian.performance.tools.aws.Ec2;
import com.atlassian.performance.tools.aws.Ec2Instance;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.Ec2SecurityGroup;
import com.atlassian.performance.tools.aws.api.ProvisionedStack;
import com.atlassian.performance.tools.aws.api.RemoteSshKey;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.SshKeyName;
import com.atlassian.performance.tools.aws.api.housekeeping.Housekeeping;
import com.atlassian.performance.tools.concurrency.api.GracefulTerminationKt;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0014\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010\u0012\u001a\u00020\u000b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00110\u00142\u0006\u0010\u0015\u001a\u00020\u0003H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/atlassian/performance/tools/aws/api/housekeeping/ConcurrentHousekeeping;", "Lcom/atlassian/performance/tools/aws/api/housekeeping/Housekeeping;", "stackTimeout", "Ljava/time/Duration;", "instanceTimeout", "amiTimeout", "(Ljava/time/Duration;Ljava/time/Duration;Ljava/time/Duration;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "cleanLeftovers", "", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "startReleasing", "Ljava/util/concurrent/CompletableFuture;", "resource", "Lcom/atlassian/performance/tools/aws/api/Resource;", "waitUntilReleased", "resources", "", "timeout", "Builder", "aws-resources"})
public final class ConcurrentHousekeeping
implements Housekeeping {
    private final Logger logger;
    private final Duration stackTimeout;
    private final Duration instanceTimeout;
    private final Duration amiTimeout;

    /*
     * WARNING - void declaration
     */
    @Override
    public void cleanLeftovers(@NotNull Aws aws) {
        Iterable $receiver$iv$iv;
        Object element$iv2;
        Resource resource;
        Collection collection;
        Iterable $receiver$iv$iv2;
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        new Ec2(aws.getEc2()).consumeExpiredInstances((Consumer<List<Ec2Instance>>)new Consumer<List<? extends Ec2Instance>>(this){
            final /* synthetic */ ConcurrentHousekeeping this$0;

            public final void accept(@NotNull List<Ec2Instance> instances) {
                Intrinsics.checkParameterIsNotNull(instances, (String)"instances");
                ConcurrentHousekeeping.access$waitUntilReleased(this.this$0, instances, ConcurrentHousekeeping.access$getInstanceTimeout$p(this.this$0));
            }
            {
                this.this$0 = concurrentHousekeeping;
            }
        });
        List<Resource> amis = new Ec2(aws.getEc2()).listExpiredAmis();
        this.waitUntilReleased(amis, this.amiTimeout);
        DescribeKeyPairsResult describeKeyPairsResult = aws.getEc2().describeKeyPairs();
        Intrinsics.checkExpressionValueIsNotNull((Object)describeKeyPairsResult, (String)"aws.ec2.describeKeyPairs()");
        List list = describeKeyPairsResult.getKeyPairs();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"aws.ec2.describeKeyPairs().keyPairs");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        Iterator iterator = $receiver$iv$iv2.iterator();
        while (iterator.hasNext()) {
            void key;
            Object item$iv$iv = iterator.next();
            KeyPairInfo keyPairInfo = (KeyPairInfo)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v2 = key;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"key");
            String string = v2.getKeyName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key.keyName");
            resource = new RemoteSshKey(new SshKeyName(string), aws.getEc2());
            collection.add(resource);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv2 = $receiver$iv;
        destination$iv$iv = new ArrayList();
        iterator = $receiver$iv$iv2.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            RemoteSshKey it = (RemoteSshKey)element$iv$iv;
            boolean bl = false;
            if (!it.isExpired()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv2 : $receiver$iv) {
            RemoteSshKey it = (RemoteSshKey)element$iv2;
            boolean bl = false;
            it.release().get();
        }
        DescribeSecurityGroupsResult describeSecurityGroupsResult = aws.getEc2().describeSecurityGroups();
        Intrinsics.checkExpressionValueIsNotNull((Object)describeSecurityGroupsResult, (String)"aws.ec2.describeSecurityGroups()");
        List list2 = describeSecurityGroupsResult.getSecurityGroups();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"aws.ec2.describeSecurityGroups().securityGroups");
        Iterable $receiver$iv2 = list2;
        element$iv2 = $receiver$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void securityGroup;
            SecurityGroup bl = (SecurityGroup)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            void v6 = securityGroup;
            Intrinsics.checkExpressionValueIsNotNull((Object)v6, (String)"securityGroup");
            resource = new Ec2SecurityGroup((SecurityGroup)v6, aws.getEc2());
            collection.add(resource);
        }
        $receiver$iv2 = (List)destination$iv$iv2;
        $receiver$iv$iv = $receiver$iv2;
        destination$iv$iv2 = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            Ec2SecurityGroup it = (Ec2SecurityGroup)element$iv$iv;
            boolean bl = false;
            if (!it.isExpired()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List securityGroups = (List)destination$iv$iv2;
        Duration duration = Duration.ofMinutes(3L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(3)");
        this.waitUntilReleased(securityGroups, duration);
        new Cloudformation(aws, aws.getCloudformation()).consumeExpiredStacks((Consumer<List<ProvisionedStack>>)new Consumer<List<? extends ProvisionedStack>>(this){
            final /* synthetic */ ConcurrentHousekeeping this$0;

            public final void accept(@NotNull List<ProvisionedStack> stacks) {
                Intrinsics.checkParameterIsNotNull(stacks, (String)"stacks");
                ConcurrentHousekeeping.access$waitUntilReleased(this.this$0, stacks, ConcurrentHousekeeping.access$getStackTimeout$p(this.this$0));
            }
            {
                this.this$0 = concurrentHousekeeping;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void waitUntilReleased(List<? extends Resource> resources, Duration timeout) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Instant deadline = Instant.now().plus(timeout);
        Iterable iterable = resources;
        Iterator iterator = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Resource resource = (Resource)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            CompletableFuture<?> completableFuture = this.startReleasing((Resource)it);
            collection.add(completableFuture);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            CompletableFuture it = (CompletableFuture)element$iv;
            boolean bl = false;
            Future future = it;
            Instant instant = deadline;
            Intrinsics.checkExpressionValueIsNotNull((Object)instant, (String)"deadline");
            Logger logger = this.logger;
            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"logger");
            GracefulTerminationKt.finishBy((Future)future, (Instant)instant, (Logger)logger);
        }
    }

    private final CompletableFuture<?> startReleasing(Resource resource) {
        if (!resource.isExpired()) {
            throw (Throwable)new Exception("You can't release " + resource + ". It hasn't expired.");
        }
        CompletionStage completionStage = resource.release().handle(new BiFunction<T, Throwable, U>(this, resource){
            final /* synthetic */ ConcurrentHousekeeping this$0;
            final /* synthetic */ Resource $resource;

            public final void apply(Object $noName_0, @Nullable Throwable throwable) {
                if (throwable != null) {
                    ConcurrentHousekeeping.access$getLogger$p(this.this$0).error(this.$resource + " failed to release itself", throwable);
                }
            }
            {
                this.this$0 = concurrentHousekeeping;
                this.$resource = resource;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"resource.release().handl\u2026)\n            }\n        }");
        return completionStage;
    }

    public ConcurrentHousekeeping(@NotNull Duration stackTimeout, @NotNull Duration instanceTimeout, @NotNull Duration amiTimeout) {
        Intrinsics.checkParameterIsNotNull((Object)stackTimeout, (String)"stackTimeout");
        Intrinsics.checkParameterIsNotNull((Object)instanceTimeout, (String)"instanceTimeout");
        Intrinsics.checkParameterIsNotNull((Object)amiTimeout, (String)"amiTimeout");
        this.stackTimeout = stackTimeout;
        this.instanceTimeout = instanceTimeout;
        this.amiTimeout = amiTimeout;
        this.logger = LogManager.getLogger(this.getClass());
    }

    public static final /* synthetic */ void access$waitUntilReleased(ConcurrentHousekeeping $this, List resources, Duration timeout) {
        $this.waitUntilReleased(resources, timeout);
    }

    public static final /* synthetic */ Duration access$getInstanceTimeout$p(ConcurrentHousekeeping $this) {
        return $this.instanceTimeout;
    }

    public static final /* synthetic */ Duration access$getStackTimeout$p(ConcurrentHousekeeping $this) {
        return $this.stackTimeout;
    }

    public static final /* synthetic */ Logger access$getLogger$p(ConcurrentHousekeeping $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0004J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/performance/tools/aws/api/housekeeping/ConcurrentHousekeeping$Builder;", "", "()V", "amiTimeout", "Ljava/time/Duration;", "instanceTimeout", "stackTimeout", "build", "Lcom/atlassian/performance/tools/aws/api/housekeeping/Housekeeping;", "aws-resources"})
    public static final class Builder {
        private Duration stackTimeout;
        private Duration instanceTimeout;
        private Duration amiTimeout;

        @NotNull
        public final Builder stackTimeout(@NotNull Duration stackTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)stackTimeout, (String)"stackTimeout");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.stackTimeout = stackTimeout;
            return builder;
        }

        @NotNull
        public final Builder instanceTimeout(@NotNull Duration instanceTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)instanceTimeout, (String)"instanceTimeout");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.instanceTimeout = instanceTimeout;
            return builder;
        }

        @NotNull
        public final Builder amiTimeout(@NotNull Duration amiTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)amiTimeout, (String)"amiTimeout");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.amiTimeout = amiTimeout;
            return builder;
        }

        @NotNull
        public final Housekeeping build() {
            return new ConcurrentHousekeeping(this.stackTimeout, this.instanceTimeout, this.amiTimeout);
        }

        public Builder() {
            Duration duration = Duration.ofMinutes(5L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(5)");
            this.stackTimeout = duration;
            Duration duration2 = Duration.ofMinutes(8L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMinutes(8)");
            this.instanceTimeout = duration2;
            Duration duration3 = Duration.ofMinutes(2L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofMinutes(2)");
            this.amiTimeout = duration3;
        }
    }
}

