/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api.ami;

import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Image;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.ami.SshAmiMod;
import com.atlassian.performance.tools.aws.api.ami.tiebreaker.AmiTiebreaker;
import com.atlassian.performance.tools.aws.api.ami.tiebreaker.NewestAvailableAmi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\rB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/performance/tools/aws/api/ami/TiebreakingAmiCache;", "Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$AmiCache;", "tiebreaker", "Lcom/atlassian/performance/tools/aws/api/ami/tiebreaker/AmiTiebreaker;", "(Lcom/atlassian/performance/tools/aws/api/ami/tiebreaker/AmiTiebreaker;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "lookup", "", "tags", "", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "Builder", "aws-resources"})
public final class TiebreakingAmiCache
implements SshAmiMod.AmiCache {
    private final Logger logger;
    private final AmiTiebreaker tiebreaker;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public String lookup(@NotNull Map<String, String> tags, @NotNull Aws aws) {
        String string;
        void $receiver$iv$iv;
        Map<String, String> $receiver$iv;
        Intrinsics.checkParameterIsNotNull(tags, (String)"tags");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        Map<String, String> map2 = $receiver$iv = tags;
        Collection destination$iv$iv = new ArrayList($receiver$iv.size());
        void var7_6 = $receiver$iv$iv;
        Iterator iterator = var7_6.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            void $dstr$key$value;
            Map.Entry item$iv$iv;
            Map.Entry entry = item$iv$iv = iterator.next();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void var12_11 = $dstr$key$value;
            String string2 = (String)var12_11.getKey();
            var12_11 = $dstr$key$value;
            String value = (String)var12_11.getValue();
            Filter filter = new Filter("tag:" + (String)key, CollectionsKt.listOf((Object)value));
            collection.add(filter);
        }
        List filters = (List)destination$iv$iv;
        DescribeImagesResult describeImagesResult = aws.getEc2().describeImages(new DescribeImagesRequest().withFilters((Collection)filters));
        Intrinsics.checkExpressionValueIsNotNull((Object)describeImagesResult, (String)"aws.ec2.describeImages(D\u2026t().withFilters(filters))");
        List amis = describeImagesResult.getImages();
        this.logger.debug("Cached AMIs (" + amis.size() + "): " + amis);
        List list = amis;
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"amis");
        Image ami = this.tiebreaker.pick(list);
        if (ami != null) {
            this.logger.debug("Reusing cached AMI: " + ami);
            string = ami.getImageId();
        } else {
            this.logger.info("No AMI matches tags " + tags);
            string = null;
        }
        return string;
    }

    private TiebreakingAmiCache(AmiTiebreaker tiebreaker) {
        this.tiebreaker = tiebreaker;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    public /* synthetic */ TiebreakingAmiCache(AmiTiebreaker tiebreaker, DefaultConstructorMarker $constructor_marker) {
        this(tiebreaker);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0003\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/performance/tools/aws/api/ami/TiebreakingAmiCache$Builder;", "", "()V", "tiebreaker", "Lcom/atlassian/performance/tools/aws/api/ami/tiebreaker/AmiTiebreaker;", "build", "Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$AmiCache;", "aws-resources"})
    public static final class Builder {
        private AmiTiebreaker tiebreaker = new NewestAvailableAmi();

        @NotNull
        public final Builder tiebreaker(@NotNull AmiTiebreaker tiebreaker) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)tiebreaker, (String)"tiebreaker");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.tiebreaker = tiebreaker;
            return builder;
        }

        @NotNull
        public final SshAmiMod.AmiCache build() {
            return new TiebreakingAmiCache(this.tiebreaker, null);
        }
    }
}

