/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api.ami;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CreateImageRequest;
import com.amazonaws.services.ec2.model.CreateImageResult;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.waiters.WaiterParameters;
import com.atlassian.performance.tools.aws.api.AwaitingEc2;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.SshInstance;
import com.atlassian.performance.tools.aws.api.SshKey;
import com.atlassian.performance.tools.aws.api.SshKeyFormula;
import com.atlassian.performance.tools.aws.api.Tag;
import com.atlassian.performance.tools.aws.api.ami.AmiProvider;
import com.atlassian.performance.tools.aws.api.ami.CanonicalAmiProvider;
import com.atlassian.performance.tools.aws.api.ami.TiebreakingAmiCache;
import com.atlassian.performance.tools.jvmtasks.api.TaskTimer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0003$%&B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u001a\u001a\u00020\u0012H\u0002J\u0018\u0010\u001b\u001a\u00020\u00122\u0006\u0010\u001c\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J,\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u00122\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J,\u0010 \u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00122\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00120\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0018\u0010#\u001a\u00020!2\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \r*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod;", "Lcom/atlassian/performance/tools/aws/api/ami/AmiProvider;", "sshInstanceMod", "Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$SshInstanceMod;", "amiProvider", "amiCache", "Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$AmiCache;", "amiLifespan", "Ljava/time/Duration;", "(Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$SshInstanceMod;Lcom/atlassian/performance/tools/aws/api/ami/AmiProvider;Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$AmiCache;Ljava/time/Duration;)V", "amiInvestment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "expectedImageSavingTime", "kotlin.jvm.PlatformType", "instanceInvestment", "logger", "Lorg/apache/logging/log4j/Logger;", "useCase", "", "allocateSshInstance", "Lcom/atlassian/performance/tools/aws/api/SshInstance;", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "amiId", "cacheKeyTags", "", "baseAmiId", "createAmi", "sshInstance", "generateNewAmi", "tags", "provideAmiId", "tag", "", "tagMap", "waitUntilAvailable", "AmiCache", "Builder", "SshInstanceMod", "aws-resources"})
public final class SshAmiMod
implements AmiProvider {
    private final Logger logger;
    private final String useCase;
    private final Investment amiInvestment;
    private final Duration expectedImageSavingTime;
    private final Investment instanceInvestment;
    private final SshInstanceMod sshInstanceMod;
    private final AmiProvider amiProvider;
    private final AmiCache amiCache;
    private final Duration amiLifespan;

    @Override
    @NotNull
    public String provideAmiId(@NotNull Aws aws) {
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        String baseAmiId = this.amiProvider.provideAmiId(aws);
        return (String)TaskTimer.INSTANCE.time("ami use case: '" + this.useCase + "' / base: " + baseAmiId, (Function0)new Function0<String>(this, baseAmiId, aws){
            final /* synthetic */ SshAmiMod this$0;
            final /* synthetic */ String $baseAmiId;
            final /* synthetic */ Aws $aws;

            @NotNull
            public final String invoke() {
                String string;
                Map cacheKeyTags = SshAmiMod.access$cacheKeyTags(this.this$0, this.$baseAmiId);
                String cachedAmiId = SshAmiMod.access$getAmiCache$p(this.this$0).lookup(cacheKeyTags, this.$aws);
                if (cachedAmiId != null) {
                    SshAmiMod.access$waitUntilAvailable(this.this$0, cachedAmiId, this.$aws);
                    string = cachedAmiId;
                } else {
                    string = SshAmiMod.access$generateNewAmi(this.this$0, this.$baseAmiId, cacheKeyTags, this.$aws);
                }
                return string;
            }
            {
                this.this$0 = sshAmiMod;
                this.$baseAmiId = string;
                this.$aws = aws;
                super(0);
            }
        });
    }

    private final Map<String, String> cacheKeyTags(String baseAmiId) {
        return MapsKt.plus(this.sshInstanceMod.tag(), (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"base-ami-id", (Object)baseAmiId)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String generateNewAmi(String baseAmiId, Map<String, String> tags, Aws aws) {
        this.logger.info("Generating new AMI for use case '" + this.useCase + "'...");
        this.logger.debug("New AMI tags: " + tags);
        SshInstance sshInstance = this.allocateSshInstance(aws, baseAmiId);
        try {
            this.logger.debug("Modifying " + baseAmiId + ": " + tags + "...");
            this.sshInstanceMod.modify(sshInstance);
            this.logger.debug("Modified " + baseAmiId + ": " + tags);
            String newAmiId = this.createAmi(sshInstance, aws);
            this.tag(newAmiId, tags, aws);
            this.waitUntilAvailable(newAmiId, aws);
            String string = newAmiId;
            return string;
        }
        finally {
            this.logger.debug("Releasing resources used for modification of base AMI " + baseAmiId + ": " + tags + "...");
            sshInstance.getResource().release().get();
            this.logger.debug("Releasing resources used for modification of base AMI " + baseAmiId + ": " + tags);
        }
    }

    private final SshInstance allocateSshInstance(Aws aws, String amiId) {
        String keyPrefix = (String)this.instanceInvestment.getReuseKey().invoke();
        AmazonEC2 amazonEC2 = aws.getEc2();
        Path path = Files.createTempDirectory(keyPrefix, new FileAttribute[0]);
        Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"createTempDirectory(keyPrefix)");
        SshKey sshKey = new SshKeyFormula(amazonEC2, path, keyPrefix, this.instanceInvestment.getLifespan()).provision();
        AwaitingEc2 awaitingEc22 = new AwaitingEc2(aws.getEc2(), aws.getTerminationBatchingEc2(), aws.getInstanceNanny$aws_resources(), amiId);
        return awaitingEc22.allocateInstance(this.instanceInvestment, sshKey, null, (Function1<? super RunInstancesRequest, ? extends RunInstancesRequest>)((Function1)new Function1<RunInstancesRequest, RunInstancesRequest>(aws){
            final /* synthetic */ Aws $aws;

            public final RunInstancesRequest invoke(@NotNull RunInstancesRequest launch) {
                Intrinsics.checkParameterIsNotNull((Object)launch, (String)"launch");
                IamInstanceProfileSpecification instanceProfile = new IamInstanceProfileSpecification().withName(this.$aws.shortTermStorageAccess());
                RunInstancesRequest runInstancesRequest = launch.withIamInstanceProfile(instanceProfile);
                Intrinsics.checkExpressionValueIsNotNull((Object)runInstancesRequest, (String)"launch.withIamInstanceProfile(instanceProfile)");
                return runInstancesRequest;
            }
            {
                this.$aws = aws;
                super(1);
            }
        }));
    }

    private final String createAmi(SshInstance sshInstance, Aws aws) {
        String moddedAmiName = "jpt-ssh-ami-mod-" + UUID.randomUUID();
        CreateImageRequest amiCreation = new CreateImageRequest(sshInstance.getInstance().getInstanceId(), moddedAmiName);
        CreateImageResult createImageResult = aws.getEc2().createImage(amiCreation);
        Intrinsics.checkExpressionValueIsNotNull((Object)createImageResult, (String)"aws.ec2.createImage(amiCreation)");
        String string = createImageResult.getImageId();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"aws.ec2.createImage(amiCreation).imageId");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final void tag(String amiId, Map<String, String> tagMap, Aws aws) {
        Collection<com.amazonaws.services.ec2.model.Tag> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Collection collection2;
        Collection collection3;
        Iterable $receiver$iv$iv2;
        Iterable $receiver$iv2;
        Iterable iterable = $receiver$iv2 = (Iterable)tagMap.entrySet();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv2) {
            void key;
            void $dstr$key$value;
            Map.Entry entry = (Map.Entry)item$iv$iv;
            collection3 = destination$iv$iv;
            boolean bl = false;
            void var12_12 = $dstr$key$value;
            String string = (String)var12_12.getKey();
            var12_12 = $dstr$key$value;
            String value = (String)var12_12.getValue();
            collection2 = new com.amazonaws.services.ec2.model.Tag((String)key, value);
            collection3.add(collection2);
        }
        List tags = (List)destination$iv$iv;
        $receiver$iv$iv2 = this.amiInvestment.tag();
        collection2 = tags;
        collection3 = new CreateTagsRequest().withResources(new String[]{amiId});
        destination$iv$iv = $receiver$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Tag bl = (Tag)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            com.amazonaws.services.ec2.model.Tag tag = it.toEc2();
            collection.add(tag);
        }
        collection = (List)destination$iv$iv2;
        CreateTagsRequest tagging = collection3.withTags(CollectionsKt.plus((Collection)collection2, (Iterable)collection));
        aws.getEc2().createTags(tagging);
    }

    private final void waitUntilAvailable(String amiId, Aws aws) {
        Function0<Unit> function0 = new Function0<Unit>(this, amiId, aws){
            final /* synthetic */ SshAmiMod this$0;
            final /* synthetic */ String $amiId;
            final /* synthetic */ Aws $aws;

            public final void invoke() {
                SshAmiMod.access$getLogger$p(this.this$0).info("Waiting for '" + SshAmiMod.access$getUseCase$p(this.this$0) + "' AMI to become available...");
                WaiterParameters waiterParameters = new WaiterParameters((AmazonWebServiceRequest)new DescribeImagesRequest().withImageIds(new String[]{this.$amiId}));
                this.$aws.getEc2().waiters().imageAvailable().run(waiterParameters);
                SshAmiMod.access$getLogger$p(this.this$0).info("The '" + SshAmiMod.access$getUseCase$p(this.this$0) + "' AMI is available");
            }
            {
                this.this$0 = sshAmiMod;
                this.$amiId = string;
                this.$aws = aws;
                super(0);
            }
        };
        Function0 it = (Function0)function0;
        boolean bl = false;
        TaskTimer.INSTANCE.time("ami-wait", (Function0)new Function0<Unit>(it){
            final /* synthetic */ Function0 $it;

            public final void invoke() {
                this.$it.invoke();
            }
            {
                this.$it = function0;
                super(0);
            }
        });
    }

    private SshAmiMod(SshInstanceMod sshInstanceMod, AmiProvider amiProvider, AmiCache amiCache, Duration amiLifespan) {
        this.sshInstanceMod = sshInstanceMod;
        this.amiProvider = amiProvider;
        this.amiCache = amiCache;
        this.amiLifespan = amiLifespan;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.useCase = this.sshInstanceMod.getUseCase();
        this.amiInvestment = new Investment.Builder(this.useCase, this.amiLifespan).build();
        this.expectedImageSavingTime = Duration.ofMinutes(6L);
        Duration duration = this.sshInstanceMod.getExpectedDuration().plus(this.expectedImageSavingTime);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"sshInstanceMod.expectedD\u2026+ expectedImageSavingTime");
        this.instanceInvestment = new Investment.Builder(this.useCase, duration).build();
    }

    public /* synthetic */ SshAmiMod(SshInstanceMod sshInstanceMod, AmiProvider amiProvider, AmiCache amiCache, Duration amiLifespan, DefaultConstructorMarker $constructor_marker) {
        this(sshInstanceMod, amiProvider, amiCache, amiLifespan);
    }

    public static final /* synthetic */ Map access$cacheKeyTags(SshAmiMod $this, String baseAmiId) {
        return $this.cacheKeyTags(baseAmiId);
    }

    public static final /* synthetic */ AmiCache access$getAmiCache$p(SshAmiMod $this) {
        return $this.amiCache;
    }

    public static final /* synthetic */ void access$waitUntilAvailable(SshAmiMod $this, String amiId, Aws aws) {
        $this.waitUntilAvailable(amiId, aws);
    }

    public static final /* synthetic */ String access$generateNewAmi(SshAmiMod $this, String baseAmiId, Map tags, Aws aws) {
        return $this.generateNewAmi(baseAmiId, tags, aws);
    }

    public static final /* synthetic */ Logger access$getLogger$p(SshAmiMod $this) {
        return $this.logger;
    }

    public static final /* synthetic */ String access$getUseCase$p(SshAmiMod $this) {
        return $this.useCase;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH&J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u000fH&R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$SshInstanceMod;", "", "expectedDuration", "Ljava/time/Duration;", "getExpectedDuration", "()Ljava/time/Duration;", "useCase", "", "getUseCase", "()Ljava/lang/String;", "modify", "", "sshInstance", "Lcom/atlassian/performance/tools/aws/api/SshInstance;", "tag", "", "aws-resources"})
    public static interface SshInstanceMod {
        @NotNull
        public Duration getExpectedDuration();

        @NotNull
        public String getUseCase();

        public void modify(@NotNull SshInstance var1);

        @NotNull
        public Map<String, String> tag();
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J&\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$AmiCache;", "", "lookup", "", "tags", "", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "aws-resources"})
    public static interface AmiCache {
        @Nullable
        public String lookup(@NotNull Map<String, String> var1, @NotNull Aws var2);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nJ\u0006\u0010\f\u001a\u00020\rR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$Builder;", "", "sshInstanceMod", "Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$SshInstanceMod;", "(Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$SshInstanceMod;)V", "amiCache", "Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$AmiCache;", "amiLifespan", "Ljava/time/Duration;", "amiProvider", "Lcom/atlassian/performance/tools/aws/api/ami/AmiProvider;", "lifespan", "build", "Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod;", "aws-resources"})
    public static final class Builder {
        private AmiProvider amiProvider;
        private AmiCache amiCache;
        private Duration amiLifespan;
        private SshInstanceMod sshInstanceMod;

        @NotNull
        public final Builder amiProvider(@NotNull AmiProvider amiProvider) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)amiProvider, (String)"amiProvider");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.amiProvider = amiProvider;
            return builder;
        }

        @NotNull
        public final Builder amiCache(@NotNull AmiCache amiCache) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)amiCache, (String)"amiCache");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.amiCache = amiCache;
            return builder;
        }

        @NotNull
        public final Builder amiLifespan(@NotNull Duration lifespan) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)lifespan, (String)"lifespan");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.amiLifespan = lifespan;
            return builder;
        }

        @NotNull
        public final SshAmiMod build() {
            return new SshAmiMod(this.sshInstanceMod, this.amiProvider, this.amiCache, this.amiLifespan, null);
        }

        public Builder(@NotNull SshInstanceMod sshInstanceMod) {
            Intrinsics.checkParameterIsNotNull((Object)sshInstanceMod, (String)"sshInstanceMod");
            this.sshInstanceMod = sshInstanceMod;
            this.amiProvider = new CanonicalAmiProvider.Builder().build();
            this.amiCache = new TiebreakingAmiCache.Builder().build();
            Duration duration = Duration.ofDays(30L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofDays(30)");
            this.amiLifespan = duration;
        }
    }
}

