/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.InstanceStateName;
import com.atlassian.performance.tools.aws.api.ScrollingEc2;
import com.atlassian.performance.tools.aws.api.TerminationPollingEc2;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u000e\u001a\u00020\fH\u0002J\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\n2\u0006\u0010\r\u001a\u00020\tJ\b\u0010\u000f\u001a\u00020\fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/aws/api/TerminationPollingEc2;", "", "scrollingEc2", "Lcom/atlassian/performance/tools/aws/api/ScrollingEc2;", "(Lcom/atlassian/performance/tools/aws/api/ScrollingEc2;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "polls", "", "", "Ljava/util/concurrent/CompletableFuture;", "completeTermination", "", "instanceId", "pollUntilTermination", "tryPolling", "aws-resources"})
public final class TerminationPollingEc2 {
    private final Logger logger;
    private final Map<String, CompletableFuture<String>> polls;
    private final ScrollingEc2 scrollingEc2;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CompletableFuture<String> pollUntilTermination(@NotNull String instanceId) {
        Intrinsics.checkParameterIsNotNull((Object)instanceId, (String)"instanceId");
        Map<String, CompletableFuture<String>> map2 = this.polls;
        synchronized (map2) {
            boolean bl = false;
            CompletableFuture<String> completableFuture = this.polls.computeIfAbsent(instanceId, pollUntilTermination.1.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"polls.computeIfAbsent(in\u2026) { CompletableFuture() }");
            CompletableFuture<String> completableFuture2 = completableFuture;
            return completableFuture2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryPolling() {
        try {
            Map<String, CompletableFuture<String>> map2 = this.polls;
            synchronized (map2) {
                boolean bl = false;
                this.pollUntilTermination();
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to poll instances", (Throwable)e);
        }
    }

    private final void pollUntilTermination() {
        if (this.polls.isEmpty()) {
            this.logger.debug("No instances to poll");
            return;
        }
        List instanceIds = CollectionsKt.take((Iterable)this.polls.keySet(), (int)200);
        this.logger.debug("Polling " + instanceIds);
        Set foundInstanceIds = new LinkedHashSet();
        this.scrollingEc2.scrollThroughInstances(new Filter[]{new Filter("instance-id", instanceIds)}, (Function1<? super List<? extends Instance>, Unit>)((Function1)new Function1<List<? extends Instance>, Unit>(this, foundInstanceIds){
            final /* synthetic */ TerminationPollingEc2 this$0;
            final /* synthetic */ Set $foundInstanceIds;

            public final void invoke(@NotNull List<? extends Instance> instanceBatch) {
                Iterable $receiver$iv$iv;
                Instance it;
                Intrinsics.checkParameterIsNotNull(instanceBatch, (String)"instanceBatch");
                Iterable $receiver$iv = instanceBatch;
                Object object = $receiver$iv;
                Iterable $receiver$iv2 = object;
                for (T element$iv : $receiver$iv2) {
                    it = (Instance)element$iv;
                    boolean bl = false;
                    Collection collection = this.$foundInstanceIds;
                    String string = it.getInstanceId();
                    collection.add(string);
                }
                $receiver$iv = object;
                object = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    it = (Instance)element$iv$iv;
                    boolean bl = false;
                    InstanceState instanceState = it.getState();
                    Intrinsics.checkExpressionValueIsNotNull((Object)instanceState, (String)"it.state");
                    if (!Intrinsics.areEqual((Object)instanceState.getName(), (Object)InstanceStateName.Terminated.toString())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    it = (Instance)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getInstanceId();
                    collection.add(string);
                }
                $receiver$iv = (List)destination$iv$iv;
                for (E element$iv : $receiver$iv) {
                    String it2 = (String)element$iv;
                    boolean bl = false;
                    String string = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it");
                    TerminationPollingEc2.access$completeTermination(this.this$0, string);
                }
            }
            {
                this.this$0 = terminationPollingEc22;
                this.$foundInstanceIds = set;
                super(1);
            }
        }));
        Iterable $receiver$iv = CollectionsKt.minus((Iterable)instanceIds, (Iterable)foundInstanceIds);
        for (Object element$iv : $receiver$iv) {
            String unseenInstanceId = (String)element$iv;
            boolean bl = false;
            this.completeTermination(unseenInstanceId);
        }
    }

    private final void completeTermination(String instanceId) {
        block0: {
            this.logger.debug(instanceId + " has terminated");
            CompletableFuture<String> completableFuture = this.polls.remove(instanceId);
            if (completableFuture == null) break block0;
            completableFuture.complete(instanceId);
        }
    }

    public TerminationPollingEc2(@NotNull ScrollingEc2 scrollingEc2) {
        Timer timer2;
        Intrinsics.checkParameterIsNotNull((Object)scrollingEc2, (String)"scrollingEc2");
        this.scrollingEc2 = scrollingEc2;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.polls = new ConcurrentHashMap();
        String string = "ec2-polling";
        boolean bl = true;
        long l = Duration.ofSeconds(5L).toMillis();
        long l2 = Duration.ofSeconds(15L).toMillis();
        Timer timer3 = timer2 = TimersKt.timer((String)string, (boolean)bl);
        TimerTask timerTask = new TimerTask(this){
            final /* synthetic */ TerminationPollingEc2 this$0;
            {
                this.this$0 = terminationPollingEc22;
            }

            public void run() {
                TimerTask $receiver = this;
                boolean bl = false;
                TerminationPollingEc2.access$tryPolling(this.this$0);
            }
        };
        timer3.schedule(timerTask, l, l2);
    }

    public static final /* synthetic */ void access$completeTermination(TerminationPollingEc2 $this, String instanceId) {
        $this.completeTermination(instanceId);
    }

    public static final /* synthetic */ void access$tryPolling(TerminationPollingEc2 $this) {
        $this.tryPolling();
    }
}

