/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import com.atlassian.performance.tools.aws.api.TerminationBatchingEc2;
import com.atlassian.performance.tools.aws.api.TerminationPollingEc2;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.internal.Intrinsics;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\f2\u0006\u0010\u000f\u001a\u00020\u000bJ\b\u0010\u0010\u001a\u00020\u000eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/performance/tools/aws/api/TerminationBatchingEc2;", "", "ec2", "Lcom/amazonaws/services/ec2/AmazonEC2;", "polling", "Lcom/atlassian/performance/tools/aws/api/TerminationPollingEc2;", "(Lcom/amazonaws/services/ec2/AmazonEC2;Lcom/atlassian/performance/tools/aws/api/TerminationPollingEc2;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "terminations", "", "", "Ljava/util/concurrent/CompletableFuture;", "terminate", "", "instanceId", "tryToTerminate", "aws-resources"})
public final class TerminationBatchingEc2 {
    private final Logger logger;
    private final Map<String, CompletableFuture<String>> terminations;
    private final AmazonEC2 ec2;
    private final TerminationPollingEc2 polling;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final CompletableFuture<String> terminate(@NotNull String instanceId) {
        Intrinsics.checkParameterIsNotNull((Object)instanceId, (String)"instanceId");
        Map<String, CompletableFuture<String>> map2 = this.terminations;
        synchronized (map2) {
            boolean bl = false;
            CompletableFuture<String> completableFuture = this.terminations.computeIfAbsent(instanceId, terminate.1.1.INSTANCE);
            Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"terminations.computeIfAb\u2026) { CompletableFuture() }");
            CompletableFuture<String> completableFuture2 = completableFuture;
            return completableFuture2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryToTerminate() {
        try {
            Map<String, CompletableFuture<String>> map2 = this.terminations;
            synchronized (map2) {
                boolean bl = false;
                this.terminate();
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to terminate " + this.terminations.size() + " instances", (Throwable)e);
        }
    }

    private final void terminate() {
        if (this.terminations.isEmpty()) {
            this.logger.trace("No instances to terminate");
            return;
        }
        List instanceIds = CollectionsKt.take((Iterable)this.terminations.keySet(), (int)1000);
        this.logger.debug("Starting batch termination of " + instanceIds);
        this.ec2.terminateInstances(new TerminateInstancesRequest().withInstanceIds((Collection)instanceIds));
        Iterable $receiver$iv = instanceIds;
        for (Object element$iv : $receiver$iv) {
            String instanceId = (String)element$iv;
            boolean bl = false;
            this.polling.pollUntilTermination(instanceId).thenAccept((Consumer)new Consumer<String>(this){
                final /* synthetic */ TerminationBatchingEc2 this$0;
                {
                    this.this$0 = terminationBatchingEc22;
                }

                public final void accept(String terminatedId) {
                    block0: {
                        CompletableFuture completableFuture = (CompletableFuture)TerminationBatchingEc2.access$getTerminations$p(this.this$0).remove(terminatedId);
                        if (completableFuture == null) break block0;
                        completableFuture.complete(terminatedId);
                    }
                }
            });
        }
    }

    public TerminationBatchingEc2(@NotNull AmazonEC2 ec2, @NotNull TerminationPollingEc2 polling) {
        Timer timer2;
        Intrinsics.checkParameterIsNotNull((Object)ec2, (String)"ec2");
        Intrinsics.checkParameterIsNotNull((Object)polling, (String)"polling");
        this.ec2 = ec2;
        this.polling = polling;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.terminations = new ConcurrentHashMap();
        String string = "ec2-termination";
        boolean bl = true;
        long l = Duration.ofSeconds(5L).toMillis();
        long l2 = Duration.ofSeconds(30L).toMillis();
        Timer timer3 = timer2 = TimersKt.timer((String)string, (boolean)bl);
        TimerTask timerTask = new TimerTask(this){
            final /* synthetic */ TerminationBatchingEc2 this$0;
            {
                this.this$0 = terminationBatchingEc22;
            }

            public void run() {
                TimerTask $receiver = this;
                boolean bl = false;
                TerminationBatchingEc2.access$tryToTerminate(this.this$0);
            }
        };
        timer3.schedule(timerTask, l, l2);
    }

    public static final /* synthetic */ Map access$getTerminations$p(TerminationBatchingEc2 $this) {
        return $this.terminations;
    }

    public static final /* synthetic */ void access$tryToTerminate(TerminationBatchingEc2 $this) {
        $this.tryToTerminate();
    }
}

