/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.support.AWSSupport;
import com.amazonaws.services.support.model.CaseDetails;
import com.amazonaws.services.support.model.CreateCaseRequest;
import com.amazonaws.services.support.model.CreateCaseResult;
import com.amazonaws.services.support.model.DescribeCasesResult;
import com.atlassian.performance.tools.aws.api.CapacityMediator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/performance/tools/aws/api/SupportCapacityMediator;", "Lcom/atlassian/performance/tools/aws/api/CapacityMediator;", "support", "Lcom/amazonaws/services/support/AWSSupport;", "region", "Lcom/amazonaws/regions/Regions;", "(Lcom/amazonaws/services/support/AWSSupport;Lcom/amazonaws/regions/Regions;)V", "bump", "", "limitType", "desiredLimit", "Lkotlin/Function0;", "", "createCase", "request", "Lcom/amazonaws/services/support/model/CreateCaseRequest;", "prepareSupportRequest", "subject", "limit", "aws-resources"})
public final class SupportCapacityMediator
implements CapacityMediator {
    private final AWSSupport support;
    private final Regions region;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String bump(@NotNull String limitType, @NotNull Function0<Integer> desiredLimit) {
        String string;
        Object v3;
        String subject;
        block3: {
            void $receiver$iv;
            Intrinsics.checkParameterIsNotNull((Object)limitType, (String)"limitType");
            Intrinsics.checkParameterIsNotNull(desiredLimit, (String)"desiredLimit");
            subject = "Raise service limit: " + limitType;
            DescribeCasesResult describeCasesResult = this.support.describeCases();
            Intrinsics.checkExpressionValueIsNotNull((Object)describeCasesResult, (String)"support\n            .describeCases()");
            List list = describeCasesResult.getCases();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"support\n            .des\u2026ases()\n            .cases");
            Iterable iterable = list;
            for (Object element$iv : $receiver$iv) {
                CaseDetails it = (CaseDetails)element$iv;
                boolean bl = false;
                CaseDetails caseDetails = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)caseDetails, (String)"it");
                if (!Intrinsics.areEqual((Object)caseDetails.getSubject(), (Object)subject)) continue;
                v3 = element$iv;
                break block3;
            }
            v3 = null;
        }
        CaseDetails openCase = v3;
        if (openCase != null) {
            string = "We recently opened a support case, which should resolve the problem:" + ' ' + openCase.getCaseId() + ": " + openCase.getSubject() + '.' + " Please retry tomorrow and if the issue still persists, escalate this problem.";
        } else {
            String limit = limitType + " to " + ((Number)desiredLimit.invoke()).intValue();
            string = this.createCase(this.prepareSupportRequest(subject, limit));
        }
        return string;
    }

    private final String createCase(CreateCaseRequest request) {
        CreateCaseResult createCaseResult = this.support.createCase(request);
        Intrinsics.checkExpressionValueIsNotNull((Object)createCaseResult, (String)"support.createCase(request)");
        String caseId = createCaseResult.getCaseId();
        return "Opened support case " + caseId + ": " + request.getSubject();
    }

    private final CreateCaseRequest prepareSupportRequest(String subject, String limit) {
        CreateCaseRequest createCaseRequest = new CreateCaseRequest().withSubject(subject).withIssueType("technical").withServiceCode("amazon-elastic-compute-cloud-linux").withCategoryCode("general-guidance").withSeverityCode("normal").withLanguage("en").withCommunicationBody(StringsKt.trimMargin$default((String)("\n            |Hi,\n            |\n            |Please raise the " + this.region.getName() + " region " + limit + ".\n            |\n            |We sometimes migrate between accounts, regions, instance types\n            |and we need the additional capacity to perform our performance tests.\n            |\n            |Thanks,\n            |Maciej\n            "), null, (int)1, null));
        Intrinsics.checkExpressionValueIsNotNull((Object)createCaseRequest, (String)"CreateCaseRequest()\n    \u2026\"\".trimMargin()\n        )");
        return createCaseRequest;
    }

    public SupportCapacityMediator(@NotNull AWSSupport support, @NotNull Regions region) {
        Intrinsics.checkParameterIsNotNull((Object)support, (String)"support");
        Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
        this.support = support;
        this.region = region;
    }
}

