/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.atlassian.performance.tools.aws.api.StorageLocation;
import com.atlassian.performance.tools.io.api.DirectoriesKt;
import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import com.atlassian.performance.tools.jvmtasks.api.ExponentialBackoff;
import com.atlassian.performance.tools.jvmtasks.api.IdempotentAction;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\u0013\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c2\u0003J'\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u0017\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001cJ\u0018\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\"\u001a\u00020 J\t\u0010#\u001a\u00020$H\u00d6\u0001J\t\u0010%\u001a\u00020\u0005H\u00d6\u0001J\u000e\u0010&\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(J \u0010)\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u0005H\u0002R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lcom/atlassian/performance/tools/aws/api/Storage;", "", "s3", "Lcom/amazonaws/services/s3/AmazonS3;", "prefix", "", "bucketName", "(Lcom/amazonaws/services/s3/AmazonS3;Ljava/lang/String;Ljava/lang/String;)V", "dirPrefix", "location", "Lcom/atlassian/performance/tools/aws/api/StorageLocation;", "getLocation", "()Lcom/atlassian/performance/tools/aws/api/StorageLocation;", "logger", "Lorg/apache/logging/log4j/Logger;", "uri", "Ljava/net/URI;", "getUri", "()Ljava/net/URI;", "component1", "component2", "component3", "copy", "download", "", "listing", "Lcom/amazonaws/services/s3/model/ListObjectsV2Result;", "rootTarget", "Ljava/nio/file/Path;", "downloadObject", "key", "equals", "", "other", "hasContent", "hashCode", "", "toString", "upload", "file", "Ljava/io/File;", "uploadRecursively", "aws-resources"})
public final class Storage {
    private final Logger logger;
    private final String dirPrefix;
    @NotNull
    private final URI uri;
    @NotNull
    private final StorageLocation location;
    private final AmazonS3 s3;
    private final String prefix;
    private final String bucketName;

    @NotNull
    public final URI getUri() {
        return this.uri;
    }

    @NotNull
    public final StorageLocation getLocation() {
        return this.location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void upload(@NotNull File file) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        if (file.isDirectory()) {
            Closeable closeable = Files.newDirectoryStream(file.toPath());
            Throwable throwable = null;
            try {
                DirectoryStream files = (DirectoryStream)closeable;
                boolean bl = false;
                DirectoryStream directoryStream = files;
                Intrinsics.checkExpressionValueIsNotNull((Object)directoryStream, (String)"files");
                Iterable $receiver$iv = directoryStream;
                for (Object element$iv : $receiver$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    File file2 = it.toFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.toFile()");
                    StringBuilder stringBuilder = new StringBuilder().append(this.dirPrefix);
                    Path path = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                    this.uploadRecursively(file2, this.bucketName, stringBuilder.append(path.getFileName()).toString());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            String fileKey = this.dirPrefix + file.getName();
            this.logger.debug("Uploading " + file + " to " + this.bucketName + " under " + fileKey);
            this.s3.putObject(this.bucketName, fileKey, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void uploadRecursively(File file, String bucketName, String key) {
        if (file.isDirectory()) {
            Closeable closeable = Files.newDirectoryStream(file.toPath());
            Throwable throwable = null;
            try {
                DirectoryStream files = (DirectoryStream)closeable;
                boolean bl = false;
                DirectoryStream directoryStream = files;
                Intrinsics.checkExpressionValueIsNotNull((Object)directoryStream, (String)"files");
                Iterable $receiver$iv = directoryStream;
                for (Object element$iv : $receiver$iv) {
                    Path it = (Path)element$iv;
                    boolean bl2 = false;
                    File file2 = it.toFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it.toFile()");
                    StringBuilder stringBuilder = new StringBuilder().append(key).append('/');
                    Path path = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)path, (String)"it");
                    this.uploadRecursively(file2, bucketName, stringBuilder.append(path.getFileName()).toString());
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            this.logger.debug("Uploading " + file + " to " + bucketName + " under " + key);
            this.s3.putObject(bucketName, key, file);
        }
    }

    @NotNull
    public final Path download(@NotNull Path rootTarget) {
        ListObjectsV2Result listing;
        Intrinsics.checkParameterIsNotNull((Object)rootTarget, (String)"rootTarget");
        String token = null;
        do {
            ListObjectsV2Result listObjectsV2Result = listing = this.s3.listObjectsV2(new ListObjectsV2Request().withBucketName(this.bucketName).withPrefix(this.dirPrefix).withContinuationToken(token));
            Intrinsics.checkExpressionValueIsNotNull((Object)listObjectsV2Result, (String)"listing");
            this.download(listObjectsV2Result, rootTarget);
        } while ((token = listing.getNextContinuationToken()) != null);
        return rootTarget;
    }

    /*
     * WARNING - void declaration
     */
    private final void download(ListObjectsV2Result listing, Path rootTarget) {
        String string;
        String it;
        Collection collection;
        Iterable $receiver$iv$iv;
        List list = listing.getObjectSummaries();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"listing\n            .objectSummaries");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            S3ObjectSummary s3ObjectSummary = (S3ObjectSummary)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            void v1 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"it");
            string = v1.getKey();
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void key;
            it = (String)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            string = new IdempotentAction("download " + (String)key, (Function0)new Function0<Unit>((String)key, this, rootTarget){
                final /* synthetic */ String $key;
                final /* synthetic */ Storage this$0;
                final /* synthetic */ Path $rootTarget$inlined;
                {
                    this.$key = string;
                    this.this$0 = storage;
                    this.$rootTarget$inlined = path;
                    super(0);
                }

                public final void invoke() {
                    String string = this.$key;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"key");
                    Storage.access$downloadObject(this.this$0, string, this.$rootTarget$inlined);
                }
            });
            collection.add(string);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            IdempotentAction download = (IdempotentAction)element$iv;
            boolean bl = false;
            Duration duration = Duration.ofSeconds(5L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(5)");
            download.retry(2, (Backoff)new ExponentialBackoff(duration, 2.0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void downloadObject(String key, Path rootTarget) {
        String path = StringsKt.removePrefix((String)key, (CharSequence)this.dirPrefix);
        Path leafTarget = rootTarget.resolve(path);
        this.logger.debug("Downloading " + this.bucketName + '/' + key + " into " + leafTarget);
        S3Object s3Object = this.s3.getObject(this.bucketName, key);
        Intrinsics.checkExpressionValueIsNotNull((Object)s3Object, (String)"s3.getObject(bucketName, key)");
        Closeable closeable = (Closeable)s3Object.getObjectContent();
        Throwable throwable = null;
        try {
            S3ObjectInputStream stream = (S3ObjectInputStream)closeable;
            boolean bl = false;
            S3ObjectInputStream s3ObjectInputStream = stream;
            Intrinsics.checkExpressionValueIsNotNull((Object)s3ObjectInputStream, (String)"stream");
            InputStream inputStream = (InputStream)s3ObjectInputStream;
            Path path2 = leafTarget;
            Intrinsics.checkExpressionValueIsNotNull((Object)path2, (String)"leafTarget");
            Path path3 = DirectoriesKt.copy((InputStream)inputStream, (Path)path2);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    public final boolean hasContent() {
        ListObjectsV2Request listRequest = new ListObjectsV2Request().withBucketName(this.bucketName).withPrefix(this.dirPrefix).withMaxKeys(Integer.valueOf(1));
        ListObjectsV2Result listObjectsV2Result = this.s3.listObjectsV2(listRequest);
        Intrinsics.checkExpressionValueIsNotNull((Object)listObjectsV2Result, (String)"s3.listObjectsV2(listRequest)");
        List list = listObjectsV2Result.getObjectSummaries();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"s3.listObjectsV2(listRequest).objectSummaries");
        Collection collection = list;
        return !collection.isEmpty();
    }

    public Storage(@NotNull AmazonS3 s3, @NotNull String prefix, @NotNull String bucketName) {
        Intrinsics.checkParameterIsNotNull((Object)s3, (String)"s3");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)bucketName, (String)"bucketName");
        this.s3 = s3;
        this.prefix = prefix;
        this.bucketName = bucketName;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.dirPrefix = this.prefix + '/';
        this.uri = new URI("s3", "//" + this.bucketName + '/' + this.prefix, null);
        Regions regions = Regions.fromName((String)this.s3.getRegionName());
        Intrinsics.checkExpressionValueIsNotNull((Object)regions, (String)"Regions.fromName(s3.regionName)");
        this.location = new StorageLocation(this.uri, regions);
    }

    public static final /* synthetic */ void access$downloadObject(Storage $this, String key, Path rootTarget) {
        $this.downloadObject(key, rootTarget);
    }

    private final AmazonS3 component1() {
        return this.s3;
    }

    private final String component2() {
        return this.prefix;
    }

    private final String component3() {
        return this.bucketName;
    }

    @NotNull
    public final Storage copy(@NotNull AmazonS3 s3, @NotNull String prefix, @NotNull String bucketName) {
        Intrinsics.checkParameterIsNotNull((Object)s3, (String)"s3");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)bucketName, (String)"bucketName");
        return new Storage(s3, prefix, bucketName);
    }

    public static /* synthetic */ Storage copy$default(Storage storage, AmazonS3 amazonS3, String string, String string2, int n, Object object) {
        if ((n & 1) != 0) {
            amazonS3 = storage.s3;
        }
        if ((n & 2) != 0) {
            string = storage.prefix;
        }
        if ((n & 4) != 0) {
            string2 = storage.bucketName;
        }
        return storage.copy(amazonS3, string, string2);
    }

    @NotNull
    public String toString() {
        return "Storage(s3=" + this.s3 + ", prefix=" + this.prefix + ", bucketName=" + this.bucketName + ")";
    }

    public int hashCode() {
        AmazonS3 amazonS3 = this.s3;
        String string = this.prefix;
        String string2 = this.bucketName;
        return ((amazonS3 != null ? amazonS3.hashCode() : 0) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (string2 != null ? string2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof Storage)) break block3;
                Storage storage = (Storage)object;
                if (!Intrinsics.areEqual((Object)this.s3, (Object)storage.s3) || !Intrinsics.areEqual((Object)this.prefix, (Object)storage.prefix) || !Intrinsics.areEqual((Object)this.bucketName, (Object)storage.bucketName)) break block3;
            }
            return true;
        }
        return false;
    }
}

