/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesRequest;
import com.amazonaws.services.cloudformation.model.DescribeStackResourcesResult;
import com.amazonaws.services.cloudformation.model.ResourceStatus;
import com.amazonaws.services.cloudformation.model.StackResource;
import com.atlassian.performance.tools.aws.api.CapacityMediator;
import com.atlassian.performance.tools.aws.api.ScrollingEc2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/aws/api/StackNanny;", "", "cloudformation", "Lcom/amazonaws/services/cloudformation/AmazonCloudFormation;", "ec2", "Lcom/atlassian/performance/tools/aws/api/ScrollingEc2;", "capacity", "Lcom/atlassian/performance/tools/aws/api/CapacityMediator;", "(Lcom/amazonaws/services/cloudformation/AmazonCloudFormation;Lcom/atlassian/performance/tools/aws/api/ScrollingEc2;Lcom/atlassian/performance/tools/aws/api/CapacityMediator;)V", "bumpGlobalLimit", "", "countAllocatedInstances", "", "takeCare", "", "stackName", "aws-resources"})
public final class StackNanny {
    private final AmazonCloudFormation cloudformation;
    private final ScrollingEc2 ec2;
    private final CapacityMediator capacity;

    public final void takeCare(@NotNull String stackName) {
        boolean bl;
        block6: {
            StackResource it;
            Iterable $receiver$iv$iv;
            Intrinsics.checkParameterIsNotNull((Object)stackName, (String)"stackName");
            DescribeStackResourcesResult describeStackResourcesResult = this.cloudformation.describeStackResources(new DescribeStackResourcesRequest().withStackName(stackName));
            Intrinsics.checkExpressionValueIsNotNull((Object)describeStackResourcesResult, (String)"cloudformation\n         \u2026withStackName(stackName))");
            List list = describeStackResourcesResult.getStackResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"cloudformation\n         \u2026          .stackResources");
            Iterable $receiver$iv = list;
            Iterable iterable = $receiver$iv;
            Collection destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (StackResource)element$iv$iv;
                boolean bl2 = false;
                StackResource stackResource = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)stackResource, (String)"it");
                if (!Intrinsics.areEqual((Object)stackResource.getResourceType(), (Object)"AWS::EC2::Instance")) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $receiver$iv = (List)destination$iv$iv;
            $receiver$iv$iv = $receiver$iv;
            destination$iv$iv = new ArrayList();
            for (Object element$iv$iv : $receiver$iv$iv) {
                it = (StackResource)element$iv$iv;
                boolean bl3 = false;
                StackResource stackResource = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)stackResource, (String)"it");
                if (!(ResourceStatus.fromValue((String)stackResource.getResourceStatus()) == ResourceStatus.CREATE_FAILED)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List unluckyInstances = (List)destination$iv$iv;
            $receiver$iv = unluckyInstances;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    StackResource it2 = (StackResource)element$iv;
                    boolean bl4 = false;
                    StackResource stackResource = it2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)stackResource, (String)"it");
                    String string = stackResource.getResourceStatusReason();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.resourceStatusReason");
                    if (!StringsKt.startsWith$default((String)string, (String)"Your quota allows", (boolean)false, (int)2, null)) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        if (bl) {
            throw (Throwable)new Exception(stackName + " stack failed due to a capacity problem: " + this.bumpGlobalLimit());
        }
    }

    private final String bumpGlobalLimit() {
        return this.capacity.bump("EC2 general instance limit", (Function0<Integer>)((Function0)new Function0<Integer>(this){
            final /* synthetic */ StackNanny this$0;

            public final int invoke() {
                return StackNanny.access$countAllocatedInstances(this.this$0) * 2;
            }
            {
                this.this$0 = stackNanny;
                super(0);
            }
        }));
    }

    private final int countAllocatedInstances() {
        return this.ec2.findInstances(this.ec2.allocated()).size();
    }

    public StackNanny(@NotNull AmazonCloudFormation cloudformation, @NotNull ScrollingEc2 ec2, @NotNull CapacityMediator capacity) {
        Intrinsics.checkParameterIsNotNull((Object)cloudformation, (String)"cloudformation");
        Intrinsics.checkParameterIsNotNull((Object)ec2, (String)"ec2");
        Intrinsics.checkParameterIsNotNull((Object)capacity, (String)"capacity");
        this.cloudformation = cloudformation;
        this.ec2 = ec2;
        this.capacity = capacity;
    }

    public static final /* synthetic */ int access$countAllocatedInstances(StackNanny $this) {
        return $this.countAllocatedInstances();
    }
}

