/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.Capability;
import com.amazonaws.services.cloudformation.model.CreateStackRequest;
import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.StackEvent;
import com.amazonaws.services.cloudformation.model.StackStatus;
import com.atlassian.performance.tools.aws.PageScrollingStackEventsQuerier;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.ProvisionedStack;
import com.atlassian.performance.tools.aws.api.StackFormula$WhenMappings;
import com.atlassian.performance.tools.aws.api.Tag;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.apache.commons.codec.binary.Hex;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001:\u0001/BC\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u0012\b\b\u0002\u0010\r\u001a\u00020\f\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0019\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c2\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c2\u0003J\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c2\u0003J\t\u0010\u001d\u001a\u00020\fH\u00c2\u0003J\t\u0010\u001e\u001a\u00020\fH\u00c2\u0003JK\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\fH\u00c6\u0001J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\b\u0010&\u001a\u00020$H\u0002J\n\u0010'\u001a\u0004\u0018\u00010(H\u0002J\t\u0010)\u001a\u00020*H\u00d6\u0001J\u0006\u0010+\u001a\u00020,J\t\u0010-\u001a\u00020\u0007H\u00d6\u0001J\b\u0010.\u001a\u00020,H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \u0017*\u0004\u0018\u00010\u00160\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/atlassian/performance/tools/aws/api/StackFormula;", "", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "cloudformationTemplate", "", "parameters", "", "Lcom/amazonaws/services/cloudformation/model/Parameter;", "detectionTimeout", "Ljava/time/Duration;", "pollingTimeout", "(Lcom/atlassian/performance/tools/aws/api/Investment;Lcom/atlassian/performance/tools/aws/api/Aws;Ljava/lang/String;Ljava/util/List;Ljava/time/Duration;Ljava/time/Duration;)V", "hash", "Lcom/atlassian/performance/tools/aws/api/StackFormula$StackHash;", "getHash", "()Lcom/atlassian/performance/tools/aws/api/StackFormula$StackHash;", "hash$delegate", "Lkotlin/Lazy;", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "stackName", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "create", "", "ensureExistence", "equals", "", "other", "exists", "find", "Lcom/amazonaws/services/cloudformation/model/Stack;", "hashCode", "", "provision", "Lcom/atlassian/performance/tools/aws/api/ProvisionedStack;", "toString", "waitUntilOperational", "StackHash", "aws-resources"})
public final class StackFormula {
    private final Logger logger;
    private final Lazy hash$delegate;
    private final String stackName;
    private final Investment investment;
    private final Aws aws;
    private final String cloudformationTemplate;
    private final List<Parameter> parameters;
    private final Duration detectionTimeout;
    private final Duration pollingTimeout;

    private final StackHash getHash() {
        Lazy lazy = this.hash$delegate;
        StackFormula stackFormula = this;
        Object var3_3 = null;
        return (StackHash)lazy.getValue();
    }

    @NotNull
    public final ProvisionedStack provision() {
        this.ensureExistence();
        return this.waitUntilOperational();
    }

    private final void ensureExistence() {
        try {
            this.create();
        }
        catch (Exception e) {
            if (this.exists()) {
                this.logger.debug("Stack already exists " + this.stackName);
            }
            throw (Throwable)new Exception("Provisioning " + this.stackName + " failed", e);
        }
    }

    private final boolean exists() {
        return this.find() != null;
    }

    private final Stack find() {
        Stack stack;
        try {
            stack = this.aws.getBatchingCfn$aws_resources().findStack(this.stackName).get(this.detectionTimeout.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            this.logger.debug("Failed to find stack: " + e.getMessage());
            stack = null;
        }
        return stack;
    }

    /*
     * WARNING - void declaration
     */
    private final void create() {
        void var3_5;
        Collection<com.amazonaws.services.cloudformation.model.Tag> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = this.investment.tag();
        CreateStackRequest createStackRequest = new CreateStackRequest();
        AmazonCloudFormation amazonCloudFormation = this.aws.getCloudformation();
        void var2_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Tag tag = (Tag)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            com.amazonaws.services.cloudformation.model.Tag tag2 = it.toCloudformation();
            collection.add(tag2);
        }
        collection = (List)var3_5;
        amazonCloudFormation.createStack(createStackRequest.withTags((Collection)collection).withStackName(this.stackName).withTemplateBody(this.cloudformationTemplate).withParameters((Collection)this.parameters).withCapabilities(new Capability[]{Capability.CAPABILITY_IAM}));
    }

    private final ProvisionedStack waitUntilOperational() {
        Instant deadline = Instant.now().plus(this.pollingTimeout);
        block6: while (Instant.now().compareTo(deadline) < 0) {
            StackStatus status;
            Stack stack = this.aws.getBatchingCfn$aws_resources().findStack(this.stackName).get();
            if (stack == null) {
                this.logger.debug("Stack " + this.stackName + " is not visible yet");
                continue;
            }
            StackStatus stackStatus = status = StackStatus.fromValue((String)stack.getStackStatus());
            if (stackStatus != null) {
                switch (StackFormula$WhenMappings.$EnumSwitchMapping$0[stackStatus.ordinal()]) {
                    case 1: 
                    case 2: {
                        this.logger.debug("Stack " + this.stackName + " is still starting up: " + status);
                        continue block6;
                    }
                    case 3: 
                    case 4: {
                        this.logger.debug("Stack " + this.stackName + " is operational: " + status);
                        return new ProvisionedStack(stack, this.aws);
                    }
                }
            }
            this.logger.error("Stack " + stack + " failed: " + status);
            this.aws.getStackNanny().takeCare(this.stackName);
            try {
                List<StackEvent> list;
                PageScrollingStackEventsQuerier pageScrollingStackEventsQuerier = new PageScrollingStackEventsQuerier.Builder(this.aws.getCloudformation()).build();
                String string = stack.getStackId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"stack.stackId");
                List<StackEvent> stackEvents = list = pageScrollingStackEventsQuerier.getEvents(string);
                boolean bl = false;
                throw (Throwable)new Exception("Stack " + this.stackName + " creation failed: " + stack + "; Stack creation events: " + stackEvents);
            }
            catch (Exception e) {
                throw (Throwable)new Exception("Stack " + this.stackName + " creation failed, but we failed to capture failure reason: " + stack, e);
            }
        }
        throw (Throwable)new Exception("Stack " + this.stackName + " provisioning timed out: " + this.pollingTimeout);
    }

    @JvmOverloads
    public StackFormula(@NotNull Investment investment, @NotNull Aws aws, @NotNull String cloudformationTemplate, @NotNull List<? extends Parameter> parameters, @NotNull Duration detectionTimeout, @NotNull Duration pollingTimeout) {
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        Intrinsics.checkParameterIsNotNull((Object)cloudformationTemplate, (String)"cloudformationTemplate");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)detectionTimeout, (String)"detectionTimeout");
        Intrinsics.checkParameterIsNotNull((Object)pollingTimeout, (String)"pollingTimeout");
        this.investment = investment;
        this.aws = aws;
        this.cloudformationTemplate = cloudformationTemplate;
        this.parameters = parameters;
        this.detectionTimeout = detectionTimeout;
        this.pollingTimeout = pollingTimeout;
        this.logger = LogManager.getLogger(this.getClass());
        this.hash$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StackHash>(this){
            final /* synthetic */ StackFormula this$0;

            @NotNull
            public final StackHash invoke() {
                String templateHash;
                MessageDigest digest = MessageDigest.getInstance("SHA-256");
                String string = StackFormula.access$getCloudformationTemplate$p(this.this$0);
                Charset charset = Charsets.UTF_8;
                String string2 = string;
                if (string2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                byte[] byArray = string2.getBytes(charset);
                Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                digest.update(byArray);
                String string3 = templateHash = Hex.encodeHexString((byte[])digest.digest());
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"templateHash");
                return new StackHash(string3, StackFormula.access$getParameters$p(this.this$0));
            }
            {
                this.this$0 = stackFormula;
                super(0);
            }
        }));
        this.stackName = (String)this.investment.getReuseKey().invoke() + '-' + Integer.toHexString(this.getHash().hashCode());
    }

    public /* synthetic */ StackFormula(Investment investment, Aws aws, String string, List list, Duration duration, Duration duration2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            Duration duration3 = Duration.ofMinutes(3L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofMinutes(3)");
            duration = duration3;
        }
        if ((n & 0x20) != 0) {
            Duration duration4 = Duration.ofMinutes(30L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration4, (String)"Duration.ofMinutes(30)");
            duration2 = duration4;
        }
        this(investment, aws, string, list, duration, duration2);
    }

    @JvmOverloads
    public StackFormula(@NotNull Investment investment, @NotNull Aws aws, @NotNull String cloudformationTemplate, @NotNull List<? extends Parameter> parameters, @NotNull Duration detectionTimeout) {
        this(investment, aws, cloudformationTemplate, parameters, detectionTimeout, null, 32, null);
    }

    @JvmOverloads
    public StackFormula(@NotNull Investment investment, @NotNull Aws aws, @NotNull String cloudformationTemplate, @NotNull List<? extends Parameter> parameters) {
        this(investment, aws, cloudformationTemplate, parameters, null, null, 48, null);
    }

    @JvmOverloads
    public StackFormula(@NotNull Investment investment, @NotNull Aws aws, @NotNull String cloudformationTemplate) {
        this(investment, aws, cloudformationTemplate, null, null, null, 56, null);
    }

    public static final /* synthetic */ String access$getCloudformationTemplate$p(StackFormula $this) {
        return $this.cloudformationTemplate;
    }

    public static final /* synthetic */ List access$getParameters$p(StackFormula $this) {
        return $this.parameters;
    }

    private final Investment component1() {
        return this.investment;
    }

    private final Aws component2() {
        return this.aws;
    }

    private final String component3() {
        return this.cloudformationTemplate;
    }

    private final List<Parameter> component4() {
        return this.parameters;
    }

    private final Duration component5() {
        return this.detectionTimeout;
    }

    private final Duration component6() {
        return this.pollingTimeout;
    }

    @NotNull
    public final StackFormula copy(@NotNull Investment investment, @NotNull Aws aws, @NotNull String cloudformationTemplate, @NotNull List<? extends Parameter> parameters, @NotNull Duration detectionTimeout, @NotNull Duration pollingTimeout) {
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        Intrinsics.checkParameterIsNotNull((Object)cloudformationTemplate, (String)"cloudformationTemplate");
        Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)detectionTimeout, (String)"detectionTimeout");
        Intrinsics.checkParameterIsNotNull((Object)pollingTimeout, (String)"pollingTimeout");
        return new StackFormula(investment, aws, cloudformationTemplate, parameters, detectionTimeout, pollingTimeout);
    }

    public static /* synthetic */ StackFormula copy$default(StackFormula stackFormula, Investment investment, Aws aws, String string, List list, Duration duration, Duration duration2, int n, Object object) {
        if ((n & 1) != 0) {
            investment = stackFormula.investment;
        }
        if ((n & 2) != 0) {
            aws = stackFormula.aws;
        }
        if ((n & 4) != 0) {
            string = stackFormula.cloudformationTemplate;
        }
        if ((n & 8) != 0) {
            list = stackFormula.parameters;
        }
        if ((n & 0x10) != 0) {
            duration = stackFormula.detectionTimeout;
        }
        if ((n & 0x20) != 0) {
            duration2 = stackFormula.pollingTimeout;
        }
        return stackFormula.copy(investment, aws, string, list, duration, duration2);
    }

    @NotNull
    public String toString() {
        return "StackFormula(investment=" + this.investment + ", aws=" + this.aws + ", cloudformationTemplate=" + this.cloudformationTemplate + ", parameters=" + this.parameters + ", detectionTimeout=" + this.detectionTimeout + ", pollingTimeout=" + this.pollingTimeout + ")";
    }

    public int hashCode() {
        Investment investment = this.investment;
        Aws aws = this.aws;
        String string = this.cloudformationTemplate;
        List<Parameter> list = this.parameters;
        Duration duration = this.detectionTimeout;
        Duration duration2 = this.pollingTimeout;
        return (((((investment != null ? ((Object)investment).hashCode() : 0) * 31 + (aws != null ? aws.hashCode() : 0)) * 31 + (string != null ? string.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (duration != null ? ((Object)duration).hashCode() : 0)) * 31 + (duration2 != null ? ((Object)duration2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof StackFormula)) break block3;
                StackFormula stackFormula = (StackFormula)object;
                if (!Intrinsics.areEqual((Object)this.investment, (Object)stackFormula.investment) || !Intrinsics.areEqual((Object)this.aws, (Object)stackFormula.aws) || !Intrinsics.areEqual((Object)this.cloudformationTemplate, (Object)stackFormula.cloudformationTemplate) || !Intrinsics.areEqual(this.parameters, stackFormula.parameters) || !Intrinsics.areEqual((Object)this.detectionTimeout, (Object)stackFormula.detectionTimeout) || !Intrinsics.areEqual((Object)this.pollingTimeout, (Object)stackFormula.pollingTimeout)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/atlassian/performance/tools/aws/api/StackFormula$StackHash;", "", "templateHash", "", "parameters", "", "Lcom/amazonaws/services/cloudformation/model/Parameter;", "(Ljava/lang/String;Ljava/util/List;)V", "getParameters", "()Ljava/util/List;", "getTemplateHash", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "aws-resources"})
    private static final class StackHash {
        @NotNull
        private final String templateHash;
        @NotNull
        private final List<Parameter> parameters;

        @NotNull
        public final String getTemplateHash() {
            return this.templateHash;
        }

        @NotNull
        public final List<Parameter> getParameters() {
            return this.parameters;
        }

        public StackHash(@NotNull String templateHash, @NotNull List<? extends Parameter> parameters) {
            Intrinsics.checkParameterIsNotNull((Object)templateHash, (String)"templateHash");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            this.templateHash = templateHash;
            this.parameters = parameters;
        }

        @NotNull
        public final String component1() {
            return this.templateHash;
        }

        @NotNull
        public final List<Parameter> component2() {
            return this.parameters;
        }

        @NotNull
        public final StackHash copy(@NotNull String templateHash, @NotNull List<? extends Parameter> parameters) {
            Intrinsics.checkParameterIsNotNull((Object)templateHash, (String)"templateHash");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            return new StackHash(templateHash, parameters);
        }

        public static /* synthetic */ StackHash copy$default(StackHash stackHash, String string, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = stackHash.templateHash;
            }
            if ((n & 2) != 0) {
                list = stackHash.parameters;
            }
            return stackHash.copy(string, list);
        }

        @NotNull
        public String toString() {
            return "StackHash(templateHash=" + this.templateHash + ", parameters=" + this.parameters + ")";
        }

        public int hashCode() {
            String string = this.templateHash;
            List<Parameter> list = this.parameters;
            return (string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof StackHash)) break block3;
                    StackHash stackHash = (StackHash)object;
                    if (!Intrinsics.areEqual((Object)this.templateHash, (Object)stackHash.templateHash) || !Intrinsics.areEqual(this.parameters, stackHash.parameters)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

