/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import java.time.Duration;
import java.time.Instant;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bR\u0013\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/performance/tools/aws/api/SshKeyName;", "", "prefix", "", "lifespan", "Ljava/time/Duration;", "(Ljava/lang/String;Ljava/time/Duration;)V", "name", "(Ljava/lang/String;)V", "expiry", "Ljava/time/Instant;", "getExpiry", "()Ljava/time/Instant;", "logger", "Lorg/apache/logging/log4j/Logger;", "getName", "()Ljava/lang/String;", "Companion", "aws-resources"})
public final class SshKeyName {
    private final Logger logger;
    @Nullable
    private final Instant expiry;
    @NotNull
    private final String name;
    @NotNull
    private static final String DELIMITER = "--";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public final Instant getExpiry() {
        return this.expiry;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public SshKeyName(@NotNull String name) {
        Instant instant;
        SshKeyName sshKeyName;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        this.name = name;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        SshKeyName sshKeyName2 = this;
        try {
            sshKeyName = sshKeyName2;
            instant = Instant.parse(StringsKt.substringAfterLast$default((String)this.name, (String)DELIMITER, null, (int)2, null));
        }
        catch (Exception exception) {
            sshKeyName = sshKeyName2;
            this.logger.debug("Failed to parse expiration time from key " + this.name + ". This key will be treated as expired.");
            instant = null;
        }
        sshKeyName.expiry = instant;
    }

    public SshKeyName(@NotNull String prefix, @NotNull Duration lifespan) {
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)lifespan, (String)"lifespan");
        this(prefix + DELIMITER + Instant.now().plus(lifespan).toString());
    }

    static {
        DELIMITER = DELIMITER;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/atlassian/performance/tools/aws/api/SshKeyName$Companion;", "", "()V", "DELIMITER", "", "getDELIMITER", "()Ljava/lang/String;", "aws-resources"})
    public static final class Companion {
        @NotNull
        public final String getDELIMITER() {
            return DELIMITER;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

