/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.services.ec2.model.CreateKeyPairResult;
import com.amazonaws.services.ec2.model.KeyPair;
import com.atlassian.performance.tools.aws.api.RemoteSshKey;
import com.atlassian.performance.tools.aws.api.SshKey;
import com.atlassian.performance.tools.aws.api.SshKeyFile;
import com.atlassian.performance.tools.aws.api.SshKeyName;
import com.atlassian.performance.tools.io.api.DirectoriesKt;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/aws/api/SshKeyFormula;", "", "ec2", "Lcom/amazonaws/services/ec2/AmazonEC2;", "workingDirectory", "Ljava/nio/file/Path;", "prefix", "", "lifespan", "Ljava/time/Duration;", "(Lcom/amazonaws/services/ec2/AmazonEC2;Ljava/nio/file/Path;Ljava/lang/String;Ljava/time/Duration;)V", "provision", "Lcom/atlassian/performance/tools/aws/api/SshKey;", "aws-resources"})
public final class SshKeyFormula {
    private final AmazonEC2 ec2;
    private final Path workingDirectory;
    private final String prefix;
    private final Duration lifespan;

    @NotNull
    public final SshKey provision() {
        byte[] byArray;
        String string;
        SshKeyName sshKeyName = new SshKeyName(this.prefix, this.lifespan);
        CreateKeyPairResult createKeyPairResult = this.ec2.createKeyPair(new CreateKeyPairRequest(sshKeyName.getName()));
        Intrinsics.checkExpressionValueIsNotNull((Object)createKeyPairResult, (String)"ec2\n            .createK\u2026Request(sshKeyName.name))");
        KeyPair keyPair = createKeyPairResult.getKeyPair();
        StringBuilder stringBuilder = new StringBuilder();
        KeyPair keyPair2 = keyPair;
        Intrinsics.checkExpressionValueIsNotNull((Object)keyPair2, (String)"keyPair");
        Path keyFile = DirectoriesKt.resolveSafely((Path)this.workingDirectory, (String)stringBuilder.append(keyPair2.getKeyName()).append(".pem").toString());
        String string2 = keyPair.getKeyMaterial();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"keyPair.keyMaterial");
        String string3 = string2;
        Charset charset = Charsets.UTF_8;
        String string4 = string = string3;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray2 = string4.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray3 = byArray = byArray2;
        DirectoriesKt.copy((InputStream)new ByteArrayInputStream(byArray3), (Path)keyFile);
        RemoteSshKey remoteSshKey = new RemoteSshKey(sshKeyName, this.ec2);
        SshKeyFile localSshKey = new SshKeyFile(keyFile);
        localSshKey.fixPermissions();
        return new SshKey(localSshKey, remoteSshKey);
    }

    public SshKeyFormula(@NotNull AmazonEC2 ec2, @NotNull Path workingDirectory, @NotNull String prefix, @NotNull Duration lifespan) {
        Intrinsics.checkParameterIsNotNull((Object)ec2, (String)"ec2");
        Intrinsics.checkParameterIsNotNull((Object)workingDirectory, (String)"workingDirectory");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)lifespan, (String)"lifespan");
        this.ec2 = ec2;
        this.workingDirectory = workingDirectory;
        this.prefix = prefix;
        this.lifespan = lifespan;
    }
}

