/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFilePermission;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u000fJ\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0011H\u00d6\u0001R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/performance/tools/aws/api/SshKeyFile;", "", "path", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "getPath", "()Ljava/nio/file/Path;", "component1", "copy", "equals", "", "other", "facilitateSsh", "", "hostIp", "", "fixPermissions", "hashCode", "", "toString", "aws-resources"})
public final class SshKeyFile {
    private final Logger logger;
    @NotNull
    private final Path path;

    public final void facilitateSsh(@NotNull String hostIp) {
        Intrinsics.checkParameterIsNotNull((Object)hostIp, (String)"hostIp");
        this.logger.debug("Remote access command:\n\tssh -i '" + this.path + "' ubuntu@" + hostIp);
    }

    public final void fixPermissions() {
        block0: {
            PosixFileAttributeView posixFileAttributeView = Files.getFileAttributeView(this.path, PosixFileAttributeView.class, new LinkOption[0]);
            if (posixFileAttributeView == null) break block0;
            posixFileAttributeView.setPermissions(SetsKt.setOf((Object)((Object)PosixFilePermission.OWNER_READ)));
        }
    }

    @NotNull
    public final Path getPath() {
        return this.path;
    }

    public SshKeyFile(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        this.path = path;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    @NotNull
    public final Path component1() {
        return this.path;
    }

    @NotNull
    public final SshKeyFile copy(@NotNull Path path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        return new SshKeyFile(path);
    }

    public static /* synthetic */ SshKeyFile copy$default(SshKeyFile sshKeyFile, Path path, int n, Object object) {
        if ((n & 1) != 0) {
            path = sshKeyFile.path;
        }
        return sshKeyFile.copy(path);
    }

    @NotNull
    public String toString() {
        return "SshKeyFile(path=" + this.path + ")";
    }

    public int hashCode() {
        Path path = this.path;
        return path != null ? ((Object)path).hashCode() : 0;
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SshKeyFile)) break block3;
                SshKeyFile sshKeyFile = (SshKeyFile)object;
                if (!Intrinsics.areEqual((Object)this.path, (Object)sshKeyFile.path)) break block3;
            }
            return true;
        }
        return false;
    }
}

