/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.services.cloudformation.AmazonCloudFormation;
import com.amazonaws.services.cloudformation.model.DescribeStacksRequest;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.services.cloudformation.model.Stack;
import com.amazonaws.services.cloudformation.model.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0004\u0012\u00020\u000b0\rR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/performance/tools/aws/api/ScrollingCloudformation;", "", "cloudformation", "Lcom/amazonaws/services/cloudformation/AmazonCloudFormation;", "(Lcom/amazonaws/services/cloudformation/AmazonCloudFormation;)V", "filterOutStacksNotProvisionedByJpt", "", "Lcom/amazonaws/services/cloudformation/model/Stack;", "response", "Lcom/amazonaws/services/cloudformation/model/DescribeStacksResult;", "scrollThroughStacks", "", "batchAction", "Lkotlin/Function1;", "aws-resources"})
public final class ScrollingCloudformation {
    private final AmazonCloudFormation cloudformation;

    public final void scrollThroughStacks(@NotNull Function1<? super List<? extends Stack>, Unit> batchAction) {
        DescribeStacksResult response;
        Intrinsics.checkParameterIsNotNull(batchAction, (String)"batchAction");
        String token = null;
        do {
            DescribeStacksResult describeStacksResult = response = this.cloudformation.describeStacks(new DescribeStacksRequest().withNextToken(token));
            Intrinsics.checkExpressionValueIsNotNull((Object)describeStacksResult, (String)"response");
            batchAction.invoke(this.filterOutStacksNotProvisionedByJpt(describeStacksResult));
        } while ((token = response.getNextToken()) != null);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Stack> filterOutStacksNotProvisionedByJpt(DescribeStacksResult response) {
        void $receiver$iv$iv;
        List list = response.getStacks();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"response\n            .stacks");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            void $receiver$iv$iv2;
            void $receiver$iv2;
            Stack it = (Stack)element$iv$iv;
            boolean bl = false;
            Stack stack = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)stack, (String)"it");
            List list2 = stack.getTags();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"it\n                    .tags");
            Iterable iterable2 = list2;
            void var10_10 = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv2) {
                Tag it2 = (Tag)element$iv$iv2;
                boolean bl2 = false;
                Tag tag = it2;
                Intrinsics.checkExpressionValueIsNotNull((Object)tag, (String)"it");
                if (!Intrinsics.areEqual((Object)tag.getKey(), (Object)"lifespan")) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            iterable2 = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
            if (!(!iterable2.isEmpty())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public ScrollingCloudformation(@NotNull AmazonCloudFormation cloudformation) {
        Intrinsics.checkParameterIsNotNull((Object)cloudformation, (String)"cloudformation");
        this.cloudformation = cloudformation;
    }
}

