/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DeleteKeyPairRequest;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.SshKeyName;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\f\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/performance/tools/aws/api/RemoteSshKey;", "Lcom/atlassian/performance/tools/aws/api/Resource;", "nameWithExpiry", "Lcom/atlassian/performance/tools/aws/api/SshKeyName;", "ec2", "Lcom/amazonaws/services/ec2/AmazonEC2;", "(Lcom/atlassian/performance/tools/aws/api/SshKeyName;Lcom/amazonaws/services/ec2/AmazonEC2;)V", "expiry", "Ljava/time/Instant;", "logger", "Lorg/apache/logging/log4j/Logger;", "name", "", "getName", "()Ljava/lang/String;", "isExpired", "", "release", "Ljava/util/concurrent/CompletableFuture;", "aws-resources"})
public final class RemoteSshKey
implements Resource {
    private final Logger logger;
    @NotNull
    private final String name;
    private final Instant expiry;
    private final AmazonEC2 ec2;

    @NotNull
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isExpired() {
        Instant instant = this.expiry;
        return instant != null ? instant.isBefore(Instant.now()) : true;
    }

    @Override
    @NotNull
    public CompletableFuture<?> release() {
        CompletableFuture<Void> completableFuture = CompletableFuture.runAsync(new Runnable(this){
            final /* synthetic */ RemoteSshKey this$0;

            public final void run() {
                RemoteSshKey.access$getLogger$p(this.this$0).debug("Deleting key pair " + this.this$0.getName());
                RemoteSshKey.access$getEc2$p(this.this$0).deleteKeyPair(new DeleteKeyPairRequest().withKeyName(this.this$0.getName()));
            }
            {
                this.this$0 = remoteSshKey;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull(completableFuture, (String)"CompletableFuture.runAsy\u2026hKeyName(name))\n        }");
        return completableFuture;
    }

    public RemoteSshKey(@NotNull SshKeyName nameWithExpiry, @NotNull AmazonEC2 ec2) {
        Intrinsics.checkParameterIsNotNull((Object)nameWithExpiry, (String)"nameWithExpiry");
        Intrinsics.checkParameterIsNotNull((Object)ec2, (String)"ec2");
        this.ec2 = ec2;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.name = nameWithExpiry.getName();
        this.expiry = nameWithExpiry.getExpiry();
    }

    public static final /* synthetic */ Logger access$getLogger$p(RemoteSshKey $this) {
        return $this.logger;
    }

    public static final /* synthetic */ AmazonEC2 access$getEc2$p(RemoteSshKey $this) {
        return $this.ec2;
    }
}

