/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.api;

import com.amazonaws.regions.Regions;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeImagesRequest;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Image;
import com.atlassian.performance.tools.aws.CanonicalOwnerIdRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0011\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0096\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/aws/api/CanonicalImageIdByNameResolver;", "Lkotlin/Function1;", "", "ec2", "Lcom/amazonaws/services/ec2/AmazonEC2;", "region", "Lcom/amazonaws/regions/Regions;", "(Lcom/amazonaws/services/ec2/AmazonEC2;Lcom/amazonaws/regions/Regions;)V", "invoke", "imageName", "Builder", "aws-resources"})
public final class CanonicalImageIdByNameResolver
implements Function1<String, String> {
    private final AmazonEC2 ec2;
    private final Regions region;

    /*
     * WARNING - void declaration
     */
    @NotNull
    public String invoke(@NotNull String imageName) {
        List list;
        void $receiver$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)imageName, (String)"imageName");
        DescribeImagesResult describeImagesResult = this.ec2.describeImages(new DescribeImagesRequest().withFilters(new Filter[]{new Filter("name", CollectionsKt.listOf((Object)imageName)), new Filter("owner-id", CollectionsKt.listOf((Object)CanonicalOwnerIdRegistry.INSTANCE.forRegion(this.region)))}));
        Intrinsics.checkExpressionValueIsNotNull((Object)describeImagesResult, (String)"ec2\n        .describeIma\u2026)\n            )\n        )");
        List list2 = describeImagesResult.getImages();
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ec2\n        .describeIma\u2026        )\n        .images");
        Iterable $receiver$iv = list2;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Image image = (Image)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"it");
            String string = v2.getImageId();
            collection.add(string);
        }
        List it = list = (List)destination$iv$iv;
        boolean bl = false;
        if (it.isEmpty()) {
            throw (Throwable)new Exception("Failed to find image " + imageName + " in " + this.region);
        }
        if (it.size() > 1) {
            throw (Throwable)new Exception("More than one image found with name " + imageName + " in declared region " + this.region + ". Selecting any of them automatically could create a security risk, so we can't proceed");
        }
        Object object = CollectionsKt.first((List)it);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"it.first()");
        return (String)object;
    }

    private CanonicalImageIdByNameResolver(AmazonEC2 ec2, Regions region) {
        this.ec2 = ec2;
        this.region = region;
    }

    public /* synthetic */ CanonicalImageIdByNameResolver(AmazonEC2 ec2, Regions region, DefaultConstructorMarker $constructor_marker) {
        this(ec2, region);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/atlassian/performance/tools/aws/api/CanonicalImageIdByNameResolver$Builder;", "", "ec2", "Lcom/amazonaws/services/ec2/AmazonEC2;", "(Lcom/amazonaws/services/ec2/AmazonEC2;)V", "region", "Lcom/amazonaws/regions/Regions;", "build", "Lcom/atlassian/performance/tools/aws/api/CanonicalImageIdByNameResolver;", "aws-resources"})
    public static final class Builder {
        private Regions region;
        private final AmazonEC2 ec2;

        @NotNull
        public final Builder region(@NotNull Regions region) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)region, (String)"region");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.region = region;
            return builder;
        }

        @NotNull
        public final CanonicalImageIdByNameResolver build() {
            return new CanonicalImageIdByNameResolver(this.ec2, this.region, null);
        }

        public Builder(@NotNull AmazonEC2 ec2) {
            Intrinsics.checkParameterIsNotNull((Object)ec2, (String)"ec2");
            this.ec2 = ec2;
        }
    }
}

