/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws.ami;

import com.atlassian.performance.tools.aws.api.SshInstance;
import com.atlassian.performance.tools.aws.api.ami.SshAmiMod;
import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import com.atlassian.performance.tools.jvmtasks.api.IdempotentAction;
import com.atlassian.performance.tools.jvmtasks.api.StaticBackoff;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.io.Closeable;
import java.time.Duration;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0014\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/performance/tools/aws/ami/UnattendedUpgradesOptOut;", "Lcom/atlassian/performance/tools/aws/api/ami/SshAmiMod$SshInstanceMod;", "()V", "expectedDuration", "Ljava/time/Duration;", "getExpectedDuration", "()Ljava/time/Duration;", "useCase", "", "getUseCase", "()Ljava/lang/String;", "modify", "", "sshInstance", "Lcom/atlassian/performance/tools/aws/api/SshInstance;", "tag", "", "aws-resources"})
public final class UnattendedUpgradesOptOut
implements SshAmiMod.SshInstanceMod {
    @NotNull
    private final Duration expectedDuration;
    @NotNull
    private final String useCase = "Avoid unattended-upgrades";

    @Override
    @NotNull
    public Duration getExpectedDuration() {
        return this.expectedDuration;
    }

    @Override
    @NotNull
    public String getUseCase() {
        return this.useCase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modify(@NotNull SshInstance sshInstance) {
        Intrinsics.checkParameterIsNotNull((Object)sshInstance, (String)"sshInstance");
        Closeable closeable = (Closeable)sshInstance.getSsh().newConnection();
        Throwable throwable = null;
        try {
            SshConnection ssh = (SshConnection)closeable;
            boolean bl = false;
            IdempotentAction idempotentAction = new IdempotentAction("remove unattended upgrades", (Function0)new Function0<SshConnection.SshResult>(ssh){
                final /* synthetic */ SshConnection $ssh;

                @NotNull
                public final SshConnection.SshResult invoke() {
                    return this.$ssh.execute("sudo apt remove unattended-upgrades -y");
                }
                {
                    this.$ssh = sshConnection;
                    super(0);
                }
            });
            Duration duration = Duration.ofSeconds(10L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofSeconds(10)");
            SshConnection.SshResult sshResult = (SshConnection.SshResult)idempotentAction.retry(2, (Backoff)new StaticBackoff(duration));
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    @Override
    @NotNull
    public Map<String, String> tag() {
        return MapsKt.mapOf((Pair)TuplesKt.to((Object)"unattended-upgrades-removed", (Object)"true"));
    }

    public UnattendedUpgradesOptOut() {
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(1)");
        this.expectedDuration = duration;
        this.useCase = "Avoid unattended-upgrades";
    }
}

