/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.IpRange;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.atlassian.performance.tools.aws.api.AwaitingEc2;
import com.atlassian.performance.tools.aws.api.Investment;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/aws/Ec2SshAccess;", "", "ec2", "Lcom/amazonaws/services/ec2/AmazonEC2;", "awaitingEc2", "Lcom/atlassian/performance/tools/aws/api/AwaitingEc2;", "(Lcom/amazonaws/services/ec2/AmazonEC2;Lcom/atlassian/performance/tools/aws/api/AwaitingEc2;)V", "getSecurityGroup", "Lcom/amazonaws/services/ec2/model/SecurityGroup;", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "vpcId", "", "aws-resources"})
public final class Ec2SshAccess {
    private final AmazonEC2 ec2;
    private final AwaitingEc2 awaitingEc2;

    @NotNull
    public final SecurityGroup getSecurityGroup(@NotNull Investment investment, @Nullable String vpcId) {
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        CreateSecurityGroupRequest createSecurityGroupRequest = new CreateSecurityGroupRequest().withGroupName((String)investment.getReuseKey().invoke() + "-Ssh").withDescription("Enables SSH access").withVpcId(vpcId);
        Intrinsics.checkExpressionValueIsNotNull((Object)createSecurityGroupRequest, (String)"CreateSecurityGroupReque\u2026        .withVpcId(vpcId)");
        SecurityGroup securityGroup = this.awaitingEc2.allocateSecurityGroup(investment, createSecurityGroupRequest);
        this.ec2.authorizeSecurityGroupIngress(new AuthorizeSecurityGroupIngressRequest().withGroupId(securityGroup.getGroupId()).withIpPermissions(new IpPermission[]{new IpPermission().withIpProtocol("tcp").withFromPort(Integer.valueOf(22)).withToPort(Integer.valueOf(22)).withIpv4Ranges(new IpRange[]{new IpRange().withCidrIp("0.0.0.0/0")})}));
        return securityGroup;
    }

    public static /* synthetic */ SecurityGroup getSecurityGroup$default(Ec2SshAccess ec2SshAccess, Investment investment, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        return ec2SshAccess.getSecurityGroup(investment, string);
    }

    public Ec2SshAccess(@NotNull AmazonEC2 ec2, @NotNull AwaitingEc2 awaitingEc22) {
        Intrinsics.checkParameterIsNotNull((Object)ec2, (String)"ec2");
        Intrinsics.checkParameterIsNotNull((Object)awaitingEc22, (String)"awaitingEc2");
        this.ec2 = ec2;
        this.awaitingEc2 = awaitingEc22;
    }
}

