/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.DescribeImagesResult;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.Image;
import com.amazonaws.services.ec2.model.ImageState;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceState;
import com.amazonaws.services.ec2.model.InstanceStateName;
import com.atlassian.performance.tools.aws.Ec2Instance;
import com.atlassian.performance.tools.aws.TokenScrollingEc2;
import com.atlassian.performance.tools.aws.ami.AmiImage;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.TerminationBatchingEc2;
import com.atlassian.performance.tools.aws.api.TerminationPollingEc2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\bJ\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/aws/Ec2;", "", "ec2", "Lcom/amazonaws/services/ec2/AmazonEC2;", "(Lcom/amazonaws/services/ec2/AmazonEC2;)V", "consumeExpiredInstances", "", "call", "Ljava/util/function/Consumer;", "", "Lcom/atlassian/performance/tools/aws/Ec2Instance;", "listExpiredAmis", "Lcom/atlassian/performance/tools/aws/api/Resource;", "aws-resources"})
public final class Ec2 {
    private final AmazonEC2 ec2;

    public final void consumeExpiredInstances(@NotNull Consumer<List<Ec2Instance>> call) {
        Intrinsics.checkParameterIsNotNull(call, (String)"call");
        TokenScrollingEc2 scrollingEc2 = new TokenScrollingEc2(this.ec2);
        TerminationPollingEc2 terminationPollingEc22 = new TerminationPollingEc2(scrollingEc2);
        TerminationBatchingEc2 terminationBatchingEc22 = new TerminationBatchingEc2(this.ec2, terminationPollingEc22);
        List cleanInstanceStatuses = CollectionsKt.listOf((Object[])new InstanceStateName[]{InstanceStateName.ShuttingDown, InstanceStateName.Terminated});
        Filter[] filterArray = new Filter[]{};
        Function1 function1 = (Function1)new Function1<List<? extends Instance>, Unit>(cleanInstanceStatuses, terminationBatchingEc22, call){
            final /* synthetic */ List $cleanInstanceStatuses;
            final /* synthetic */ TerminationBatchingEc2 $terminationBatchingEc2;
            final /* synthetic */ Consumer $call;

            public final void invoke(@NotNull List<? extends Instance> instanceBatch) {
                Object it;
                Iterable $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull(instanceBatch, (String)"instanceBatch");
                Iterable $receiver$iv = instanceBatch;
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    it = (Instance)element$iv$iv;
                    boolean bl = false;
                    InstanceState instanceState = it.getState();
                    Intrinsics.checkExpressionValueIsNotNull((Object)instanceState, (String)"it.state");
                    if (!(!this.$cleanInstanceStatuses.contains(InstanceStateName.fromValue((String)instanceState.getName())))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    it = (Instance)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    Ec2Instance ec2Instance = new Ec2Instance((Instance)it, this.$terminationBatchingEc2);
                    collection.add(ec2Instance);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    it = (Ec2Instance)element$iv$iv;
                    boolean bl = false;
                    if (!((Ec2Instance)it).isExpired()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List expiredInstances = (List)destination$iv$iv;
                this.$call.accept(expiredInstances);
            }
            {
                this.$cleanInstanceStatuses = list;
                this.$terminationBatchingEc2 = terminationBatchingEc22;
                this.$call = consumer;
                super(1);
            }
        };
        scrollingEc2.scrollThroughInstances(filterArray, (Function1<? super List<? extends Instance>, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Resource> listExpiredAmis() {
        void var3_3;
        Object it;
        Iterable $receiver$iv$iv;
        DescribeImagesResult describeImagesResult = this.ec2.describeImages();
        Intrinsics.checkExpressionValueIsNotNull((Object)describeImagesResult, (String)"ec2.describeImages()");
        List list = describeImagesResult.getImages();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"ec2.describeImages()\n            .images");
        Iterable $receiver$iv = list;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (Image)element$iv$iv;
            boolean bl = false;
            Image image = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"it");
            if (!(ImageState.fromValue((String)image.getState()) != ImageState.Deregistered)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (Image)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Image image = it;
            Intrinsics.checkExpressionValueIsNotNull((Object)image, (String)"it");
            AmiImage amiImage = new AmiImage(image, this.ec2);
            collection.add(amiImage);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            it = (AmiImage)element$iv$iv;
            boolean bl = false;
            if (!((AmiImage)it).isExpired()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)var3_3;
    }

    public Ec2(@NotNull AmazonEC2 ec2) {
        Intrinsics.checkParameterIsNotNull((Object)ec2, (String)"ec2");
        this.ec2 = ec2;
    }
}

