/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.aws;

import com.amazonaws.services.cloudformation.model.Stack;
import com.atlassian.performance.tools.aws.BatchingCloudformation;
import com.atlassian.performance.tools.aws.api.ScrollingCloudformation;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.concurrent.TimersKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.jcip.annotations.ThreadSafe;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@ThreadSafe
@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0011\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f2\u0006\u0010\u0012\u001a\u00020\u000bJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\b\u0010\u0015\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/performance/tools/aws/BatchingCloudformation;", "", "cloudformation", "Lcom/atlassian/performance/tools/aws/api/ScrollingCloudformation;", "refreshPeriod", "Ljava/time/Duration;", "(Lcom/atlassian/performance/tools/aws/api/ScrollingCloudformation;Ljava/time/Duration;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "namesToStackRequests", "", "", "Ljava/util/concurrent/CompletableFuture;", "Lcom/amazonaws/services/cloudformation/model/Stack;", "timer", "Lkotlin/Lazy;", "Ljava/util/Timer;", "findStack", "stackName", "refresh", "", "tryToRefresh", "aws-resources"})
public final class BatchingCloudformation {
    private final Logger logger;
    private final Map<String, CompletableFuture<Stack>> namesToStackRequests;
    private final Lazy<Timer> timer;
    private final ScrollingCloudformation cloudformation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final CompletableFuture<Stack> findStack(@NotNull String stackName) {
        Intrinsics.checkParameterIsNotNull((Object)stackName, (String)"stackName");
        Map<String, CompletableFuture<Stack>> map2 = this.namesToStackRequests;
        synchronized (map2) {
            Object object;
            void $receiver$iv;
            boolean bl = false;
            Map<String, CompletableFuture<Stack>> map3 = this.namesToStackRequests;
            String key$iv = stackName;
            Object value$iv = $receiver$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                CompletableFuture answer$iv = new CompletableFuture();
                $receiver$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            CompletableFuture stackRequest = (CompletableFuture)object;
            this.timer.getValue();
            CompletableFuture completableFuture = stackRequest;
            return completableFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void tryToRefresh() {
        try {
            Map<String, CompletableFuture<Stack>> map2 = this.namesToStackRequests;
            synchronized (map2) {
                boolean bl = false;
                this.refresh();
                Unit unit = Unit.INSTANCE;
            }
        }
        catch (Exception e) {
            this.logger.warn("Failed to refresh stack statuses", (Throwable)e);
        }
    }

    private final void refresh() {
        Map<String, CompletableFuture<Stack>> $receiver$iv;
        if (this.namesToStackRequests.isEmpty()) {
            this.logger.trace("Nothing to request. Omitting.");
            return;
        }
        this.logger.debug("Starting refresh. Looking for: " + this.namesToStackRequests.keySet());
        List foundStackNames = new ArrayList();
        this.cloudformation.scrollThroughStacks((Function1<? super List<? extends Stack>, Unit>)((Function1)new Function1<List<? extends Stack>, Unit>(this, foundStackNames){
            final /* synthetic */ BatchingCloudformation this$0;
            final /* synthetic */ List $foundStackNames;

            public final void invoke(@NotNull List<? extends Stack> stacks) {
                Intrinsics.checkParameterIsNotNull(stacks, (String)"stacks");
                Iterable $receiver$iv = stacks;
                for (T element$iv : $receiver$iv) {
                    Stack it = (Stack)element$iv;
                    boolean bl = false;
                    CompletableFuture request = (CompletableFuture)BatchingCloudformation.access$getNamesToStackRequests$p(this.this$0).remove(it.getStackName());
                    if (request == null) continue;
                    request.complete(it);
                    Collection collection = this.$foundStackNames;
                    String string = it.getStackName();
                    collection.add(string);
                }
            }
            {
                this.this$0 = batchingCloudformation;
                this.$foundStackNames = list;
                super(1);
            }
        }));
        this.logger.debug("Finished refresh. Found: " + foundStackNames);
        Map<String, CompletableFuture<Stack>> map2 = $receiver$iv = this.namesToStackRequests;
        Iterator<Map.Entry<String, CompletableFuture<Stack>>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, CompletableFuture<Stack>> element$iv;
            Map.Entry<String, CompletableFuture<Stack>> it = element$iv = iterator.next();
            boolean bl = false;
            it.getValue().complete(null);
        }
        this.namesToStackRequests.clear();
    }

    public BatchingCloudformation(@NotNull ScrollingCloudformation cloudformation, @NotNull Duration refreshPeriod) {
        Intrinsics.checkParameterIsNotNull((Object)cloudformation, (String)"cloudformation");
        Intrinsics.checkParameterIsNotNull((Object)refreshPeriod, (String)"refreshPeriod");
        this.cloudformation = cloudformation;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.namesToStackRequests = new ConcurrentHashMap();
        this.timer = LazyKt.lazy((Function0)((Function0)new Function0<Timer>(this, refreshPeriod){
            final /* synthetic */ BatchingCloudformation this$0;
            final /* synthetic */ Duration $refreshPeriod;

            @NotNull
            public final Timer invoke() {
                Timer timer2;
                String string = "batching-cloudformation-refresh";
                boolean bl = true;
                long l = this.$refreshPeriod.toMillis();
                long l2 = 0L;
                Timer timer3 = timer2 = TimersKt.timer((String)string, (boolean)bl);
                TimerTask timerTask = new TimerTask(this){
                    final /* synthetic */ timer.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public void run() {
                        TimerTask $receiver = this;
                        boolean bl = false;
                        BatchingCloudformation.access$tryToRefresh(this.this$0.this$0);
                    }
                };
                timer3.schedule(timerTask, l2, l);
                return timer2;
            }
            {
                this.this$0 = batchingCloudformation;
                this.$refreshPeriod = duration;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ Map access$getNamesToStackRequests$p(BatchingCloudformation $this) {
        return $this.namesToStackRequests;
    }

    public static final /* synthetic */ void access$tryToRefresh(BatchingCloudformation $this) {
        $this.tryToRefresh();
    }
}

