/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.virtualusers;

import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceType;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.DependentResources;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.ProvisionedStack;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.SshKey;
import com.atlassian.performance.tools.aws.api.StackFormula;
import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.awsinfrastructure.InstanceFilters;
import com.atlassian.performance.tools.awsinfrastructure.api.network.Network;
import com.atlassian.performance.tools.awsinfrastructure.api.network.NetworkFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.network.ProvisionedNetwork;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.ForIpAccessRequester;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.ProvisionedVirtualUsers;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.VirtualUsersFormula;
import com.atlassian.performance.tools.awsinfrastructure.virtualusers.UbuntuVirtualUsersRuntime;
import com.atlassian.performance.tools.infrastructure.api.browser.Browser;
import com.atlassian.performance.tools.infrastructure.api.browser.Chrome;
import com.atlassian.performance.tools.infrastructure.api.splunk.DisabledSplunkForwarder;
import com.atlassian.performance.tools.infrastructure.api.splunk.SplunkForwarder;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.ResultsTransport;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.SshVirtualUsers;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.VirtualUsers;
import com.atlassian.performance.tools.io.api.ClasspathResourcesKt;
import com.atlassian.performance.tools.jvmtasks.api.EventBus;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.atlassian.performance.tools.ssh.api.SshHost;
import java.io.Closeable;
import java.io.File;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001%BM\b\u0002\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013JD\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 2\u0006\u0010\"\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/StackVirtualUsersFormula;", "Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/VirtualUsersFormula;", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/SshVirtualUsers;", "nodeOrder", "", "shadowJar", "Ljava/io/File;", "splunkForwarder", "Lcom/atlassian/performance/tools/infrastructure/api/splunk/SplunkForwarder;", "browser", "Lcom/atlassian/performance/tools/infrastructure/api/browser/Browser;", "stackCreationTimeout", "Ljava/time/Duration;", "overriddenNetwork", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "instanceType", "Lcom/amazonaws/services/ec2/model/InstanceType;", "sshCidrIp", "", "(ILjava/io/File;Lcom/atlassian/performance/tools/infrastructure/api/splunk/SplunkForwarder;Lcom/atlassian/performance/tools/infrastructure/api/browser/Browser;Ljava/time/Duration;Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;Lcom/amazonaws/services/ec2/model/InstanceType;Ljava/lang/String;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "name", "provision", "Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/ProvisionedVirtualUsers;", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "shadowJarTransport", "Lcom/atlassian/performance/tools/aws/api/Storage;", "resultsTransport", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/ResultsTransport;", "key", "Ljava/util/concurrent/Future;", "Lcom/atlassian/performance/tools/aws/api/SshKey;", "roleProfile", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "Builder", "aws-infrastructure"})
public final class StackVirtualUsersFormula
implements VirtualUsersFormula<SshVirtualUsers> {
    private final Logger logger;
    private final String name;
    private final int nodeOrder;
    private final File shadowJar;
    private final SplunkForwarder splunkForwarder;
    private final Browser browser;
    private final Duration stackCreationTimeout;
    private final Network overriddenNetwork;
    private final InstanceType instanceType;
    private final String sshCidrIp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public ProvisionedVirtualUsers<SshVirtualUsers> provision(@NotNull Investment investment, @NotNull Storage shadowJarTransport, @NotNull ResultsTransport resultsTransport, @NotNull Future<SshKey> key, @NotNull String roleProfile, @NotNull Aws aws) {
        Unit unit;
        String virtualUsersSshIp;
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        Intrinsics.checkParameterIsNotNull((Object)shadowJarTransport, (String)"shadowJarTransport");
        Intrinsics.checkParameterIsNotNull((Object)resultsTransport, (String)"resultsTransport");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)roleProfile, (String)"roleProfile");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        this.logger.debug("Setting up " + this.name + "...");
        ProvisionedNetwork provisionedNetwork2 = new NetworkFormula(investment, aws).reuseOrProvision$aws_infrastructure(this.overriddenNetwork);
        Network network = provisionedNetwork2.getNetwork();
        Duration duration = this.stackCreationTimeout;
        Duration duration2 = null;
        Aws aws2 = aws;
        List list = CollectionsKt.listOf((Object[])new Parameter[]{new Parameter().withParameterKey("KeyName").withParameterValue(key.get().getRemote().getName()), new Parameter().withParameterKey("InstanceProfile").withParameterValue(roleProfile), new Parameter().withParameterKey("Ami").withParameterValue(aws.getDefaultAmi()), new Parameter().withParameterKey("Vpc").withParameterValue(network.getVpc().getVpcId()), new Parameter().withParameterKey("Subnet").withParameterValue(network.getSubnet().getSubnetId()), new Parameter().withParameterKey("InstanceType").withParameterValue(this.instanceType.toString()), new Parameter().withParameterKey("SSHCidrIp").withParameterValue(this.sshCidrIp)});
        Object object = ClasspathResourcesKt.readResourceText((String)"aws/virtual-users.yaml");
        ProvisionedStack virtualUsersStack = new StackFormula(investment, aws2, (String)object, list, duration2, duration, 16, null).provision();
        Instance virtualUsersMachine = new InstanceFilters().vuNodes$aws_infrastructure(virtualUsersStack.listMachines());
        EventBus.INSTANCE.publish((Object)virtualUsersMachine);
        String string = virtualUsersSshIp = virtualUsersMachine.getPublicIpAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"virtualUsersSshIp");
        Ssh virtualUsersSsh = new Ssh(new SshHost(string, "ubuntu", key.get().getFile().getPath()), 4);
        key.get().getFile().facilitateSsh(virtualUsersSshIp);
        String jarPath = new UbuntuVirtualUsersRuntime().prepareForExecution(virtualUsersSsh, this.shadowJar, shadowJarTransport, this.browser);
        object = (Closeable)virtualUsersSsh.newConnection();
        Object object2 = null;
        try {
            SshConnection it = (SshConnection)object;
            boolean bl = false;
            it.execute("mkdir splunkforward");
            this.splunkForwarder.run(it, this.name, "/home/ubuntu/splunkforward/");
            unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        this.logger.debug(this.name + " is ready to apply load");
        object = virtualUsersSsh;
        object2 = jarPath;
        unit = resultsTransport;
        String string2 = this.name;
        int n = this.nodeOrder;
        return new ProvisionedVirtualUsers.Builder<VirtualUsers>((VirtualUsers)new SshVirtualUsers(string2, n, (ResultsTransport)unit, (String)object2, (Ssh)object)).resource((Resource)new DependentResources((Resource)virtualUsersStack, provisionedNetwork2.getResource())).accessRequester(new ForIpAccessRequester(new Supplier<String>(virtualUsersMachine){
            final /* synthetic */ Instance $virtualUsersMachine;

            public final String get() {
                return this.$virtualUsersMachine.getPublicIpAddress();
            }
            {
                this.$virtualUsersMachine = instance;
            }
        })).build();
    }

    private StackVirtualUsersFormula(int nodeOrder, File shadowJar, SplunkForwarder splunkForwarder, Browser browser, Duration stackCreationTimeout, Network overriddenNetwork, InstanceType instanceType, String sshCidrIp) {
        this.nodeOrder = nodeOrder;
        this.shadowJar = shadowJar;
        this.splunkForwarder = splunkForwarder;
        this.browser = browser;
        this.stackCreationTimeout = stackCreationTimeout;
        this.overriddenNetwork = overriddenNetwork;
        this.instanceType = instanceType;
        this.sshCidrIp = sshCidrIp;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.name = "virtual-user-node-" + this.nodeOrder;
    }

    /* synthetic */ StackVirtualUsersFormula(int n, File file, SplunkForwarder splunkForwarder, Browser browser, Duration duration, Network network, InstanceType instanceType, String string, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        if ((n2 & 0x20) != 0) {
            network = null;
        }
        this(n, file, splunkForwarder, browser, duration, network, instanceType, string);
    }

    public /* synthetic */ StackVirtualUsersFormula(int nodeOrder, File shadowJar, SplunkForwarder splunkForwarder, Browser browser, Duration stackCreationTimeout, Network overriddenNetwork, InstanceType instanceType, String sshCidrIp, DefaultConstructorMarker $constructor_marker) {
        this(nodeOrder, shadowJar, splunkForwarder, browser, stackCreationTimeout, overriddenNetwork, instanceType, sshCidrIp);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\u0006\u0010\u0016\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0015\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0017J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u0015R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/StackVirtualUsersFormula$Builder;", "", "formula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/StackVirtualUsersFormula;", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/StackVirtualUsersFormula;)V", "shadowJar", "Ljava/io/File;", "(Ljava/io/File;)V", "browser", "Lcom/atlassian/performance/tools/infrastructure/api/browser/Browser;", "instanceType", "Lcom/amazonaws/services/ec2/model/InstanceType;", "network", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "nodeOrder", "", "splunkForwarder", "Lcom/atlassian/performance/tools/infrastructure/api/splunk/SplunkForwarder;", "sshCidrIp", "", "stackCreationTimeout", "Ljava/time/Duration;", "build", "network$aws_infrastructure", "aws-infrastructure"})
    public static final class Builder {
        private int nodeOrder;
        private SplunkForwarder splunkForwarder;
        private Browser browser;
        private Duration stackCreationTimeout;
        private Network network;
        private InstanceType instanceType;
        private String sshCidrIp;
        private final File shadowJar;

        @NotNull
        public final Builder nodeOrder(int nodeOrder) {
            Builder builder;
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.nodeOrder = nodeOrder;
            return builder;
        }

        @NotNull
        public final Builder splunkForwarder(@NotNull SplunkForwarder splunkForwarder) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)splunkForwarder, (String)"splunkForwarder");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.splunkForwarder = splunkForwarder;
            return builder;
        }

        @NotNull
        public final Builder browser(@NotNull Browser browser) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.browser = browser;
            return builder;
        }

        @NotNull
        public final Builder stackCreationTimeout(@NotNull Duration stackCreationTimeout) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)stackCreationTimeout, (String)"stackCreationTimeout");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.stackCreationTimeout = stackCreationTimeout;
            return builder;
        }

        @NotNull
        public final Builder instanceType(@NotNull InstanceType instanceType) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)instanceType, (String)"instanceType");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.instanceType = instanceType;
            return builder;
        }

        @NotNull
        public final Builder sshCidrIp(@NotNull String sshCidrIp) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)sshCidrIp, (String)"sshCidrIp");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.sshCidrIp = sshCidrIp;
            return builder;
        }

        @NotNull
        public final Builder network$aws_infrastructure(@NotNull Network network) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.network = network;
            return builder;
        }

        @NotNull
        public final StackVirtualUsersFormula build() {
            return new StackVirtualUsersFormula(this.nodeOrder, this.shadowJar, this.splunkForwarder, this.browser, this.stackCreationTimeout, this.network, this.instanceType, this.sshCidrIp, null);
        }

        public Builder(@NotNull File shadowJar) {
            Intrinsics.checkParameterIsNotNull((Object)shadowJar, (String)"shadowJar");
            this.shadowJar = shadowJar;
            this.nodeOrder = 1;
            this.splunkForwarder = (SplunkForwarder)new DisabledSplunkForwarder();
            this.browser = (Browser)new Chrome();
            Duration duration = Duration.ofMinutes(30L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(30)");
            this.stackCreationTimeout = duration;
            this.instanceType = InstanceType.C59xlarge;
            this.sshCidrIp = "";
        }

        public Builder(@NotNull StackVirtualUsersFormula formula) {
            Intrinsics.checkParameterIsNotNull((Object)formula, (String)"formula");
            this(formula.shadowJar);
            this.nodeOrder = formula.nodeOrder;
            this.splunkForwarder = formula.splunkForwarder;
            this.browser = formula.browser;
            this.stackCreationTimeout = formula.stackCreationTimeout;
            this.network = formula.overriddenNetwork;
            this.instanceType = formula.instanceType;
            this.sshCidrIp = formula.sshCidrIp;
        }
    }
}

