/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.virtualusers;

import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.ShutdownBehavior;
import com.atlassian.performance.tools.aws.api.AwaitingEc2;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.SshInstance;
import com.atlassian.performance.tools.aws.api.SshKey;
import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.awsinfrastructure.api.network.Network;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.ForIpAccessRequester;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.ProvisionedVirtualUsers;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.VirtualUsersFormula;
import com.atlassian.performance.tools.awsinfrastructure.virtualusers.UbuntuVirtualUsersRuntime;
import com.atlassian.performance.tools.infrastructure.api.browser.Browser;
import com.atlassian.performance.tools.infrastructure.api.browser.Chrome;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.ResultsTransport;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.SshVirtualUsers;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.VirtualUsers;
import com.atlassian.performance.tools.ssh.api.Ssh;
import java.io.File;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001$B1\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ(\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002JD\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180!2\u0006\u0010\u0016\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020#H\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/Ec2VirtualUsersFormula;", "Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/VirtualUsersFormula;", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/SshVirtualUsers;", "nodeOrder", "", "shadowJar", "Ljava/io/File;", "browser", "Lcom/atlassian/performance/tools/infrastructure/api/browser/Browser;", "network", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "instanceType", "Lcom/amazonaws/services/ec2/model/InstanceType;", "(ILjava/io/File;Lcom/atlassian/performance/tools/infrastructure/api/browser/Browser;Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;Lcom/amazonaws/services/ec2/model/InstanceType;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "name", "", "allocateInstance", "Lcom/atlassian/performance/tools/aws/api/SshInstance;", "ec2", "Lcom/atlassian/performance/tools/aws/api/AwaitingEc2;", "roleProfile", "key", "Lcom/atlassian/performance/tools/aws/api/SshKey;", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "provision", "Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/ProvisionedVirtualUsers;", "shadowJarTransport", "Lcom/atlassian/performance/tools/aws/api/Storage;", "resultsTransport", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/ResultsTransport;", "Ljava/util/concurrent/Future;", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "Builder", "aws-infrastructure"})
public final class Ec2VirtualUsersFormula
implements VirtualUsersFormula<SshVirtualUsers> {
    private final Logger logger;
    private final String name;
    private final int nodeOrder;
    private final File shadowJar;
    private final Browser browser;
    private final Network network;
    private final InstanceType instanceType;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ProvisionedVirtualUsers<SshVirtualUsers> provision(@NotNull Investment investment, @NotNull Storage shadowJarTransport, @NotNull ResultsTransport resultsTransport, @NotNull Future<SshKey> key, @NotNull String roleProfile, @NotNull Aws aws) {
        void resource;
        void ssh;
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        Intrinsics.checkParameterIsNotNull((Object)shadowJarTransport, (String)"shadowJarTransport");
        Intrinsics.checkParameterIsNotNull((Object)resultsTransport, (String)"resultsTransport");
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)roleProfile, (String)"roleProfile");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        this.logger.debug("Setting up " + this.name + "...");
        SshKey sshKey = key.get();
        AwaitingEc2 awaitingEc2 = aws.getAwaitingEc2();
        SshKey sshKey2 = sshKey;
        Intrinsics.checkExpressionValueIsNotNull((Object)sshKey2, (String)"sshKey");
        SshInstance sshInstance = this.allocateInstance(awaitingEc2, roleProfile, sshKey2, investment);
        Ssh ssh2 = sshInstance.component1();
        Resource resource2 = sshInstance.component2();
        Instance instance = sshInstance.component3();
        String jarPath = new UbuntuVirtualUsersRuntime().prepareForExecution((Ssh)ssh, this.shadowJar, shadowJarTransport, this.browser);
        this.logger.debug(this.name + " is ready to apply load");
        void var12_12 = ssh;
        String string = jarPath;
        ResultsTransport resultsTransport2 = resultsTransport;
        String string2 = this.name;
        int n = this.nodeOrder;
        return new ProvisionedVirtualUsers.Builder<VirtualUsers>((VirtualUsers)new SshVirtualUsers(string2, n, resultsTransport2, string, (Ssh)var12_12)).resource((Resource)resource).accessRequester(new ForIpAccessRequester(new Supplier<String>(instance){
            final /* synthetic */ Instance $instance;

            public final String get() {
                return this.$instance.getPublicIpAddress();
            }
            {
                this.$instance = instance;
            }
        })).build();
    }

    private final SshInstance allocateInstance(AwaitingEc2 ec2, String roleProfile, SshKey key, Investment investment) {
        Network network = this.network;
        return ec2.allocateInstance(investment, key, network != null && (network = network.getVpc()) != null ? network.getVpcId() : null, (Function1)new Function1<RunInstancesRequest, RunInstancesRequest>(this, roleProfile){
            final /* synthetic */ Ec2VirtualUsersFormula this$0;
            final /* synthetic */ String $roleProfile;

            public final RunInstancesRequest invoke(@NotNull RunInstancesRequest launch) {
                Network network;
                Intrinsics.checkParameterIsNotNull((Object)launch, (String)"launch");
                RunInstancesRequest runInstancesRequest = launch.withIamInstanceProfile(new IamInstanceProfileSpecification().withName(this.$roleProfile)).withInstanceInitiatedShutdownBehavior(ShutdownBehavior.Terminate).withInstanceType(Ec2VirtualUsersFormula.access$getInstanceType$p(this.this$0)).withSubnetId((network = Ec2VirtualUsersFormula.access$getNetwork$p(this.this$0)) != null && (network = network.getSubnet()) != null ? network.getSubnetId() : null);
                Intrinsics.checkExpressionValueIsNotNull((Object)runInstancesRequest, (String)"launch\n                .\u2026etwork?.subnet?.subnetId)");
                return runInstancesRequest;
            }
            {
                this.this$0 = ec2VirtualUsersFormula;
                this.$roleProfile = string;
                super(1);
            }
        });
    }

    private Ec2VirtualUsersFormula(int nodeOrder, File shadowJar, Browser browser, Network network, InstanceType instanceType) {
        this.nodeOrder = nodeOrder;
        this.shadowJar = shadowJar;
        this.browser = browser;
        this.network = network;
        this.instanceType = instanceType;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.name = "virtual-user-node-" + this.nodeOrder;
    }

    public /* synthetic */ Ec2VirtualUsersFormula(int nodeOrder, File shadowJar, Browser browser, Network network, InstanceType instanceType, DefaultConstructorMarker $constructor_marker) {
        this(nodeOrder, shadowJar, browser, network, instanceType);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\tJ\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bJ\u0015\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u0013J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/Ec2VirtualUsersFormula$Builder;", "", "formula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/Ec2VirtualUsersFormula;", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/Ec2VirtualUsersFormula;)V", "shadowJar", "Ljava/io/File;", "(Ljava/io/File;)V", "browser", "Lcom/atlassian/performance/tools/infrastructure/api/browser/Browser;", "instanceType", "Lcom/amazonaws/services/ec2/model/InstanceType;", "network", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "nodeOrder", "", "build", "Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/VirtualUsersFormula;", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/SshVirtualUsers;", "network$aws_infrastructure", "aws-infrastructure"})
    public static final class Builder {
        private Browser browser;
        private Network network;
        private int nodeOrder;
        private InstanceType instanceType;
        private File shadowJar;

        @NotNull
        public final Builder network$aws_infrastructure(@NotNull Network network) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.network = network;
            return builder;
        }

        @NotNull
        public final Builder instanceType(@NotNull InstanceType instanceType) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)instanceType, (String)"instanceType");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.instanceType = instanceType;
            return builder;
        }

        @NotNull
        public final Builder browser(@NotNull Browser browser) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)browser, (String)"browser");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.browser = browser;
            return builder;
        }

        @NotNull
        public final Builder nodeOrder(int nodeOrder) {
            Builder builder;
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.nodeOrder = nodeOrder;
            return builder;
        }

        @NotNull
        public final VirtualUsersFormula<SshVirtualUsers> build() {
            InstanceType instanceType = this.instanceType;
            int n = this.nodeOrder;
            Network network = this.network;
            Browser browser = this.browser;
            File file = this.shadowJar;
            return new Ec2VirtualUsersFormula(n, file, browser, network, instanceType, null);
        }

        public Builder(@NotNull File shadowJar) {
            Intrinsics.checkParameterIsNotNull((Object)shadowJar, (String)"shadowJar");
            this.shadowJar = shadowJar;
            this.browser = (Browser)new Chrome();
            this.nodeOrder = 1;
            this.instanceType = InstanceType.C59xlarge;
        }

        public Builder(@NotNull Ec2VirtualUsersFormula formula) {
            Intrinsics.checkParameterIsNotNull((Object)formula, (String)"formula");
            this(formula.shadowJar);
            this.browser = formula.browser;
            this.network = formula.network;
            this.nodeOrder = formula.nodeOrder;
            this.instanceType = formula.instanceType;
        }
    }
}

