/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.storage;

import com.atlassian.performance.tools.awsinfrastructure.api.storage.S3Artifact;
import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002J\u0018\u0010\r\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\bH\u0016J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/S3TarGzDistribution;", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "s3Artifact", "Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/S3Artifact;", "unpackTimeout", "Ljava/time/Duration;", "(Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/S3Artifact;Ljava/time/Duration;)V", "getUnpackedProductName", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "archiveName", "destination", "install", "unpack", "", "aws-infrastructure"})
public final class S3TarGzDistribution
implements ProductDistribution {
    private final S3Artifact s3Artifact;
    private final Duration unpackTimeout;

    @NotNull
    public String install(@NotNull SshConnection ssh, @NotNull String destination) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)destination, (String)"destination");
        this.s3Artifact.download(ssh, destination);
        this.unpack(ssh, this.s3Artifact.getArchiveName(), destination);
        String unpackedProductName = this.getUnpackedProductName(ssh, this.s3Artifact.getArchiveName(), destination);
        return destination + '/' + unpackedProductName;
    }

    private final void unpack(SshConnection ssh, String archiveName, String destination) {
        String string = "tar -xzf " + destination + '/' + archiveName + " --directory " + destination;
        Level level = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level, (String)"Level.TRACE");
        Level level2 = Level.TRACE;
        Intrinsics.checkExpressionValueIsNotNull((Object)level2, (String)"Level.TRACE");
        ssh.execute(string, this.unpackTimeout, level, level2);
    }

    private final String getUnpackedProductName(SshConnection ssh, String archiveName, String destination) {
        return (String)CollectionsKt.first((List)StringsKt.split$default((CharSequence)ssh.execute("tar -tf " + destination + '/' + archiveName + " --directory " + destination + " | head -n 1", this.unpackTimeout).getOutput(), (String[])new String[]{"/"}, (boolean)false, (int)0, (int)6, null));
    }

    public S3TarGzDistribution(@NotNull S3Artifact s3Artifact, @NotNull Duration unpackTimeout) {
        Intrinsics.checkParameterIsNotNull((Object)s3Artifact, (String)"s3Artifact");
        Intrinsics.checkParameterIsNotNull((Object)unpackTimeout, (String)"unpackTimeout");
        this.s3Artifact = s3Artifact;
        this.unpackTimeout = unpackTimeout;
    }
}

