/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer;

import com.amazonaws.services.cloudformation.model.Parameter;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.Vpc;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.ProvisionedStack;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.SshKey;
import com.atlassian.performance.tools.aws.api.StackFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.ElasticLoadBalancerFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.LoadBalancerFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.ProvisionedLoadBalancer;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.ForSecurityGroupAccessRequester;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.SecurityGroupIngressAccessProvider;
import com.atlassian.performance.tools.awsinfrastructure.loadbalancer.ElasticLoadBalancer;
import com.atlassian.performance.tools.io.api.ClasspathResourcesKt;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/ElasticLoadBalancerFormula;", "Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/LoadBalancerFormula;", "()V", "logger", "Lorg/apache/logging/log4j/Logger;", "provision", "Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/ProvisionedLoadBalancer;", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "instances", "", "Lcom/amazonaws/services/ec2/model/Instance;", "vpc", "Lcom/amazonaws/services/ec2/model/Vpc;", "subnet", "Lcom/amazonaws/services/ec2/model/Subnet;", "key", "Lcom/atlassian/performance/tools/aws/api/SshKey;", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "aws-infrastructure"})
public final class ElasticLoadBalancerFormula
implements LoadBalancerFormula {
    private final Logger logger;

    @Override
    @NotNull
    public ProvisionedLoadBalancer provision(@NotNull Investment investment, @NotNull List<? extends Instance> instances, @NotNull Vpc vpc, @NotNull Subnet subnet, @NotNull SshKey key, @NotNull Aws aws) {
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        Intrinsics.checkParameterIsNotNull(instances, (String)"instances");
        Intrinsics.checkParameterIsNotNull((Object)vpc, (String)"vpc");
        Intrinsics.checkParameterIsNotNull((Object)subnet, (String)"subnet");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        this.logger.info("Setting up elastic load balancer...");
        Duration duration = null;
        Duration duration2 = null;
        Aws aws2 = aws;
        List list = CollectionsKt.listOf((Object[])new Parameter[]{new Parameter().withParameterKey("Instances").withParameterValue(CollectionsKt.joinToString$default((Iterable)instances, (CharSequence)",", null, null, (int)0, null, (Function1)provision.stack.1.INSTANCE, (int)30, null)), new Parameter().withParameterKey("Vpc").withParameterValue(vpc.getVpcId()), new Parameter().withParameterKey("Subnet").withParameterValue(subnet.getSubnetId())});
        String string = ClasspathResourcesKt.readResourceText((String)"aws/load-balancer.yaml");
        ProvisionedStack stack2 = new StackFormula(investment, aws2, string, list, duration2, duration, 48, null).provision();
        SecurityGroup securityGroup = stack2.findSecurityGroup("LoadBalancerSecurityGroup");
        this.logger.info("Elastic load balancer is set up");
        int n = 80;
        return new ProvisionedLoadBalancer.Builder(new ElasticLoadBalancer(aws.getLoadBalancer(), stack2.findLoadBalancer())).resource((Resource)stack2).accessProvider(new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), securityGroup, new IntRange(n, 80)).build()).accessRequester(new ForSecurityGroupAccessRequester(new Supplier<SecurityGroup>(securityGroup){
            final /* synthetic */ SecurityGroup $securityGroup;

            @NotNull
            public final SecurityGroup get() {
                return this.$securityGroup;
            }
            {
                this.$securityGroup = securityGroup;
            }
        })).build();
    }

    public ElasticLoadBalancerFormula() {
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }
}

