/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer;

import com.atlassian.performance.tools.infrastructure.api.Sed;
import com.atlassian.performance.tools.infrastructure.api.loadbalancer.LoadBalancer;
import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import com.atlassian.performance.tools.jvmtasks.api.ExponentialBackoff;
import com.atlassian.performance.tools.jvmtasks.api.IdempotentAction;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.io.Closeable;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB-\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bH\u0002J\u0006\u0010\u0015\u001a\u00020\u0011J\u000e\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\bJ\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\f\u001a\u00020\bX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/ApacheProxyLoadBalancer;", "Lcom/atlassian/performance/tools/infrastructure/api/loadbalancer/LoadBalancer;", "nodes", "", "Ljava/net/URI;", "ssh", "Lcom/atlassian/performance/tools/ssh/api/Ssh;", "ipAddress", "", "httpPort", "", "(Ljava/util/List;Lcom/atlassian/performance/tools/ssh/api/Ssh;Ljava/lang/String;I)V", "APACHE_CONFIG_PATH", "uri", "getUri", "()Ljava/net/URI;", "appendToApacheProxyConfiguration", "", "connection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "line", "provision", "tryToProvision", "updateJiraConfiguration", "unpackedProduct", "waitUntilHealthy", "timeout", "Ljava/time/Duration;", "Builder", "aws-infrastructure"})
public final class ApacheProxyLoadBalancer
implements LoadBalancer {
    @NotNull
    private final URI uri;
    private final String APACHE_CONFIG_PATH = "/etc/apache2/sites-enabled/000-default.conf";
    private final List<URI> nodes;
    private final Ssh ssh;

    @NotNull
    public URI getUri() {
        return this.uri;
    }

    public void waitUntilHealthy(@NotNull Duration timeout) {
        Intrinsics.checkParameterIsNotNull((Object)timeout, (String)"timeout");
    }

    public final void provision() {
        IdempotentAction idempotentAction = new IdempotentAction("Installing and configuring apache load balancer", (Function0)new Function0<Unit>(this){
            final /* synthetic */ ApacheProxyLoadBalancer this$0;

            public final void invoke() {
                this.this$0.tryToProvision(ApacheProxyLoadBalancer.access$getSsh$p(this.this$0));
            }
            {
                this.this$0 = apacheProxyLoadBalancer;
                super(0);
            }
        });
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(5)");
        idempotentAction.retry(2, (Backoff)new ExponentialBackoff(duration, 0.0, 2, null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateJiraConfiguration(@NotNull Ssh ssh, @NotNull String unpackedProduct) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)unpackedProduct, (String)"unpackedProduct");
        Closeable closeable = (Closeable)ssh.newConnection();
        Throwable throwable = null;
        try {
            SshConnection shell = (SshConnection)closeable;
            boolean bl = false;
            new Sed().replace(shell, "bindOnInit=\"false\"", "bindOnInit=\"false\" scheme=\"http\" proxyName=\"" + this.getUri().getHost() + "\" proxyPort=\"80\"", unpackedProduct + "/conf/server.xml");
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void tryToProvision(@NotNull Ssh ssh) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Closeable closeable = (Closeable)ssh.newConnection();
        Throwable throwable = null;
        try {
            SshConnection connection = (SshConnection)closeable;
            boolean bl = false;
            Duration duration = Duration.ofMinutes(3L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(3)");
            connection.execute("sudo apt-get update", duration);
            Duration duration2 = Duration.ofMinutes(1L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"Duration.ofMinutes(1)");
            connection.execute("sudo apt-get --assume-yes install apache2", duration2);
            connection.execute("sudo rm " + this.APACHE_CONFIG_PATH);
            connection.execute("sudo touch " + this.APACHE_CONFIG_PATH);
            connection.execute("sudo a2enmod proxy proxy_ajp proxy_http rewrite deflate headers proxy_balancer proxy_connect proxy_html xml2enc lbmethod_byrequests");
            this.appendToApacheProxyConfiguration(connection, "Header add Set-Cookie \\\"ROUTEID=.%{BALANCER_WORKER_ROUTE}e; path=/\\\" env=BALANCER_ROUTE_CHANGED");
            this.appendToApacheProxyConfiguration(connection, "<Proxy balancer://mycluster>");
            Iterable $receiver$iv = this.nodes;
            int index$iv = 0;
            for (Object item$iv : $receiver$iv) {
                void uri;
                int n = index$iv++;
                URI uRI = (URI)item$iv;
                int index = n;
                boolean bl2 = false;
                this.appendToApacheProxyConfiguration(connection, "\tBalancerMember http://" + uri.getHost() + ':' + uri.getPort() + " route=" + index);
            }
            this.appendToApacheProxyConfiguration(connection, "</Proxy>\n");
            this.appendToApacheProxyConfiguration(connection, "ProxyPass / balancer://mycluster/ stickysession=ROUTEID");
            this.appendToApacheProxyConfiguration(connection, "ProxyPassReverse / balancer://mycluster/ stickysession=ROUTEID");
            Duration duration3 = Duration.ofMinutes(3L);
            Intrinsics.checkExpressionValueIsNotNull((Object)duration3, (String)"Duration.ofMinutes(3)");
            SshConnection.SshResult sshResult = connection.execute("sudo service apache2 restart", duration3);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private final void appendToApacheProxyConfiguration(SshConnection connection, String line) {
        connection.execute("echo \"" + line + "\" | sudo tee -a " + this.APACHE_CONFIG_PATH);
    }

    private ApacheProxyLoadBalancer(List<URI> nodes, Ssh ssh, String ipAddress, int httpPort) {
        this.nodes = nodes;
        this.ssh = ssh;
        this.uri = new URI("http://" + ipAddress + ':' + httpPort + '/');
        this.APACHE_CONFIG_PATH = "/etc/apache2/sites-enabled/000-default.conf";
    }

    public /* synthetic */ ApacheProxyLoadBalancer(List nodes, Ssh ssh, String ipAddress, int httpPort, DefaultConstructorMarker $constructor_marker) {
        this(nodes, ssh, ipAddress, httpPort);
    }

    public static final /* synthetic */ Ssh access$getSsh$p(ApacheProxyLoadBalancer $this) {
        return $this.ssh;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010\t\u001a\u00020\u00002\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/ApacheProxyLoadBalancer$Builder;", "", "ssh", "Lcom/atlassian/performance/tools/ssh/api/Ssh;", "(Lcom/atlassian/performance/tools/ssh/api/Ssh;)V", "httpPort", "", "ipAddress", "", "nodes", "", "Ljava/net/URI;", "build", "Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/ApacheProxyLoadBalancer;", "aws-infrastructure"})
    public static final class Builder {
        private List<URI> nodes;
        private String ipAddress;
        private int httpPort;
        private final Ssh ssh;

        @NotNull
        public final Builder nodes(@NotNull List<URI> nodes) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.nodes = nodes;
            return builder;
        }

        @NotNull
        public final Builder ipAddress(@NotNull String ipAddress) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)ipAddress, (String)"ipAddress");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.ipAddress = ipAddress;
            return builder;
        }

        @NotNull
        public final Builder httpPort(int httpPort) {
            Builder builder;
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.httpPort = httpPort;
            return builder;
        }

        @NotNull
        public final ApacheProxyLoadBalancer build() {
            return new ApacheProxyLoadBalancer(this.nodes, this.ssh, this.ipAddress, this.httpPort, null);
        }

        public Builder(@NotNull Ssh ssh) {
            Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
            this.ssh = ssh;
            this.nodes = CollectionsKt.emptyList();
            this.ipAddress = this.ssh.getHost().getIpAddress();
            this.httpPort = 80;
        }
    }
}

