/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.jira;

import com.atlassian.performance.tools.awsinfrastructure.api.CustomDatasetSource;
import com.atlassian.performance.tools.awsinfrastructure.api.RemoteLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StartedNode;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StoppableNode;
import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.infrastructure.api.MeasurementSource;
import com.atlassian.performance.tools.infrastructure.api.jvm.jmx.JmxClient;
import com.atlassian.performance.tools.jvmtasks.api.TaskScope;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB=\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/Jira;", "Lcom/atlassian/performance/tools/infrastructure/api/MeasurementSource;", "nodes", "", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StartedNode;", "jiraHome", "Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;", "database", "address", "Ljava/net/URI;", "jmxClients", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/jmx/JmxClient;", "(Ljava/util/List;Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Ljava/net/URI;Ljava/util/List;)V", "getAddress", "()Ljava/net/URI;", "getDatabase", "()Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;", "getJiraHome", "getJmxClients", "()Ljava/util/List;", "logger", "Lorg/apache/logging/log4j/Logger;", "gatherResults", "", "toDatasetSource", "Lcom/atlassian/performance/tools/awsinfrastructure/api/CustomDatasetSource$Builder;", "toString", "", "Builder", "aws-infrastructure"})
public final class Jira
implements MeasurementSource {
    private final Logger logger;
    private final List<StartedNode> nodes;
    @NotNull
    private final RemoteLocation jiraHome;
    @NotNull
    private final RemoteLocation database;
    @NotNull
    private final URI address;
    @NotNull
    private final List<JmxClient> jmxClients;

    /*
     * WARNING - void declaration
     */
    public void gatherResults() {
        void $receiver$iv$iv;
        if (this.nodes.isEmpty()) {
            this.logger.warn("No Jira nodes known to JPT, not downloading node results");
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(RangesKt.coerceAtMost((int)this.nodes.size(), (int)4), new ThreadFactoryBuilder().setNameFormat("results-gathering-thread-%d").build());
        Iterable $receiver$iv = this.nodes;
        Iterable iterable = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            StartedNode startedNode = (StartedNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ExecutorService executorService = executor;
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
            CompletableFuture completableFuture = TaskContextKt.submitWithLogContext((ExecutorService)executorService, (String)("gather " + it), (Function0)((Function0)new Function0<Unit>((StartedNode)it){
                final /* synthetic */ StartedNode $it;

                public final void invoke() {
                    this.$it.gatherResults();
                }
                {
                    this.$it = startedNode;
                    super(0);
                }
            }));
            collection.add(completableFuture);
        }
        $receiver$iv = (List)destination$iv$iv;
        for (Object element$iv : $receiver$iv) {
            CompletableFuture it = (CompletableFuture)element$iv;
            boolean bl = false;
            it.get();
        }
        TaskScope.INSTANCE.task("gather analytics", (Callable)new Callable<Unit>(this){
            final /* synthetic */ Jira this$0;

            @Nullable
            public final Unit call() {
                Unit unit;
                StartedNode startedNode = (StartedNode)CollectionsKt.firstOrNull((List)Jira.access$getNodes$p(this.this$0));
                if (startedNode != null) {
                    startedNode.gatherAnalyticLogs();
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
                return unit;
            }
            {
                this.this$0 = jira;
            }
        });
        executor.shutdownNow();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CustomDatasetSource.Builder toDatasetSource() {
        void var3_7;
        Collection<StoppableNode> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        CustomDatasetSource.Builder builder;
        Iterable iterable = this.nodes;
        RemoteLocation remoteLocation = this.database;
        RemoteLocation remoteLocation2 = this.jiraHome;
        CustomDatasetSource.Builder builder2 = builder;
        CustomDatasetSource.Builder builder3 = builder;
        void var2_6 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            StartedNode startedNode = (StartedNode)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            StoppableNode stoppableNode = it.toStoppableNode();
            collection.add(stoppableNode);
        }
        collection = (List)var3_7;
        builder2(remoteLocation2, remoteLocation, (List<StoppableNode>)collection);
        return builder3;
    }

    @NotNull
    public String toString() {
        return "Jira(address=" + this.address + ')';
    }

    @NotNull
    public final RemoteLocation getJiraHome() {
        return this.jiraHome;
    }

    @NotNull
    public final RemoteLocation getDatabase() {
        return this.database;
    }

    @NotNull
    public final URI getAddress() {
        return this.address;
    }

    @NotNull
    public final List<JmxClient> getJmxClients() {
        return this.jmxClients;
    }

    private Jira(List<StartedNode> nodes, RemoteLocation jiraHome, RemoteLocation database, URI address, List<? extends JmxClient> jmxClients) {
        this.nodes = nodes;
        this.jiraHome = jiraHome;
        this.database = database;
        this.address = address;
        this.jmxClients = jmxClients;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    /* synthetic */ Jira(List list, RemoteLocation remoteLocation, RemoteLocation remoteLocation2, URI uRI, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        this(list, remoteLocation, remoteLocation2, uRI, list2);
    }

    public /* synthetic */ Jira(List nodes, RemoteLocation jiraHome, RemoteLocation database, URI address, List jmxClients, DefaultConstructorMarker $constructor_marker) {
        this(nodes, jiraHome, database, address, jmxClients);
    }

    public static final /* synthetic */ List access$getNodes$p(Jira $this) {
        return $this.nodes;
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B+\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000b\u001a\u00020\u00002\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/Jira$Builder;", "", "nodes", "", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StartedNode;", "jiraHome", "Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;", "database", "address", "Ljava/net/URI;", "(Ljava/util/List;Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Lcom/atlassian/performance/tools/awsinfrastructure/api/RemoteLocation;Ljava/net/URI;)V", "jmxClients", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/jmx/JmxClient;", "build", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/Jira;", "aws-infrastructure"})
    public static final class Builder {
        private List<? extends JmxClient> jmxClients;
        private final List<StartedNode> nodes;
        private final RemoteLocation jiraHome;
        private final RemoteLocation database;
        private final URI address;

        @NotNull
        public final Builder jmxClients(@NotNull List<? extends JmxClient> jmxClients) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull(jmxClients, (String)"jmxClients");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.jmxClients = jmxClients;
            return builder;
        }

        @NotNull
        public final Jira build() {
            return new Jira(this.nodes, this.jiraHome, this.database, this.address, this.jmxClients, null);
        }

        public Builder(@NotNull List<StartedNode> nodes, @NotNull RemoteLocation jiraHome, @NotNull RemoteLocation database, @NotNull URI address) {
            Intrinsics.checkParameterIsNotNull(nodes, (String)"nodes");
            Intrinsics.checkParameterIsNotNull((Object)jiraHome, (String)"jiraHome");
            Intrinsics.checkParameterIsNotNull((Object)database, (String)"database");
            Intrinsics.checkParameterIsNotNull((Object)address, (String)"address");
            this.nodes = nodes;
            this.jiraHome = jiraHome;
            this.database = database;
            this.address = address;
            this.jmxClients = CollectionsKt.emptyList();
        }
    }
}

