/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api;

import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.CompositeResource;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.SshKey;
import com.atlassian.performance.tools.aws.api.SshKeyFormula;
import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.awsinfrastructure.api.DatasetCatalogue;
import com.atlassian.performance.tools.awsinfrastructure.api.Infrastructure;
import com.atlassian.performance.tools.awsinfrastructure.api.ProvisionedInfrastructure;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.DataCenterFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.Jira;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.JiraFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.JiraSoftwareDevDistribution;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.ProvisionedJira;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StandaloneFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.network.Network;
import com.atlassian.performance.tools.awsinfrastructure.api.network.NetworkFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.network.ProvisionedNetwork;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.Ec2VirtualUsersFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.MulticastVirtualUsersFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.ProvisionedVirtualUsers;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.StackVirtualUsersFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.VirtualUsersFormula;
import com.atlassian.performance.tools.awsinfrastructure.virtualusers.S3ResultsTransport;
import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.infrastructure.api.dataset.Dataset;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.SshVirtualUsers;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.VirtualUsers;
import com.atlassian.performance.tools.jvmtasks.api.TaskScope;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.nio.file.Path;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003:\u0001\u0018B7\b\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\u0012\u001a\u00020\rH\u0002J\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00000\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/InfrastructureFormula;", "T", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/VirtualUsers;", "", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "jiraFormula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/JiraFormula;", "virtualUsersFormula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/VirtualUsersFormula;", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "preProvisionedNetwork", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "(Lcom/atlassian/performance/tools/aws/api/Investment;Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/JiraFormula;Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/VirtualUsersFormula;Lcom/atlassian/performance/tools/aws/api/Aws;Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "overrideJiraNetwork", "network", "overrideVuNetwork", "provision", "Lcom/atlassian/performance/tools/awsinfrastructure/api/ProvisionedInfrastructure;", "workingDirectory", "Ljava/nio/file/Path;", "Builder", "aws-infrastructure"})
public final class InfrastructureFormula<T extends VirtualUsers> {
    private final Logger logger;
    private final Investment investment;
    private final JiraFormula jiraFormula;
    private final VirtualUsersFormula<T> virtualUsersFormula;
    private final Aws aws;
    private final Network preProvisionedNetwork;

    @NotNull
    public final ProvisionedInfrastructure<T> provision(@NotNull Path workingDirectory) {
        ExecutorService executor;
        Intrinsics.checkParameterIsNotNull((Object)workingDirectory, (String)"workingDirectory");
        this.logger.info("Provisioning infrastructure...");
        String nonce = (String)this.investment.getReuseKey().invoke();
        Storage resultsStorage = this.aws.resultsStorage(nonce);
        String roleProfile = this.aws.shortTermStorageAccess();
        ExecutorService executorService = executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("provisioning-thread-%d").build());
        Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
        CompletableFuture keyProvisioning2 = TaskContextKt.submitWithLogContext((ExecutorService)executorService, (String)"provision key", (Function0)((Function0)new Function0<SshKey>(this, workingDirectory, nonce){
            final /* synthetic */ InfrastructureFormula this$0;
            final /* synthetic */ Path $workingDirectory;
            final /* synthetic */ String $nonce;

            @NotNull
            public final SshKey invoke() {
                return new SshKeyFormula(InfrastructureFormula.access$getAws$p(this.this$0).getEc2(), this.$workingDirectory, this.$nonce, InfrastructureFormula.access$getInvestment$p(this.this$0).getLifespan()).provision();
            }
            {
                this.this$0 = infrastructureFormula;
                this.$workingDirectory = path;
                this.$nonce = string;
                super(0);
            }
        }));
        ProvisionedNetwork provisionedNetwork2 = (ProvisionedNetwork)TaskScope.INSTANCE.task("network", (Callable)new Callable<ProvisionedNetwork>(this){
            final /* synthetic */ InfrastructureFormula this$0;

            @NotNull
            public final ProvisionedNetwork call() {
                return new NetworkFormula(InfrastructureFormula.access$getInvestment$p(this.this$0), InfrastructureFormula.access$getAws$p(this.this$0)).reuseOrProvision$aws_infrastructure(InfrastructureFormula.access$getPreProvisionedNetwork$p(this.this$0));
            }
            {
                this.this$0 = infrastructureFormula;
            }
        });
        Network network = provisionedNetwork2.getNetwork();
        CompletableFuture provisionJira2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"jira", (Function0)((Function0)new Function0<ProvisionedJira>(this, network, nonce, resultsStorage, keyProvisioning2, roleProfile){
            final /* synthetic */ InfrastructureFormula this$0;
            final /* synthetic */ Network $network;
            final /* synthetic */ String $nonce;
            final /* synthetic */ Storage $resultsStorage;
            final /* synthetic */ CompletableFuture $keyProvisioning;
            final /* synthetic */ String $roleProfile;

            @NotNull
            public final ProvisionedJira invoke() {
                return InfrastructureFormula.access$overrideJiraNetwork(this.this$0, this.$network).provision(InfrastructureFormula.access$getInvestment$p(this.this$0), InfrastructureFormula.access$getAws$p(this.this$0).jiraStorage(this.$nonce), this.$resultsStorage, this.$keyProvisioning, this.$roleProfile, InfrastructureFormula.access$getAws$p(this.this$0));
            }
            {
                this.this$0 = infrastructureFormula;
                this.$network = network;
                this.$nonce = string;
                this.$resultsStorage = storage;
                this.$keyProvisioning = completableFuture;
                this.$roleProfile = string2;
                super(0);
            }
        }));
        CompletableFuture provisionVirtualUsers2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"virtual users", (Function0)new Function0<ProvisionedVirtualUsers<? extends T>>(this, network, nonce, resultsStorage, keyProvisioning2, roleProfile){
            final /* synthetic */ InfrastructureFormula this$0;
            final /* synthetic */ Network $network;
            final /* synthetic */ String $nonce;
            final /* synthetic */ Storage $resultsStorage;
            final /* synthetic */ CompletableFuture $keyProvisioning;
            final /* synthetic */ String $roleProfile;

            @NotNull
            public final ProvisionedVirtualUsers<T> invoke() {
                return InfrastructureFormula.access$overrideVuNetwork(this.this$0, this.$network).provision(InfrastructureFormula.access$getInvestment$p(this.this$0), InfrastructureFormula.access$getAws$p(this.this$0).virtualUsersStorage(this.$nonce), new S3ResultsTransport(this.$resultsStorage), this.$keyProvisioning, this.$roleProfile, InfrastructureFormula.access$getAws$p(this.this$0));
            }
            {
                this.this$0 = infrastructureFormula;
                this.$network = network;
                this.$nonce = string;
                this.$resultsStorage = storage;
                this.$keyProvisioning = completableFuture;
                this.$roleProfile = string2;
                super(0);
            }
        });
        this.logger.info("Waiting until all Jira nodes are provisioned...");
        ProvisionedJira provisionedJira = (ProvisionedJira)provisionJira2.get();
        this.logger.info("All Jira nodes are available.");
        this.logger.info("Waiting until all virtual user nodes are provisioned...");
        ProvisionedVirtualUsers provisionedVirtualUsers = (ProvisionedVirtualUsers)provisionVirtualUsers2.get();
        SshKey sshKey = (SshKey)keyProvisioning2.get();
        provisionedVirtualUsers.getAccessRequester().requestAccess(provisionedJira.getAccessProvider());
        executor.shutdownNow();
        this.logger.info("All infrastructure is now available.");
        Object t = provisionedVirtualUsers.getVirtualUsers();
        Jira jira = provisionedJira.getJira();
        SshKey sshKey2 = sshKey;
        Intrinsics.checkExpressionValueIsNotNull((Object)sshKey2, (String)"sshKey");
        return new ProvisionedInfrastructure.Builder(new Infrastructure(t, jira, resultsStorage, sshKey2)).resource((Resource)new CompositeResource(CollectionsKt.listOf((Object[])new Resource[]{provisionedJira.getResource(), provisionedVirtualUsers.getResource(), provisionedNetwork2.getResource(), (Resource)sshKey.getRemote()}))).accessProvider(provisionedJira.getAccessProvider()).build();
    }

    private final JiraFormula overrideJiraNetwork(Network network) {
        JiraFormula jiraFormula = this.jiraFormula;
        return jiraFormula instanceof DataCenterFormula ? (JiraFormula)new DataCenterFormula.Builder((DataCenterFormula)this.jiraFormula).network$aws_infrastructure(network).build() : (jiraFormula instanceof StandaloneFormula ? (JiraFormula)new StandaloneFormula.Builder((StandaloneFormula)this.jiraFormula).network$aws_infrastructure(network).build() : this.jiraFormula);
    }

    private final VirtualUsersFormula<T> overrideVuNetwork(Network network) {
        VirtualUsersFormula<T> virtualUsersFormula = this.virtualUsersFormula;
        VirtualUsersFormula<Object> virtualUsersFormula2 = virtualUsersFormula instanceof StackVirtualUsersFormula ? (VirtualUsersFormula<SshVirtualUsers>)new StackVirtualUsersFormula.Builder((StackVirtualUsersFormula)this.virtualUsersFormula).network$aws_infrastructure(network).build() : (virtualUsersFormula instanceof Ec2VirtualUsersFormula ? new Ec2VirtualUsersFormula.Builder((Ec2VirtualUsersFormula)this.virtualUsersFormula).network$aws_infrastructure(network).build() : (virtualUsersFormula instanceof MulticastVirtualUsersFormula ? new MulticastVirtualUsersFormula.Builder((MulticastVirtualUsersFormula)this.virtualUsersFormula).network(network).build() : this.virtualUsersFormula));
        if (virtualUsersFormula2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.atlassian.performance.tools.awsinfrastructure.api.virtualusers.VirtualUsersFormula<T>");
        }
        return virtualUsersFormula2;
    }

    private InfrastructureFormula(Investment investment, JiraFormula jiraFormula, VirtualUsersFormula<? extends T> virtualUsersFormula, Aws aws, Network preProvisionedNetwork) {
        this.investment = investment;
        this.jiraFormula = jiraFormula;
        this.virtualUsersFormula = virtualUsersFormula;
        this.aws = aws;
        this.preProvisionedNetwork = preProvisionedNetwork;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    public /* synthetic */ InfrastructureFormula(Investment investment, JiraFormula jiraFormula, VirtualUsersFormula virtualUsersFormula, Aws aws, Network preProvisionedNetwork, DefaultConstructorMarker $constructor_marker) {
        this(investment, jiraFormula, virtualUsersFormula, aws, preProvisionedNetwork);
    }

    public static final /* synthetic */ Aws access$getAws$p(InfrastructureFormula $this) {
        return $this.aws;
    }

    public static final /* synthetic */ Investment access$getInvestment$p(InfrastructureFormula $this) {
        return $this.investment;
    }

    public static final /* synthetic */ Network access$getPreProvisionedNetwork$p(InfrastructureFormula $this) {
        return $this.preProvisionedNetwork;
    }

    public static final /* synthetic */ JiraFormula access$overrideJiraNetwork(InfrastructureFormula $this, Network network) {
        return $this.overrideJiraNetwork(network);
    }

    public static final /* synthetic */ VirtualUsersFormula access$overrideVuNetwork(InfrastructureFormula $this, Network network) {
        return $this.overrideVuNetwork(network);
    }

    @Metadata(mv={1, 1, 18}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\n\b\u0001\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0010J\b\u0010\u0011\u001a\u00020\fH\u0002J\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00010\u00002\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/InfrastructureFormula$Builder;", "T", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/VirtualUsers;", "", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "virtualUsersFormula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/VirtualUsersFormula;", "(Lcom/atlassian/performance/tools/aws/api/Aws;Lcom/atlassian/performance/tools/awsinfrastructure/api/virtualusers/VirtualUsersFormula;)V", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "jiraFormula", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/JiraFormula;", "network", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "build", "Lcom/atlassian/performance/tools/awsinfrastructure/api/InfrastructureFormula;", "defaultJiraFormula", "aws-infrastructure"})
    public static final class Builder<T extends VirtualUsers> {
        private Investment investment;
        private JiraFormula jiraFormula;
        private Network network;
        private final Aws aws;
        private final VirtualUsersFormula<T> virtualUsersFormula;

        @NotNull
        public final Builder<T> investment(@NotNull Investment investment) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.investment = investment;
            return builder;
        }

        @NotNull
        public final Builder<T> jiraFormula(@NotNull JiraFormula jiraFormula) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)jiraFormula, (String)"jiraFormula");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.jiraFormula = jiraFormula;
            return builder;
        }

        @NotNull
        public final Builder<T> network(@NotNull Network network) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)network, (String)"network");
            Builder $receiver = builder = this;
            boolean bl = false;
            $receiver.network = network;
            return builder;
        }

        @NotNull
        public final InfrastructureFormula<T> build() {
            JiraFormula jiraFormula;
            Investment investment = this.investment;
            if (investment == null) {
                Duration duration = Duration.ofMinutes(120L);
                Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(120)");
                investment = new Investment("Default investment", duration, false, null, 12, null);
            }
            if ((jiraFormula = this.jiraFormula) == null) {
                jiraFormula = this.defaultJiraFormula();
            }
            return new InfrastructureFormula(investment, jiraFormula, this.virtualUsersFormula, this.aws, this.network, null);
        }

        private final JiraFormula defaultJiraFormula() {
            Dataset dataset = new DatasetCatalogue().smallJiraSeven();
            return new StandaloneFormula.Builder(new JiraSoftwareDevDistribution("8.6.0"), dataset.getJiraHomeSource(), dataset.getDatabase()).build();
        }

        public Builder(@NotNull Aws aws, @NotNull VirtualUsersFormula<? extends T> virtualUsersFormula) {
            Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
            Intrinsics.checkParameterIsNotNull(virtualUsersFormula, (String)"virtualUsersFormula");
            this.aws = aws;
            this.virtualUsersFormula = virtualUsersFormula;
        }
    }
}

