/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.virtualusers;

import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.aws.api.StorageLocation;
import com.atlassian.performance.tools.awsinfrastructure.api.aws.AwsCli;
import com.atlassian.performance.tools.infrastructure.api.virtualusers.ResultsTransport;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.time.Duration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/virtualusers/S3ResultsTransport;", "Lcom/atlassian/performance/tools/infrastructure/api/virtualusers/ResultsTransport;", "results", "Lcom/atlassian/performance/tools/aws/api/Storage;", "(Lcom/atlassian/performance/tools/aws/api/Storage;)V", "toString", "", "transportResults", "", "targetDirectory", "sshConnection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "aws-infrastructure"})
public final class S3ResultsTransport
implements ResultsTransport {
    private final Storage results;

    public void transportResults(@NotNull String targetDirectory, @NotNull SshConnection sshConnection) {
        Intrinsics.checkParameterIsNotNull((Object)targetDirectory, (String)"targetDirectory");
        Intrinsics.checkParameterIsNotNull((Object)sshConnection, (String)"sshConnection");
        AwsCli awsCli = new AwsCli();
        StorageLocation storageLocation = this.results.getLocation();
        Duration duration = Duration.ofMinutes(10L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofMinutes(10)");
        awsCli.upload(storageLocation, sshConnection, targetDirectory, duration);
    }

    @NotNull
    public String toString() {
        return "S3ResultsTransport(results=" + this.results + ')';
    }

    public S3ResultsTransport(@NotNull Storage results) {
        Intrinsics.checkParameterIsNotNull((Object)results, (String)"results");
        this.results = results;
    }
}

