/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.jira;

import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.awsinfrastructure.api.jira.StartedNode;
import com.atlassian.performance.tools.awsinfrastructure.jira.StoppedNode;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraLaunchTimeouts;
import com.atlassian.performance.tools.infrastructure.api.jvm.JavaDevelopmentKit;
import com.atlassian.performance.tools.infrastructure.api.jvm.ThreadDump;
import com.atlassian.performance.tools.infrastructure.api.os.OsMetric;
import com.atlassian.performance.tools.infrastructure.api.process.RemoteMonitoringProcess;
import com.atlassian.performance.tools.infrastructure.api.profiler.Profiler;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.io.Closeable;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0017J\t\u0010\u001e\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\u001f\u001a\u00020\u0013H\u00c2\u0003J\t\u0010 \u001a\u00020\u0015H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c2\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c2\u0003J\t\u0010$\u001a\u00020\u0007H\u00c2\u0003J\t\u0010%\u001a\u00020\u0003H\u00c2\u0003J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000b0\nH\u00c2\u0003J\t\u0010'\u001a\u00020\rH\u00c2\u0003J\t\u0010(\u001a\u00020\u000fH\u00c2\u0003J\t\u0010)\u001a\u00020\u0011H\u00c2\u0003J\u0087\u0001\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\b\b\u0002\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u00112\b\b\u0002\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00152\b\b\u0002\u0010\u0016\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010+\u001a\u00020\r2\b\u0010,\u001a\u0004\u0018\u00010-H\u00d6\u0003J\t\u0010.\u001a\u00020/H\u00d6\u0001J\u0010\u00100\u001a\u00020/2\u0006\u0010\u0014\u001a\u000201H\u0002JF\u00102\u001a\u0002032<\u00104\u001a8\u00124\u00122\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b6\u0012\b\b\u0002\u0012\u0004\b\b(\u0014\u0012\u0013\u0012\u00110\u0003\u00a2\u0006\f\b6\u0012\b\b\u0002\u0012\u0004\b\b(\b\u0012\u0004\u0012\u000207050\nH\u0016J\u0010\u00108\u001a\u0002072\u0006\u0010\u0014\u001a\u000201H\u0002J\t\u00109\u001a\u00020\u0003H\u00d6\u0001J0\u0010:\u001a\u0002072\u0006\u0010;\u001a\u00020\u00032\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010\u0014\u001a\u0002012\u0006\u0010@\u001a\u00020AH\u0002J\u0018\u0010\f\u001a\u0002072\u0006\u0010\u0014\u001a\u0002012\u0006\u0010@\u001a\u00020AH\u0002R\u000e\u0010\u0016\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/jira/StandaloneStoppedNode;", "Lcom/atlassian/performance/tools/awsinfrastructure/jira/StoppedNode;", "name", "", "jiraHome", "analyticLogs", "resultsTransport", "Lcom/atlassian/performance/tools/aws/api/Storage;", "unpackedProduct", "osMetrics", "", "Lcom/atlassian/performance/tools/infrastructure/api/os/OsMetric;", "waitForUpgrades", "", "launchTimeouts", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraLaunchTimeouts;", "jdk", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/JavaDevelopmentKit;", "profiler", "Lcom/atlassian/performance/tools/infrastructure/api/profiler/Profiler;", "ssh", "Lcom/atlassian/performance/tools/ssh/api/Ssh;", "adminPasswordPlainText", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/atlassian/performance/tools/aws/api/Storage;Ljava/lang/String;Ljava/util/List;ZLcom/atlassian/performance/tools/infrastructure/api/jira/JiraLaunchTimeouts;Lcom/atlassian/performance/tools/infrastructure/api/jvm/JavaDevelopmentKit;Lcom/atlassian/performance/tools/infrastructure/api/profiler/Profiler;Lcom/atlassian/performance/tools/ssh/api/Ssh;Ljava/lang/String;)V", "getJiraHome", "()Ljava/lang/String;", "logger", "Lorg/apache/logging/log4j/Logger;", "getSsh", "()Lcom/atlassian/performance/tools/ssh/api/Ssh;", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "", "hashCode", "", "pid", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "start", "Lcom/atlassian/performance/tools/awsinfrastructure/api/jira/StartedNode;", "updateConfigurationFunction", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "", "startJira", "toString", "waitForStatusToChange", "statusQuo", "uri", "Ljava/net/URI;", "timeout", "Ljava/time/Duration;", "threadDump", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/ThreadDump;", "aws-infrastructure"})
public final class StandaloneStoppedNode
implements StoppedNode {
    private final Logger logger;
    private final String name;
    @NotNull
    private final String jiraHome;
    private final String analyticLogs;
    private final Storage resultsTransport;
    private final String unpackedProduct;
    private final List<OsMetric> osMetrics;
    private final boolean waitForUpgrades;
    private final JiraLaunchTimeouts launchTimeouts;
    private final JavaDevelopmentKit jdk;
    private final Profiler profiler;
    @NotNull
    private final Ssh ssh;
    private final String adminPasswordPlainText;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public StartedNode start(@NotNull List<? extends Function2<? super Ssh, ? super String, Unit>> updateConfigurationFunction) {
        Intrinsics.checkParameterIsNotNull(updateConfigurationFunction, (String)"updateConfigurationFunction");
        this.logger.info("Starting '" + this.name + "'...");
        List monitoringProcesses = new ArrayList();
        Closeable closeable = (Closeable)this.getSsh().newConnection();
        Throwable throwable = null;
        try {
            SshConnection sshConnection = (SshConnection)closeable;
            Iterable $receiver$iv = this.osMetrics;
            for (Object element$iv : $receiver$iv) {
                OsMetric metric = (OsMetric)element$iv;
                monitoringProcesses.add(metric.start(sshConnection));
            }
            $receiver$iv = updateConfigurationFunction;
            RemoteMonitoringProcess remoteMonitoringProcess = $receiver$iv.iterator();
            while (remoteMonitoringProcess.hasNext()) {
                Object element$iv;
                element$iv = remoteMonitoringProcess.next();
                Function2 it = (Function2)element$iv;
                it.invoke((Object)this.getSsh(), (Object)this.unpackedProduct);
            }
            this.startJira(sshConnection);
            int pid = this.pid(sshConnection);
            monitoringProcesses.add(this.jdk.getJstatMonitoring().start(sshConnection, pid));
            RemoteMonitoringProcess remoteMonitoringProcess2 = this.profiler.start(sshConnection, pid);
            if (remoteMonitoringProcess2 != null) {
                RemoteMonitoringProcess it = remoteMonitoringProcess = remoteMonitoringProcess2;
                monitoringProcesses.add(it);
            }
            ThreadDump threadDump = new ThreadDump(pid, this.jdk);
            try {
                this.waitForUpgrades(sshConnection, threadDump);
            }
            catch (Exception exception) {
                new StartedNode(this.name, this.getJiraHome(), this.analyticLogs, this.resultsTransport, this.unpackedProduct, monitoringProcesses, this.getSsh()).gatherResults();
                throw (Throwable)new Exception("Failed to start the Jira node.", exception);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.logger.info('\'' + this.name + "' is started");
        return new StartedNode(this.name, this.getJiraHome(), this.analyticLogs, this.resultsTransport, this.unpackedProduct, monitoringProcesses, this.getSsh());
    }

    private final void startJira(SshConnection ssh) {
        String string = StringsKt.trimMargin$default((String)("\n            |" + this.jdk.use() + "\n            |./" + this.unpackedProduct + "/bin/start-jira.sh\n            "), null, (int)1, null);
        Duration duration = Duration.ofMinutes(1L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofMinutes(1)");
        ssh.execute(string, duration);
    }

    private final int pid(SshConnection ssh) {
        String string;
        String string2 = string = ssh.execute("cat " + this.unpackedProduct + "/work/catalina.pid").getOutput();
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.CharSequence");
        }
        string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        return Integer.parseInt(string);
    }

    private final void waitForUpgrades(SshConnection ssh, ThreadDump threadDump) {
        if (!this.waitForUpgrades) {
            this.logger.debug("Skipping Jira startup wait");
            return;
        }
        this.logger.debug("Waiting for Jira node to start...");
        URI upgradesEndpoint = new URI("http://admin:" + this.adminPasswordPlainText + "@localhost:8080/rest/api/2/upgrade");
        ThreadDump threadDump2 = threadDump;
        URI uRI = upgradesEndpoint;
        SshConnection sshConnection = ssh;
        Duration duration = this.launchTimeouts.getOfflineTimeout();
        this.waitForStatusToChange("000", uRI, duration, sshConnection, threadDump2);
        threadDump2 = threadDump;
        uRI = upgradesEndpoint;
        sshConnection = ssh;
        duration = this.launchTimeouts.getInitTimeout();
        this.waitForStatusToChange("503", uRI, duration, sshConnection, threadDump2);
        String string = "curl --silent --retry 6 -X POST " + upgradesEndpoint;
        Duration duration2 = Duration.ofSeconds(15L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration2, (String)"ofSeconds(15)");
        ssh.execute(string, duration2);
        threadDump2 = threadDump;
        uRI = upgradesEndpoint;
        sshConnection = ssh;
        duration = this.launchTimeouts.getUpgradeTimeout();
        this.waitForStatusToChange("303", uRI, duration, sshConnection, threadDump2);
    }

    private final void waitForStatusToChange(String statusQuo, URI uri, Duration timeout, SshConnection ssh, ThreadDump threadDump) {
        String currentStatus;
        Duration backoff = Duration.ofSeconds(10L);
        Instant deadline = Instant.now().plus(timeout);
        while (!(Intrinsics.areEqual((Object)(currentStatus = ssh.safeExecute("curl --silent --write-out '%{http_code}' --output /dev/null -X GET " + uri, this.launchTimeouts.getUnresponsivenessTimeout()).getOutput()), (Object)statusQuo) ^ true)) {
            if (deadline.compareTo(Instant.now()) < 0) {
                if (this.logger.isDebugEnabled()) {
                    String string = "cat " + this.getJiraHome() + "/log/atlassian-jira.log";
                    Duration duration = Duration.ofMinutes(3L);
                    Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"ofMinutes(3)");
                    String logContent = ssh.safeExecute(string, duration).getOutput();
                    this.logger.debug("Jira log file: <<" + logContent + ">>");
                }
                throw (Throwable)new Exception(uri + " failed to get out of " + statusQuo + " status within " + timeout);
            }
            threadDump.gather(ssh, "thread-dumps");
            Thread.sleep(backoff.toMillis());
        }
    }

    @Override
    @NotNull
    public String getJiraHome() {
        return this.jiraHome;
    }

    @Override
    @NotNull
    public Ssh getSsh() {
        return this.ssh;
    }

    public StandaloneStoppedNode(@NotNull String name, @NotNull String jiraHome, @NotNull String analyticLogs, @NotNull Storage resultsTransport, @NotNull String unpackedProduct, @NotNull List<? extends OsMetric> osMetrics, boolean waitForUpgrades, @NotNull JiraLaunchTimeouts launchTimeouts, @NotNull JavaDevelopmentKit jdk, @NotNull Profiler profiler, @NotNull Ssh ssh, @NotNull String adminPasswordPlainText) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)jiraHome, (String)"jiraHome");
        Intrinsics.checkParameterIsNotNull((Object)analyticLogs, (String)"analyticLogs");
        Intrinsics.checkParameterIsNotNull((Object)resultsTransport, (String)"resultsTransport");
        Intrinsics.checkParameterIsNotNull((Object)unpackedProduct, (String)"unpackedProduct");
        Intrinsics.checkParameterIsNotNull(osMetrics, (String)"osMetrics");
        Intrinsics.checkParameterIsNotNull((Object)launchTimeouts, (String)"launchTimeouts");
        Intrinsics.checkParameterIsNotNull((Object)jdk, (String)"jdk");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)adminPasswordPlainText, (String)"adminPasswordPlainText");
        this.name = name;
        this.jiraHome = jiraHome;
        this.analyticLogs = analyticLogs;
        this.resultsTransport = resultsTransport;
        this.unpackedProduct = unpackedProduct;
        this.osMetrics = osMetrics;
        this.waitForUpgrades = waitForUpgrades;
        this.launchTimeouts = launchTimeouts;
        this.jdk = jdk;
        this.profiler = profiler;
        this.ssh = ssh;
        this.adminPasswordPlainText = adminPasswordPlainText;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
    }

    private final String component1() {
        return this.name;
    }

    @NotNull
    public final String component2() {
        return this.getJiraHome();
    }

    private final String component3() {
        return this.analyticLogs;
    }

    private final Storage component4() {
        return this.resultsTransport;
    }

    private final String component5() {
        return this.unpackedProduct;
    }

    private final List<OsMetric> component6() {
        return this.osMetrics;
    }

    private final boolean component7() {
        return this.waitForUpgrades;
    }

    private final JiraLaunchTimeouts component8() {
        return this.launchTimeouts;
    }

    private final JavaDevelopmentKit component9() {
        return this.jdk;
    }

    private final Profiler component10() {
        return this.profiler;
    }

    @NotNull
    public final Ssh component11() {
        return this.getSsh();
    }

    private final String component12() {
        return this.adminPasswordPlainText;
    }

    @NotNull
    public final StandaloneStoppedNode copy(@NotNull String name, @NotNull String jiraHome, @NotNull String analyticLogs, @NotNull Storage resultsTransport, @NotNull String unpackedProduct, @NotNull List<? extends OsMetric> osMetrics, boolean waitForUpgrades, @NotNull JiraLaunchTimeouts launchTimeouts, @NotNull JavaDevelopmentKit jdk, @NotNull Profiler profiler, @NotNull Ssh ssh, @NotNull String adminPasswordPlainText) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)jiraHome, (String)"jiraHome");
        Intrinsics.checkParameterIsNotNull((Object)analyticLogs, (String)"analyticLogs");
        Intrinsics.checkParameterIsNotNull((Object)resultsTransport, (String)"resultsTransport");
        Intrinsics.checkParameterIsNotNull((Object)unpackedProduct, (String)"unpackedProduct");
        Intrinsics.checkParameterIsNotNull(osMetrics, (String)"osMetrics");
        Intrinsics.checkParameterIsNotNull((Object)launchTimeouts, (String)"launchTimeouts");
        Intrinsics.checkParameterIsNotNull((Object)jdk, (String)"jdk");
        Intrinsics.checkParameterIsNotNull((Object)profiler, (String)"profiler");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)adminPasswordPlainText, (String)"adminPasswordPlainText");
        return new StandaloneStoppedNode(name, jiraHome, analyticLogs, resultsTransport, unpackedProduct, osMetrics, waitForUpgrades, launchTimeouts, jdk, profiler, ssh, adminPasswordPlainText);
    }

    @NotNull
    public static /* bridge */ /* synthetic */ StandaloneStoppedNode copy$default(StandaloneStoppedNode standaloneStoppedNode, String string, String string2, String string3, Storage storage, String string4, List list, boolean bl, JiraLaunchTimeouts jiraLaunchTimeouts, JavaDevelopmentKit javaDevelopmentKit, Profiler profiler, Ssh ssh, String string5, int n, Object object) {
        if ((n & 1) != 0) {
            string = standaloneStoppedNode.name;
        }
        if ((n & 2) != 0) {
            string2 = standaloneStoppedNode.getJiraHome();
        }
        if ((n & 4) != 0) {
            string3 = standaloneStoppedNode.analyticLogs;
        }
        if ((n & 8) != 0) {
            storage = standaloneStoppedNode.resultsTransport;
        }
        if ((n & 0x10) != 0) {
            string4 = standaloneStoppedNode.unpackedProduct;
        }
        if ((n & 0x20) != 0) {
            list = standaloneStoppedNode.osMetrics;
        }
        if ((n & 0x40) != 0) {
            bl = standaloneStoppedNode.waitForUpgrades;
        }
        if ((n & 0x80) != 0) {
            jiraLaunchTimeouts = standaloneStoppedNode.launchTimeouts;
        }
        if ((n & 0x100) != 0) {
            javaDevelopmentKit = standaloneStoppedNode.jdk;
        }
        if ((n & 0x200) != 0) {
            profiler = standaloneStoppedNode.profiler;
        }
        if ((n & 0x400) != 0) {
            ssh = standaloneStoppedNode.getSsh();
        }
        if ((n & 0x800) != 0) {
            string5 = standaloneStoppedNode.adminPasswordPlainText;
        }
        return standaloneStoppedNode.copy(string, string2, string3, storage, string4, list, bl, jiraLaunchTimeouts, javaDevelopmentKit, profiler, ssh, string5);
    }

    @NotNull
    public String toString() {
        return "StandaloneStoppedNode(name=" + this.name + ", jiraHome=" + this.getJiraHome() + ", analyticLogs=" + this.analyticLogs + ", resultsTransport=" + this.resultsTransport + ", unpackedProduct=" + this.unpackedProduct + ", osMetrics=" + this.osMetrics + ", waitForUpgrades=" + this.waitForUpgrades + ", launchTimeouts=" + this.launchTimeouts + ", jdk=" + this.jdk + ", profiler=" + this.profiler + ", ssh=" + this.getSsh() + ", adminPasswordPlainText=" + this.adminPasswordPlainText + ")";
    }

    public int hashCode() {
        String string = this.name;
        String string2 = this.getJiraHome();
        String string3 = this.analyticLogs;
        Storage storage = this.resultsTransport;
        String string4 = this.unpackedProduct;
        List<OsMetric> list = this.osMetrics;
        int n = ((((((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0)) * 31 + (storage != null ? storage.hashCode() : 0)) * 31 + (string4 != null ? string4.hashCode() : 0)) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31;
        int n2 = this.waitForUpgrades ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        JiraLaunchTimeouts jiraLaunchTimeouts = this.launchTimeouts;
        JavaDevelopmentKit javaDevelopmentKit = this.jdk;
        Profiler profiler = this.profiler;
        Ssh ssh = this.getSsh();
        String string5 = this.adminPasswordPlainText;
        return (((((n + n2) * 31 + (jiraLaunchTimeouts != null ? jiraLaunchTimeouts.hashCode() : 0)) * 31 + (javaDevelopmentKit != null ? javaDevelopmentKit.hashCode() : 0)) * 31 + (profiler != null ? profiler.hashCode() : 0)) * 31 + (ssh != null ? ssh.hashCode() : 0)) * 31 + (string5 != null ? string5.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof StandaloneStoppedNode)) break block3;
                StandaloneStoppedNode standaloneStoppedNode = (StandaloneStoppedNode)object;
                if (!Intrinsics.areEqual((Object)this.name, (Object)standaloneStoppedNode.name) || !Intrinsics.areEqual((Object)this.getJiraHome(), (Object)standaloneStoppedNode.getJiraHome()) || !Intrinsics.areEqual((Object)this.analyticLogs, (Object)standaloneStoppedNode.analyticLogs) || !Intrinsics.areEqual((Object)this.resultsTransport, (Object)standaloneStoppedNode.resultsTransport) || !Intrinsics.areEqual((Object)this.unpackedProduct, (Object)standaloneStoppedNode.unpackedProduct) || !Intrinsics.areEqual(this.osMetrics, standaloneStoppedNode.osMetrics) || !(this.waitForUpgrades == standaloneStoppedNode.waitForUpgrades) || !Intrinsics.areEqual((Object)this.launchTimeouts, (Object)standaloneStoppedNode.launchTimeouts) || !Intrinsics.areEqual((Object)this.jdk, (Object)standaloneStoppedNode.jdk) || !Intrinsics.areEqual((Object)this.profiler, (Object)standaloneStoppedNode.profiler) || !Intrinsics.areEqual((Object)this.getSsh(), (Object)standaloneStoppedNode.getSsh()) || !Intrinsics.areEqual((Object)this.adminPasswordPlainText, (Object)standaloneStoppedNode.adminPasswordPlainText)) break block3;
            }
            return true;
        }
        return false;
    }
}

