/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.jira;

import com.atlassian.performance.tools.aws.api.Storage;
import com.atlassian.performance.tools.awsinfrastructure.api.aws.AwsCli;
import com.atlassian.performance.tools.awsinfrastructure.api.hardware.Computer;
import com.atlassian.performance.tools.awsinfrastructure.jira.NodeFormula;
import com.atlassian.performance.tools.awsinfrastructure.jira.StandaloneStoppedNode;
import com.atlassian.performance.tools.awsinfrastructure.jira.StaticBackoff;
import com.atlassian.performance.tools.concurrency.api.TaskContextKt;
import com.atlassian.performance.tools.infrastructure.api.Sed;
import com.atlassian.performance.tools.infrastructure.api.distribution.ProductDistribution;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraGcLog;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraHomeSource;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraLaunchTimeouts;
import com.atlassian.performance.tools.infrastructure.api.jira.JiraNodeConfig;
import com.atlassian.performance.tools.infrastructure.api.jira.SetenvSh;
import com.atlassian.performance.tools.infrastructure.api.jvm.JavaDevelopmentKit;
import com.atlassian.performance.tools.infrastructure.api.os.Ubuntu;
import com.atlassian.performance.tools.infrastructure.api.profiler.Profiler;
import com.atlassian.performance.tools.jvmtasks.api.Backoff;
import com.atlassian.performance.tools.jvmtasks.api.IdempotentAction;
import com.atlassian.performance.tools.ssh.api.Ssh;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0014J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0002J\b\u0010#\u001a\u00020$H\u0016J\u0018\u0010%\u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010&\u001a\u00020\bH\u0002R\u000e\u0010\u0013\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/jira/StandaloneNodeFormula;", "Lcom/atlassian/performance/tools/awsinfrastructure/jira/NodeFormula;", "jiraHomeSource", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;", "pluginsTransport", "Lcom/atlassian/performance/tools/aws/api/Storage;", "resultsTransport", "databaseIp", "", "productDistribution", "Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;", "ssh", "Lcom/atlassian/performance/tools/ssh/api/Ssh;", "waitForUpgrades", "", "config", "Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraNodeConfig;", "computer", "Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;", "adminPasswordPlainText", "(Lcom/atlassian/performance/tools/infrastructure/api/jira/JiraHomeSource;Lcom/atlassian/performance/tools/aws/api/Storage;Lcom/atlassian/performance/tools/aws/api/Storage;Ljava/lang/String;Lcom/atlassian/performance/tools/infrastructure/api/distribution/ProductDistribution;Lcom/atlassian/performance/tools/ssh/api/Ssh;ZLcom/atlassian/performance/tools/infrastructure/api/jira/JiraNodeConfig;Lcom/atlassian/performance/tools/awsinfrastructure/api/hardware/Computer;Ljava/lang/String;)V", "jdk", "Lcom/atlassian/performance/tools/infrastructure/api/jvm/JavaDevelopmentKit;", "logger", "Lorg/apache/logging/log4j/Logger;", "name", "getName", "()Ljava/lang/String;", "ubuntu", "Lcom/atlassian/performance/tools/infrastructure/api/os/Ubuntu;", "downloadMysqlConnector", "", "url", "connection", "Lcom/atlassian/performance/tools/ssh/api/SshConnection;", "provision", "Lcom/atlassian/performance/tools/awsinfrastructure/jira/StandaloneStoppedNode;", "replaceDbconfigUrl", "dbconfigXml", "aws-infrastructure"})
public final class StandaloneNodeFormula
implements NodeFormula {
    private final Logger logger;
    private final JavaDevelopmentKit jdk;
    private final Ubuntu ubuntu;
    @NotNull
    private final String name;
    private final JiraHomeSource jiraHomeSource;
    private final Storage pluginsTransport;
    private final Storage resultsTransport;
    private final String databaseIp;
    private final ProductDistribution productDistribution;
    private final Ssh ssh;
    private final boolean waitForUpgrades;
    private final JiraNodeConfig config;
    private final Computer computer;
    private final String adminPasswordPlainText;

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public StandaloneStoppedNode provision() {
        this.logger.debug("Setting up " + this.getName() + "...");
        Closeable closeable = (Closeable)this.ssh.newConnection();
        Throwable throwable = null;
        try {
            SshConnection connection = (SshConnection)closeable;
            this.computer.setUp$aws_infrastructure(connection);
            connection = Unit.INSTANCE;
        }
        catch (Throwable connection) {
            throwable = connection;
            throw connection;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("install-product-with-dataset-" + this.config.getName() + "-%d").build());
        try {
            ExecutorService executorService = executor;
            Intrinsics.checkExpressionValueIsNotNull((Object)executorService, (String)"executor");
            CompletableFuture unpackedProductFuture2 = TaskContextKt.submitWithLogContext((ExecutorService)executorService, (String)"install product", (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ StandaloneNodeFormula this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final String invoke() {
                    String string;
                    Closeable closeable = (Closeable)StandaloneNodeFormula.access$getSsh$p(this.this$0).newConnection();
                    Throwable throwable = null;
                    try {
                        SshConnection connection = (SshConnection)closeable;
                        string = StandaloneNodeFormula.access$getProductDistribution$p(this.this$0).install(connection, ".");
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return string;
                }
                {
                    this.this$0 = standaloneNodeFormula;
                    super(0);
                }
            }));
            CompletableFuture jiraHomeFuture2 = TaskContextKt.submitWithLogContext((ExecutorService)executor, (String)"download Jira home", (Function0)((Function0)new Function0<String>(this){
                final /* synthetic */ StandaloneNodeFormula this$0;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @NotNull
                public final String invoke() {
                    String string;
                    Closeable closeable = (Closeable)StandaloneNodeFormula.access$getSsh$p(this.this$0).newConnection();
                    Throwable throwable = null;
                    try {
                        SshConnection connection = (SshConnection)closeable;
                        string = StandaloneNodeFormula.access$getJiraHomeSource$p(this.this$0).download(connection);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    return string;
                }
                {
                    this.this$0 = standaloneNodeFormula;
                    super(0);
                }
            }));
            String jiraHome = (String)jiraHomeFuture2.get();
            String unpackedProduct = (String)unpackedProductFuture2.get();
            Closeable closeable2 = (Closeable)this.ssh.newConnection();
            Throwable throwable2 = null;
            try {
                SshConnection connection = (SshConnection)closeable2;
                this.replaceDbconfigUrl(connection, jiraHome + "/dbconfig.xml");
                String string = unpackedProduct;
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"unpackedProduct");
                new SetenvSh(string).setup(connection, this.config, new JiraGcLog(unpackedProduct), this.ssh.getHost().getIpAddress());
                connection.execute("echo jira.home=`realpath " + jiraHome + "` > " + unpackedProduct + "/atlassian-jira/WEB-INF/classes/jira-application.properties");
                connection.execute("sed -i '/^jira.autoexport=/d' " + jiraHome + "/jira-config.properties");
                connection.execute("echo jira.autoexport=false >> " + jiraHome + "/jira-config.properties");
                this.downloadMysqlConnector("https://dev.mysql.com/get/Downloads/Connector-J/mysql-connector-java-5.1.40.tar.gz", connection);
                connection.execute("tar -xzf mysql-connector-java-5.1.40.tar.gz");
                connection.execute("cp mysql-connector-java-5.1.40/mysql-connector-java-5.1.40-bin.jar " + unpackedProduct + "/lib");
                AwsCli.download$default(new AwsCli(), this.pluginsTransport.getLocation(), connection, jiraHome + "/plugins/installed-plugins", null, 8, null);
                this.jdk.install(connection);
                List osMetrics = this.ubuntu.metrics(connection);
                this.config.getSplunkForwarder().jsonifyLog4j(connection, unpackedProduct + "/atlassian-jira/WEB-INF/classes/log4j.properties");
                this.config.getSplunkForwarder().run(connection, this.getName(), jiraHome + "/log");
                this.config.getProfiler().install(connection);
                this.logger.info(this.getName() + " is set up");
                String string2 = this.getName();
                String string3 = jiraHome;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"jiraHome");
                String string4 = this.adminPasswordPlainText;
                Profiler profiler = this.config.getProfiler();
                JavaDevelopmentKit javaDevelopmentKit = this.jdk;
                JiraLaunchTimeouts jiraLaunchTimeouts = this.config.getLaunchTimeouts();
                boolean bl = this.waitForUpgrades;
                Ssh ssh = this.ssh;
                StandaloneStoppedNode standaloneStoppedNode = new StandaloneStoppedNode(string2, string3, jiraHome, this.resultsTransport, unpackedProduct, osMetrics, bl, jiraLaunchTimeouts, javaDevelopmentKit, profiler, ssh, string4);
                StandaloneStoppedNode standaloneStoppedNode2 = standaloneStoppedNode;
                return standaloneStoppedNode2;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            {
                catch (Throwable throwable4) {
                    throw throwable4;
                }
            }
        }
        finally {
            executor.shutdownNow();
        }
    }

    private final void replaceDbconfigUrl(SshConnection connection, String dbconfigXml) {
        new Sed().replace(connection, "(<url>.*(@(//)?|//))([^:/]+)(.*</url>)", "\\1" + this.databaseIp + "\\5", dbconfigXml);
        new Sed().replace(connection, "(<url>.*\\?.*)(sessionVariables=).*(=InnoDB)(.*</url>)", "\\1\\2default_storage_engine\\3\\4", dbconfigXml);
    }

    private final void downloadMysqlConnector(String url, SshConnection connection) {
        IdempotentAction idempotentAction = new IdempotentAction("Download MySQL connector", (Function0)new Function0<SshConnection.SshResult>(connection, url){
            final /* synthetic */ SshConnection $connection;
            final /* synthetic */ String $url;

            @NotNull
            public final SshConnection.SshResult invoke() {
                return this.$connection.execute("wget -q " + this.$url);
            }
            {
                this.$connection = sshConnection;
                this.$url = string;
                super(0);
            }
        });
        Duration duration = Duration.ofSeconds(5L);
        Intrinsics.checkExpressionValueIsNotNull((Object)duration, (String)"Duration.ofSeconds(5)");
        idempotentAction.retry(3, (Backoff)new StaticBackoff(duration));
    }

    public StandaloneNodeFormula(@NotNull JiraHomeSource jiraHomeSource, @NotNull Storage pluginsTransport, @NotNull Storage resultsTransport, @NotNull String databaseIp, @NotNull ProductDistribution productDistribution, @NotNull Ssh ssh, boolean waitForUpgrades, @NotNull JiraNodeConfig config, @NotNull Computer computer, @NotNull String adminPasswordPlainText) {
        Intrinsics.checkParameterIsNotNull((Object)jiraHomeSource, (String)"jiraHomeSource");
        Intrinsics.checkParameterIsNotNull((Object)pluginsTransport, (String)"pluginsTransport");
        Intrinsics.checkParameterIsNotNull((Object)resultsTransport, (String)"resultsTransport");
        Intrinsics.checkParameterIsNotNull((Object)databaseIp, (String)"databaseIp");
        Intrinsics.checkParameterIsNotNull((Object)productDistribution, (String)"productDistribution");
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        Intrinsics.checkParameterIsNotNull((Object)computer, (String)"computer");
        Intrinsics.checkParameterIsNotNull((Object)adminPasswordPlainText, (String)"adminPasswordPlainText");
        this.jiraHomeSource = jiraHomeSource;
        this.pluginsTransport = pluginsTransport;
        this.resultsTransport = resultsTransport;
        this.databaseIp = databaseIp;
        this.productDistribution = productDistribution;
        this.ssh = ssh;
        this.waitForUpgrades = waitForUpgrades;
        this.config = config;
        this.computer = computer;
        this.adminPasswordPlainText = adminPasswordPlainText;
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.jdk = this.config.getJdk();
        this.ubuntu = new Ubuntu();
        this.name = this.config.getName();
    }

    @NotNull
    public static final /* synthetic */ Ssh access$getSsh$p(StandaloneNodeFormula $this) {
        return $this.ssh;
    }

    @NotNull
    public static final /* synthetic */ ProductDistribution access$getProductDistribution$p(StandaloneNodeFormula $this) {
        return $this.productDistribution;
    }

    @NotNull
    public static final /* synthetic */ JiraHomeSource access$getJiraHomeSource$p(StandaloneNodeFormula $this) {
        return $this.jiraHomeSource;
    }
}

