/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.storage;

import com.atlassian.performance.tools.awsinfrastructure.api.storage.ApplicationStorage;
import com.atlassian.performance.tools.awsinfrastructure.api.storage.S3Artifact;
import com.atlassian.performance.tools.ssh.api.SshConnection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Deprecated(message="Use `com.atlassian.performance.tools.infrastructure.api.distribution.PublicJiraSoftwareDistribution` instead.")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/JiraSoftwareStorage;", "Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/ApplicationStorage;", "version", "", "(Ljava/lang/String;)V", "archiveName", "possibleLocations", "", "Lcom/atlassian/performance/tools/awsinfrastructure/api/storage/S3Artifact;", "getPossibleLocations", "()Ljava/util/List;", "aws-infrastructure"})
public final class JiraSoftwareStorage
implements ApplicationStorage {
    private final String archiveName;
    @NotNull
    private final List<S3Artifact> possibleLocations;

    @Override
    @NotNull
    public List<S3Artifact> getPossibleLocations() {
        return this.possibleLocations;
    }

    public JiraSoftwareStorage(@NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        this.archiveName = "atlassian-jira-software-" + version + ".tar.gz";
        this.possibleLocations = CollectionsKt.listOf((Object[])new S3Artifact[]{new S3Artifact("us-east-1", "downloads-public-us-east-1", "software/jira/downloads", this.archiveName), new S3Artifact("eu-central-1", "jira-server-jpt", "software/jira/downloads", this.archiveName), new S3Artifact("us-east-1", "downloads-internal-us-east-1", "private/jira/" + version, "atlassian-jira-software-" + version + "-standalone.tar.gz")});
    }

    @Override
    @NotNull
    public String download(@NotNull SshConnection ssh, @NotNull String target) {
        Intrinsics.checkParameterIsNotNull((Object)ssh, (String)"ssh");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        return ApplicationStorage.DefaultImpls.download(this, ssh, target);
    }
}

