/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.network.access;

import com.amazonaws.http.SdkHttpMetadata;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressResult;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.IpRange;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.AccessProvider;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001\u0012B'\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\tH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/SecurityGroupIngressAccessProvider;", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/AccessProvider;", "ec2", "Lcom/amazonaws/services/ec2/AmazonEC2;", "securityGroup", "Lcom/amazonaws/services/ec2/model/SecurityGroup;", "portRange", "Lkotlin/ranges/IntRange;", "protocol", "", "(Lcom/amazonaws/services/ec2/AmazonEC2;Lcom/amazonaws/services/ec2/model/SecurityGroup;Lkotlin/ranges/IntRange;Ljava/lang/String;)V", "baseIpPermissions", "Lcom/amazonaws/services/ec2/model/IpPermission;", "kotlin.jvm.PlatformType", "provideAccess", "", "ipPermissions", "cidr", "Builder", "aws-infrastructure"})
public final class SecurityGroupIngressAccessProvider
implements AccessProvider {
    private final AmazonEC2 ec2;
    private final SecurityGroup securityGroup;
    private final IntRange portRange;
    private final String protocol;

    @Override
    public boolean provideAccess(@NotNull String cidr) {
        Intrinsics.checkParameterIsNotNull((Object)cidr, (String)"cidr");
        IpPermission ipPermission = this.baseIpPermissions().withIpv4Ranges(new IpRange[]{new IpRange().withCidrIp(cidr)});
        Intrinsics.checkExpressionValueIsNotNull((Object)ipPermission, (String)"baseIpPermissions()\n    \u2026Range().withCidrIp(cidr))");
        return this.provideAccess(ipPermission);
    }

    @Override
    public boolean provideAccess(@NotNull SecurityGroup securityGroup) {
        Intrinsics.checkParameterIsNotNull((Object)securityGroup, (String)"securityGroup");
        IpPermission ipPermission = this.baseIpPermissions().withUserIdGroupPairs(new UserIdGroupPair[]{new UserIdGroupPair().withUserId(securityGroup.getOwnerId()).withGroupId(securityGroup.getGroupId())});
        Intrinsics.checkExpressionValueIsNotNull((Object)ipPermission, (String)"baseIpPermissions()\n    \u2026up.groupId)\n            )");
        return this.provideAccess(ipPermission);
    }

    private final IpPermission baseIpPermissions() {
        return new IpPermission().withIpProtocol("tcp").withFromPort(Integer.valueOf(this.portRange.getFirst())).withToPort(Integer.valueOf(this.portRange.getLast())).withIpProtocol(this.protocol);
    }

    private final boolean provideAccess(IpPermission ipPermissions) {
        AuthorizeSecurityGroupIngressResult authorizeSecurityGroupIngressResult = this.ec2.authorizeSecurityGroupIngress(new AuthorizeSecurityGroupIngressRequest().withGroupId(this.securityGroup.getGroupId()).withIpPermissions(new IpPermission[]{ipPermissions}));
        Intrinsics.checkExpressionValueIsNotNull((Object)authorizeSecurityGroupIngressResult, (String)"ec2.authorizeSecurityGro\u2026ions(ipPermissions)\n    )");
        SdkHttpMetadata sdkHttpMetadata = authorizeSecurityGroupIngressResult.getSdkHttpMetadata();
        Intrinsics.checkExpressionValueIsNotNull((Object)sdkHttpMetadata, (String)"ec2.authorizeSecurityGro\u2026ns)\n    ).sdkHttpMetadata");
        return sdkHttpMetadata.getHttpStatusCode() / 100 == 2;
    }

    private SecurityGroupIngressAccessProvider(AmazonEC2 ec2, SecurityGroup securityGroup, IntRange portRange, String protocol) {
        this.ec2 = ec2;
        this.securityGroup = securityGroup;
        this.portRange = portRange;
        this.protocol = protocol;
    }

    public /* synthetic */ SecurityGroupIngressAccessProvider(@NotNull AmazonEC2 ec2, @NotNull SecurityGroup securityGroup, @NotNull IntRange portRange, @NotNull String protocol, DefaultConstructorMarker $constructor_marker) {
        this(ec2, securityGroup, portRange, protocol);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/SecurityGroupIngressAccessProvider$Builder;", "", "ec2", "Lcom/amazonaws/services/ec2/AmazonEC2;", "securityGroup", "Lcom/amazonaws/services/ec2/model/SecurityGroup;", "portRange", "Lkotlin/ranges/IntRange;", "(Lcom/amazonaws/services/ec2/AmazonEC2;Lcom/amazonaws/services/ec2/model/SecurityGroup;Lkotlin/ranges/IntRange;)V", "protocol", "", "build", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/access/SecurityGroupIngressAccessProvider;", "aws-infrastructure"})
    public static final class Builder {
        private String protocol;
        private final AmazonEC2 ec2;
        private final SecurityGroup securityGroup;
        private final IntRange portRange;

        @NotNull
        public final Builder protocol(@NotNull String protocol) {
            Builder builder;
            Intrinsics.checkParameterIsNotNull((Object)protocol, (String)"protocol");
            Builder $receiver = builder = this;
            $receiver.protocol = protocol;
            return builder;
        }

        @NotNull
        public final SecurityGroupIngressAccessProvider build() {
            return new SecurityGroupIngressAccessProvider(this.ec2, this.securityGroup, this.portRange, this.protocol, null);
        }

        public Builder(@NotNull AmazonEC2 ec2, @NotNull SecurityGroup securityGroup, @NotNull IntRange portRange) {
            Intrinsics.checkParameterIsNotNull((Object)ec2, (String)"ec2");
            Intrinsics.checkParameterIsNotNull((Object)securityGroup, (String)"securityGroup");
            Intrinsics.checkParameterIsNotNull((Object)portRange, (String)"portRange");
            this.ec2 = ec2;
            this.securityGroup = securityGroup;
            this.portRange = portRange;
            this.protocol = "tcp";
        }
    }
}

