/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.network;

import com.amazonaws.services.cloudformation.model.Parameter;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.ProvisionedStack;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.StackFormula;
import com.atlassian.performance.tools.aws.api.UnallocatedResource;
import com.atlassian.performance.tools.awsinfrastructure.AvaliabilityZonePickerKt;
import com.atlassian.performance.tools.awsinfrastructure.api.network.Network;
import com.atlassian.performance.tools.awsinfrastructure.api.network.ProvisionedNetwork;
import com.atlassian.performance.tools.io.api.ClasspathResourcesKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\n\u001a\u00020\u000bH\u0007J\u0006\u0010\f\u001a\u00020\rJ\u0017\u0010\u000e\u001a\u00020\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000bH\u0000\u00a2\u0006\u0002\b\u0010R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/network/NetworkFormula;", "", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "(Lcom/atlassian/performance/tools/aws/api/Investment;Lcom/atlassian/performance/tools/aws/api/Aws;)V", "logger", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "provision", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/Network;", "provisionAsResource", "Lcom/atlassian/performance/tools/awsinfrastructure/api/network/ProvisionedNetwork;", "reuseOrProvision", "existing", "reuseOrProvision$aws_infrastructure", "aws-infrastructure"})
public final class NetworkFormula {
    private final Logger logger;
    private final Investment investment;
    private final Aws aws;

    @NotNull
    public final ProvisionedNetwork provisionAsResource() {
        StackFormula stackFormula = new StackFormula(this.investment, this.aws, ClasspathResourcesKt.readResourceText((String)"aws/network.yaml"), CollectionsKt.listOf((Object)new Parameter().withParameterKey("AvailabilityZone").withParameterValue(AvaliabilityZonePickerKt.pickAvailabilityZone(this.aws).getZoneName())), null, null, 48, null);
        this.logger.info("Provisioning network...");
        ProvisionedStack stack2 = stackFormula.provision();
        Network network = new Network(stack2.findVpc("Vpc"), stack2.findSubnet("TheOnlySubnet"));
        this.logger.info("Network provisioned");
        this.logger.debug("Network provisioned: " + network);
        return new ProvisionedNetwork(network, (Resource)stack2);
    }

    @NotNull
    public final ProvisionedNetwork reuseOrProvision$aws_infrastructure(@Nullable Network existing) {
        return existing != null ? new ProvisionedNetwork(existing, (Resource)new UnallocatedResource()) : this.provisionAsResource();
    }

    @Deprecated(message="Allocates AWS resources, use provisionAsResource to release the resource", replaceWith=@ReplaceWith(imports={}, expression="provisionAsResource().network"))
    @NotNull
    public final Network provision() {
        return this.provisionAsResource().getNetwork();
    }

    public NetworkFormula(@NotNull Investment investment, @NotNull Aws aws) {
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        this.investment = investment;
        this.aws = aws;
        this.logger = LogManager.getLogger(this.getClass());
    }
}

