/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.CreateSecurityGroupRequest;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.Instance;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.SecurityGroup;
import com.amazonaws.services.ec2.model.ShutdownBehavior;
import com.amazonaws.services.ec2.model.Subnet;
import com.amazonaws.services.ec2.model.Vpc;
import com.atlassian.performance.tools.aws.api.AwaitingEc2;
import com.atlassian.performance.tools.aws.api.Aws;
import com.atlassian.performance.tools.aws.api.DependentResources;
import com.atlassian.performance.tools.aws.api.Ec2SecurityGroup;
import com.atlassian.performance.tools.aws.api.Investment;
import com.atlassian.performance.tools.aws.api.Resource;
import com.atlassian.performance.tools.aws.api.SshInstance;
import com.atlassian.performance.tools.aws.api.SshKey;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.ApacheProxyLoadBalancer;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.LoadBalancerFormula;
import com.atlassian.performance.tools.awsinfrastructure.api.loadbalancer.ProvisionedLoadBalancer;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.ForIpAccessRequester;
import com.atlassian.performance.tools.awsinfrastructure.api.network.access.SecurityGroupIngressAccessProvider;
import com.atlassian.performance.tools.ssh.api.Ssh;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/ApacheEc2LoadBalancerFormula;", "Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/LoadBalancerFormula;", "()V", "balancerPort", "", "logger", "Lorg/apache/logging/log4j/Logger;", "provision", "Lcom/atlassian/performance/tools/awsinfrastructure/api/loadbalancer/ProvisionedLoadBalancer;", "investment", "Lcom/atlassian/performance/tools/aws/api/Investment;", "instances", "", "Lcom/amazonaws/services/ec2/model/Instance;", "vpc", "Lcom/amazonaws/services/ec2/model/Vpc;", "subnet", "Lcom/amazonaws/services/ec2/model/Subnet;", "key", "Lcom/atlassian/performance/tools/aws/api/SshKey;", "aws", "Lcom/atlassian/performance/tools/aws/api/Aws;", "aws-infrastructure"})
public final class ApacheEc2LoadBalancerFormula
implements LoadBalancerFormula {
    private final Logger logger;
    private final int balancerPort = 80;

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public ProvisionedLoadBalancer provision(@NotNull Investment investment, @NotNull List<? extends Instance> instances, @NotNull Vpc vpc, @NotNull Subnet subnet, @NotNull SshKey key, @NotNull Aws aws) {
        void resource;
        Collection<URI> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        void ssh;
        Intrinsics.checkParameterIsNotNull((Object)investment, (String)"investment");
        Intrinsics.checkParameterIsNotNull(instances, (String)"instances");
        Intrinsics.checkParameterIsNotNull((Object)vpc, (String)"vpc");
        Intrinsics.checkParameterIsNotNull((Object)subnet, (String)"subnet");
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Intrinsics.checkParameterIsNotNull((Object)aws, (String)"aws");
        this.logger.info("Setting up Apache load balancer...");
        AmazonEC2 ec2 = aws.getEc2();
        AwaitingEc2 awaitingEc2 = aws.getAwaitingEc2();
        CreateSecurityGroupRequest createSecurityGroupRequest = new CreateSecurityGroupRequest().withGroupName((String)investment.getReuseKey().invoke() + "-HttpListener").withDescription("Load balancer security group").withVpcId(vpc.getVpcId());
        Intrinsics.checkExpressionValueIsNotNull((Object)createSecurityGroupRequest, (String)"CreateSecurityGroupReque\u2026    .withVpcId(vpc.vpcId)");
        SecurityGroup securityGroup = awaitingEc2.allocateSecurityGroup(investment, createSecurityGroupRequest);
        SshInstance sshInstance = aws.getAwaitingEc2().allocateInstance(investment, key, vpc.getVpcId(), (Function1)new Function1<RunInstancesRequest, RunInstancesRequest>(securityGroup, subnet, aws){
            final /* synthetic */ SecurityGroup $securityGroup;
            final /* synthetic */ Subnet $subnet;
            final /* synthetic */ Aws $aws;

            public final RunInstancesRequest invoke(@NotNull RunInstancesRequest launch) {
                Intrinsics.checkParameterIsNotNull((Object)launch, (String)"launch");
                RunInstancesRequest runInstancesRequest = launch.withInstanceInitiatedShutdownBehavior(ShutdownBehavior.Terminate).withSecurityGroupIds(new String[]{this.$securityGroup.getGroupId()}).withSubnetId(this.$subnet.getSubnetId()).withInstanceType(InstanceType.M5Large).withIamInstanceProfile(new IamInstanceProfileSpecification().withName(this.$aws.shortTermStorageAccess()));
                Intrinsics.checkExpressionValueIsNotNull((Object)runInstancesRequest, (String)"launch\n                 \u2026hortTermStorageAccess()))");
                return runInstancesRequest;
            }
            {
                this.$securityGroup = securityGroup;
                this.$subnet = subnet;
                this.$aws = aws;
                super(1);
            }
        });
        Ssh ssh2 = sshInstance.component1();
        Resource resource2 = sshInstance.component2();
        Instance instance = sshInstance.component3();
        key.getFile().facilitateSsh(ssh.getHost().getIpAddress());
        Iterable iterable = instances;
        ApacheProxyLoadBalancer.Builder builder = new ApacheProxyLoadBalancer.Builder((Ssh)ssh);
        void var14_16 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            Instance instance2 = (Instance)item$iv$iv;
            collection = destination$iv$iv;
            URI uRI = new URI("http://" + it.getPublicIpAddress() + ":8080/");
            collection.add(uRI);
        }
        collection = (List)destination$iv$iv;
        ApacheProxyLoadBalancer.Builder builder2 = builder.nodes((List<URI>)collection);
        String string = instance.getPublicIpAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"instance.publicIpAddress");
        ApacheProxyLoadBalancer loadBalancer = builder2.ipAddress(string).build();
        loadBalancer.provision();
        this.logger.info("Apache load balancer is set up");
        int n = this.balancerPort;
        return new ProvisionedLoadBalancer.Builder(loadBalancer).resource((Resource)new DependentResources((Resource)resource, (Resource)new Ec2SecurityGroup(securityGroup, ec2))).accessProvider(new SecurityGroupIngressAccessProvider.Builder(aws.getEc2(), securityGroup, new IntRange(n, this.balancerPort)).build()).accessRequester(new ForIpAccessRequester((Function0<String>)((Function0)new Function0<String>(instance){
            final /* synthetic */ Instance $instance;

            public final String invoke() {
                String string = this.$instance.getPublicIpAddress();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"instance.publicIpAddress");
                return string;
            }
            {
                this.$instance = instance;
                super(0);
            }
        }))).build();
    }

    public ApacheEc2LoadBalancerFormula() {
        Logger logger = LogManager.getLogger(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LogManager.getLogger(this::class.java)");
        this.logger = logger;
        this.balancerPort = 80;
    }
}

